/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class StoneMoundFeature
extends Feature<BlockStateConfiguration> {
    public StoneMoundFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        float randFloat = rand.nextFloat();
        BlockState state = (double)randFloat >= 0.95 ? Blocks.GRANITE.defaultBlockState() : ((double)randFloat >= 0.9 ? Blocks.ANDESITE.defaultBlockState() : ((double)randFloat >= 0.85 ? Blocks.DIORITE.defaultBlockState() : ((BlockStateConfiguration)context.config()).state));
        int height = 2 + rand.nextInt(60);
        double width = 1 + height / 2;
        int radius = (int)width * 2;
        double maxJ = width + (double)rand.nextInt(10);
        double maxK = width + (double)rand.nextInt(10);
        if (!level.getBlockState(pos.below(15)).isSolid()) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            int j = 0;
            while ((double)j < maxJ) {
                int k = 0;
                while ((double)k < maxK) {
                    double doubleX = (double)j - maxJ / 2.0;
                    double doubleZ = (double)k - maxK / 2.0;
                    int x = (int)doubleX;
                    int z = (int)doubleZ;
                    if (doubleX * doubleX + doubleZ * doubleZ <= (double)radius) {
                        this.setBlock((LevelWriter)level, pos.offset(x, i - 10, z), state);
                        this.setBlock((LevelWriter)level, pos.offset(x, -i - 10, z), state);
                    }
                    ++k;
                }
                ++j;
            }
            --radius;
            if (!rand.nextBoolean()) continue;
            --radius;
        }
        return true;
    }
}

