/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.world.gen.feature.MSStructureProcessorTypes;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class StructureBlockRegistryProcessor
extends StructureProcessor {
    public static final MapCodec<StructureBlockRegistryProcessor> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final StructureBlockRegistryProcessor INSTANCE = new StructureBlockRegistryProcessor();

    private StructureBlockRegistryProcessor() {
    }

    public List<StructureTemplate.StructureBlockInfo> finalizeProcessing(ServerLevelAccessor levelAccessor, BlockPos pOffset, BlockPos pPos, List<StructureTemplate.StructureBlockInfo> originals, List<StructureTemplate.StructureBlockInfo> currents, StructurePlaceSettings placementSettings) {
        ServerLevel serverLevel = levelAccessor.getLevel();
        ChunkGenerator chunkGenerator = serverLevel.getChunkSource().getGenerator();
        StructureBlockRegistry blockRegistry = StructureBlockRegistry.getOrDefault(chunkGenerator);
        for (int i = 0; i < originals.size(); ++i) {
            StructureTemplate.StructureBlockInfo original = originals.get(i);
            StructureTemplate.StructureBlockInfo current = currents.get(i);
            if (original.state() != current.state() && !original.state().is(Blocks.JIGSAW)) continue;
            BlockState newState = blockRegistry.getTemplateState(current.state());
            currents.set(i, new StructureTemplate.StructureBlockInfo(current.pos(), newState, current.nbt()));
        }
        return currents;
    }

    protected StructureProcessorType<StructureBlockRegistryProcessor> getType() {
        return MSStructureProcessorTypes.BLOCK_REGISTRY.get();
    }
}

