/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.world.gen.feature.TemplatePlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SulfurPoolFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation SULFUR_POOL = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"sulfur_pool");
    private static final ResourceLocation LARGE_SULFUR_POOL = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"large_sulfur_pool");

    public SulfurPoolFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private static ResourceLocation pickTemplate(RandomSource random) {
        return random.nextBoolean() ? SULFUR_POOL : LARGE_SULFUR_POOL;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos centerPos;
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        StructureTemplate template = context.level().getLevel().getStructureManager().getOrCreate(SulfurPoolFeature.pickTemplate(rand));
        TemplatePlacement placement = TemplatePlacement.centeredWithRandomRotation(template, centerPos = context.origin(), rand);
        if (placement.heightRange(Heightmap.Types.OCEAN_FLOOR, (LevelReader)context.level()).difference() > 3) {
            return false;
        }
        int y = placement.minHeight(Heightmap.Types.WORLD_SURFACE_WG, (LevelReader)level);
        placement.placeAt(y, context);
        return true;
    }
}

