/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.world.gen.feature.TemplatePlacement;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TowerFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation STRUCTURE_TOWER = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"tower");
    private static final ResourceLocation STRUCTURE_TOWER_WITH_CHEST = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"tower_with_chest");
    private static final ResourceLocation STRUCTURE_TOWER_WALL = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"tower_wall");
    private static final ResourceLocation STRUCTURE_ELEVATED_TOWER_DOOR = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"elevated_tower_door");
    private static final ResourceLocation STRUCTURE_TOWER_DOOR = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"tower_door");
    private static final ResourceLocation STRUCTURE_TOWER_BALCONY = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"tower_balcony");
    private static final BlockPos DOOR_CHECK_OFFSET = new BlockPos(0, 0, 4);
    private static final BlockPos DOOR_PLACE_OFFSET = new BlockPos(0, 0, 3);

    public TowerFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos towerPos = context.origin().below(2);
        RandomSource rand = context.random();
        ResourceLocation templateId = rand.nextInt(50) == 0 ? STRUCTURE_TOWER_WITH_CHEST : STRUCTURE_TOWER;
        StructureTemplate template = level.getLevel().getStructureManager().getOrCreate(templateId);
        TemplatePlacement placement = TemplatePlacement.centeredWithRandomRotation(template, towerPos, rand);
        placement.placeWithStructureBlockRegistry(context);
        placement.handleDataMarkers(context, (pos, data) -> this.handleDataMarker(level, rand, (BlockPos)pos, (String)data));
        for (Rotation doorRotation : Rotation.values()) {
            this.placeDoor(context, towerPos, doorRotation);
        }
        return true;
    }

    private void placeDoor(FeaturePlaceContext<?> context, BlockPos towerCenter, Rotation rotation) {
        BlockPos doorPos = towerCenter.offset((Vec3i)DOOR_PLACE_OFFSET.rotate(rotation));
        StructureTemplate template = context.level().getLevel().getStructureManager().getOrCreate(this.getDoorTemplate(context.level(), towerCenter, rotation));
        TemplatePlacement.edgeCentered(template, doorPos, rotation).placeWithStructureBlockRegistry(context);
    }

    @Nonnull
    private ResourceLocation getDoorTemplate(WorldGenLevel level, BlockPos towerCenter, Rotation rotation) {
        BlockPos doorCheckPos = towerCenter.offset((Vec3i)DOOR_CHECK_OFFSET.rotate(rotation));
        if (level.getBlockState(doorCheckPos.above(3)).canOcclude()) {
            return STRUCTURE_TOWER_WALL;
        }
        if (level.getBlockState(doorCheckPos.above(2)).canOcclude()) {
            return STRUCTURE_ELEVATED_TOWER_DOOR;
        }
        if (level.getBlockState(doorCheckPos.above()).canOcclude()) {
            return STRUCTURE_TOWER_DOOR;
        }
        return STRUCTURE_TOWER_BALCONY;
    }

    private void handleDataMarker(WorldGenLevel level, RandomSource rand, BlockPos pos, String data) {
        if (data.equals("basic_chest")) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            BlockEntity blockEntity = level.getBlockEntity(pos.below());
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                chest.setLootTable(MSLootTables.BASIC_MEDIUM_CHEST, rand.nextLong());
            }
        }
    }
}

