/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;

public class VeilCraterFeature
extends Feature<NoneFeatureConfiguration> {
    public VeilCraterFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        int radius = rand.nextInt(6, 18);
        pos = pos.above(radius / 2);
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    boolean shouldBeReplaced;
                    BlockPos iteratePos = pos.offset(x, y, z);
                    boolean bl = shouldBeReplaced = !level.isFluidAtPosition(iteratePos, FluidState::isSource) && !level.isEmptyBlock(iteratePos);
                    if (!iteratePos.closerThan((Vec3i)pos, (double)radius) || !shouldBeReplaced || !level.isAreaLoaded(iteratePos, 0)) continue;
                    level.destroyBlock(iteratePos, false);
                }
            }
        }
        return true;
    }
}

