/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature.tree;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.plant.DoubleLogBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EndTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public EndTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos position = context.origin();
        if (((BushBlock)MSBlocks.END_SAPLING.get()).defaultBlockState().canSurvive((LevelReader)level, position) && this.subGenerate(level, context.random(), position, position, 5, 0, 4)) {
            this.setLog(level, position);
            return true;
        }
        return false;
    }

    private boolean subGenerate(WorldGenLevel level, RandomSource rand, BlockPos curr, BlockPos origin, int range, int step, int maxSteps) {
        int y;
        int height = rand.nextInt(Math.max(1, 4 - step)) + 1;
        if (step == 0) {
            ++height;
        }
        for (y = 1; y < height; ++y) {
            if (EndTreeFeature.areAllNeighborsEmpty((LevelSimulatedReader)level, curr.above(y), null)) continue;
            return false;
        }
        for (y = 1; y < height; ++y) {
            this.setLog(level, curr.above(y));
        }
        boolean flag = false;
        if (step < maxSteps) {
            int buds = rand.nextInt(4);
            if (step == 0) {
                ++buds;
            }
            for (int k = 0; k < buds; ++k) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(rand);
                BlockPos nextPos = curr.above(height).relative(direction);
                if (Math.abs(nextPos.getX() - origin.getX()) >= range || Math.abs(nextPos.getZ() - origin.getZ()) >= range || !TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)nextPos) || !TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)nextPos.below()) || !EndTreeFeature.areAllNeighborsEmpty((LevelSimulatedReader)level, nextPos, direction.getOpposite())) continue;
                flag = true;
                Direction.Axis axis = direction.getAxis();
                this.setLog(level, nextPos, axis);
                this.subGenerate(level, rand, nextPos, origin, range, step + 1, maxSteps);
                this.generateLeaves(level, nextPos, Direction.Axis.Y, axis);
                nextPos = curr.above(height);
                this.setLog(level, nextPos, axis);
            }
        }
        if (!flag) {
            this.generateLeaves(level, curr.above(height), Direction.Axis.Y, Direction.Axis.Y);
            this.setLog(level, curr.above(height));
        }
        return true;
    }

    private static boolean areAllNeighborsEmpty(LevelSimulatedReader level, BlockPos pos, Direction excludingSide) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == excludingSide || TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)pos.relative(direction))) continue;
            return false;
        }
        return true;
    }

    public void generateLeaves(WorldGenLevel level, BlockPos pos, Direction.Axis primary, Direction.Axis secondary) {
        if (primary == Direction.Axis.X || secondary == Direction.Axis.X) {
            this.leaves(level, pos.east(), 2);
            this.leaves(level, pos.west(), 2);
        }
        if (primary == Direction.Axis.Y || secondary == Direction.Axis.Y) {
            this.leaves(level, pos.above(), 1);
            this.leaves(level, pos.below(), 1);
        }
        if (primary == Direction.Axis.Z || secondary == Direction.Axis.Z) {
            this.leaves(level, pos.south(), 1);
            this.leaves(level, pos.north(), 1);
        }
    }

    private void leaves(WorldGenLevel level, BlockPos curr, int distance) {
        if (TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)curr) && distance <= 5) {
            this.setLeaf(level, curr);
            this.leaves(level, curr.south(), distance + 1);
            this.leaves(level, curr.north(), distance + 1);
            this.leaves(level, curr.above(), distance + 1);
            this.leaves(level, curr.below(), distance + 1);
            this.leaves(level, curr.east(), distance + 2);
            this.leaves(level, curr.west(), distance + 2);
        }
    }

    private void setLog(WorldGenLevel level, BlockPos pos) {
        this.setLog(level, pos, Direction.Axis.Y);
    }

    private void setLog(WorldGenLevel level, BlockPos pos, Direction.Axis axis) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            BlockState log = (BlockState)((Block)MSBlocks.END_LOG.get()).defaultBlockState().setValue(DoubleLogBlock.AXIS_2, (Comparable)axis);
            level.setBlock(pos, log, 19);
        }
    }

    private void setLeaf(WorldGenLevel level, BlockPos pos) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            level.setBlock(pos, ((Block)MSBlocks.END_LEAVES.get()).defaultBlockState(), 19);
        }
    }
}

