/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature.tree;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class LeaflessTreeFeature
extends Feature<BlockStateConfiguration> {
    public LeaflessTreeFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        BlockState state = ((BlockStateConfiguration)context.config()).state;
        int size = rand.nextInt(3);
        int height = 4 + size;
        int branchMinHeight = size < 2 ? 1 : 2;
        int branchCount = size + (rand.nextBoolean() ? 2 : 3);
        for (int i = 0; i < branchCount; ++i) {
            int branchHeightStart = branchMinHeight + rand.nextInt(height - branchMinHeight);
            float modifier = (float)(branchHeightStart + 3) * 0.2f;
            int xOffset = Math.round((rand.nextFloat() - rand.nextFloat()) * 4.0f * modifier);
            int yOffset = branchHeightStart + Math.round(rand.nextFloat() * 2.0f * modifier);
            int zOffset = Math.round((rand.nextFloat() - rand.nextFloat()) * 4.0f * modifier);
            this.genBranch(pos.above(branchHeightStart), pos.offset(xOffset, yOffset, zOffset), (LevelAccessor)level, state);
        }
        this.genBranch(pos, pos.above(height), (LevelAccessor)level, state);
        return true;
    }

    protected void genBranch(BlockPos pos0, BlockPos pos1, LevelAccessor level, BlockState logState) {
        Direction.Axis axis;
        int length;
        int xDiff = pos1.getX() - pos0.getX();
        int yDiff = pos1.getY() - pos0.getY();
        int zDiff = pos1.getZ() - pos0.getZ();
        int xLength = Math.abs(xDiff);
        int yLength = Math.abs(yDiff);
        int zLength = Math.abs(zDiff);
        if (xLength >= yLength && xLength >= zLength) {
            length = xLength;
            axis = Direction.Axis.X;
        } else if (yLength >= xLength && yLength >= zLength) {
            length = yLength;
            axis = Direction.Axis.Y;
        } else {
            length = zLength;
            axis = Direction.Axis.Z;
        }
        BlockState state = (BlockState)logState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis);
        for (int i = 0; i < length; ++i) {
            float f = (float)i / (float)length;
            BlockPos pos = pos0.offset(Mth.floor((float)((float)xDiff * f)), Mth.floor((float)((float)yDiff * f)), Mth.floor((float)((float)zDiff * f)));
            if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos) && !level.isStateAtPosition(pos, oldState -> oldState.is(BlockTags.LOGS))) {
                return;
            }
            this.setBlock((LevelWriter)level, pos, state);
        }
    }
}

