/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class CoreCompatibleScatteredStructurePiece
extends ScatteredFeaturePiece {
    private boolean hasBeenCompleted = false;

    public CoreCompatibleScatteredStructurePiece(StructurePieceType structurePieceType, int minX, int minY, int minZ, int sizeX, int sizeY, int sizeZ, Direction orientation) {
        super(structurePieceType, minX, minY, minZ, sizeX, sizeY, sizeZ, orientation);
    }

    public CoreCompatibleScatteredStructurePiece(StructurePieceType structurePieceType, CompoundTag nbt) {
        super(structurePieceType, nbt);
        this.hasBeenCompleted = nbt.getBoolean("hasBeenCompleted");
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        tagCompound.putBoolean("hasBeenCompleted", this.hasBeenCompleted);
        super.addAdditionalSaveData(context, tagCompound);
    }

    public boolean hasBeenCompleted() {
        return this.hasBeenCompleted;
    }

    public void nowCompleted() {
        this.hasBeenCompleted = true;
    }
}

