/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.google.common.collect.Lists;
import com.mraof.minestuck.block.CustomShapeBlock;
import com.mraof.minestuck.block.LotusTimeCapsuleBlock;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.MSDirectionalBlock;
import com.mraof.minestuck.entity.LotusFlowerEntity;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.world.gen.structure.CoreCompatibleScatteredStructurePiece;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FrogTemplePiece
extends CoreCompatibleScatteredStructurePiece {
    private boolean createRan = false;
    private static final Selector HIEROGLYPHS = new Selector();

    public FrogTemplePiece(ChunkGenerator generator, LevelHeightAccessor level, RandomState randomState, RandomSource random, int x, int z) {
        super(MSStructures.FROG_TEMPLE_PIECE.get(), x - 21, 64, z - 35, 42, 100, 70, FrogTemplePiece.getRandomHorizontalDirection((RandomSource)random));
        int posHeightPicked = generator.getBaseHeight((this.boundingBox.minX() + this.boundingBox.maxX()) / 2, (this.boundingBox.minZ() + this.boundingBox.maxZ()) / 2, Heightmap.Types.OCEAN_FLOOR_WG, level, randomState);
        this.boundingBox = this.boundingBox.moved(0, posHeightPicked - this.boundingBox.minY(), 0);
    }

    public FrogTemplePiece(CompoundTag nbt) {
        super(MSStructures.FROG_TEMPLE_PIECE.get(), nbt);
        this.createRan = nbt.getBoolean("createRan");
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        tagCompound.putBoolean("createRan", this.createRan);
        super.addAdditionalSaveData(context, tagCompound);
    }

    public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox boundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
        BlockState wallBlock = ((Block)MSBlocks.GREEN_STONE_BRICKS.get()).defaultBlockState();
        BlockState columnBlock = (BlockState)((Block)MSBlocks.GREEN_STONE_COLUMN.get()).defaultBlockState().setValue((Property)MSDirectionalBlock.FACING, (Comparable)Direction.UP);
        BlockState floorBlock = ((Block)MSBlocks.POLISHED_GREEN_STONE.get()).defaultBlockState();
        BlockState stoneBlock = ((Block)MSBlocks.GREEN_STONE.get()).defaultBlockState();
        this.buildMainPlatform(wallBlock, level, boundingBoxIn);
        this.buildStairsAndUnderneath(wallBlock, level, boundingBoxIn);
        this.buildWallsAndFloors(floorBlock, level, boundingBoxIn, randomIn);
        this.carveRooms(level, boundingBoxIn);
        this.buildIndoorBlocks(columnBlock, level, boundingBoxIn);
        this.generateLoot(level, boundingBoxIn, randomIn, chunkPosIn);
        this.buildFrog(stoneBlock, level, boundingBoxIn);
    }

    private void generateLoot(WorldGenLevel level, BoundingBox box, RandomSource randomIn, ChunkPos chunkPos) {
        this.placeBlock(level, (BlockState)((Block)MSBlocks.LOTUS_TIME_CAPSULE_BLOCK.CORNER.get()).defaultBlockState().setValue((Property)LotusTimeCapsuleBlock.FACING, (Comparable)Direction.EAST), 21, 49, 34, box);
        this.placeBlock(level, (BlockState)((Block)MSBlocks.LOTUS_TIME_CAPSULE_BLOCK.CORNER.get()).defaultBlockState().setValue((Property)LotusTimeCapsuleBlock.FACING, (Comparable)Direction.NORTH), 21, 49, 35, box);
        this.placeBlock(level, (BlockState)((Block)MSBlocks.LOTUS_TIME_CAPSULE_BLOCK.CORNER.get()).defaultBlockState().setValue((Property)LotusTimeCapsuleBlock.FACING, (Comparable)Direction.WEST), 20, 49, 35, box);
        this.placeBlock(level, (BlockState)((Block)MSBlocks.LOTUS_TIME_CAPSULE_BLOCK.CORNER.get()).defaultBlockState().setValue((Property)LotusTimeCapsuleBlock.FACING, (Comparable)Direction.SOUTH), 20, 49, 34, box);
        ChestType leftChestType = ChestType.LEFT;
        ChestType rightChestType = ChestType.RIGHT;
        if (this.getOrientation() == Direction.SOUTH || this.getOrientation() == Direction.WEST) {
            leftChestType = ChestType.RIGHT;
            rightChestType = ChestType.LEFT;
        }
        BlockPos chestFarPos = new BlockPos(this.getWorldX(21, 26), this.getWorldY(21), this.getWorldZ(21, 26));
        this.generateBox(level, box, 20, 20, 26, 21, 20, 26, (BlockState)((BlockState)((StairBlock)MSBlocks.GREEN_STONE_BRICK_STAIRS.get()).defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)Half.TOP)).setValue((Property)StairBlock.FACING, (Comparable)Direction.SOUTH), ((StairBlock)MSBlocks.GREEN_STONE_BRICK_STAIRS.get()).defaultBlockState(), false);
        StructureBlockUtil.placeLootChest(chestFarPos, (LevelAccessor)level, box, this.getOrientation(), rightChestType, MSLootTables.FROG_TEMPLE_CHEST, randomIn);
        chestFarPos = new BlockPos(this.getWorldX(20, 26), this.getWorldY(21), this.getWorldZ(20, 26));
        StructureBlockUtil.placeLootChest(chestFarPos, (LevelAccessor)level, box, this.getOrientation(), leftChestType, MSLootTables.FROG_TEMPLE_CHEST, randomIn);
        BlockPos chestNearDoorPos = new BlockPos(this.getWorldX(11, 43), this.getWorldY(21), this.getWorldZ(11, 43));
        this.generateBox(level, box, 10, 20, 43, 11, 20, 43, (BlockState)((StairBlock)MSBlocks.GREEN_STONE_BRICK_STAIRS.get()).defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)Half.TOP), ((StairBlock)MSBlocks.GREEN_STONE_BRICK_STAIRS.get()).defaultBlockState(), false);
        StructureBlockUtil.placeLootChest(chestNearDoorPos, (LevelAccessor)level, box, this.getOrientation().getOpposite(), leftChestType, MSLootTables.FROG_TEMPLE_CHEST, randomIn);
        chestNearDoorPos = new BlockPos(this.getWorldX(10, 43), this.getWorldY(21), this.getWorldZ(10, 43));
        StructureBlockUtil.placeLootChest(chestNearDoorPos, (LevelAccessor)level, box, this.getOrientation().getOpposite(), rightChestType, MSLootTables.FROG_TEMPLE_CHEST, randomIn);
        Vec3i entityVec = new Vec3i(this.getEntityXWithOffset(21, 35), this.getWorldY(50), this.getEntityZWithOffset(21, 35));
        if (!this.createRan && box.isInside(entityVec)) {
            LotusFlowerEntity lotusFlowerEntity = (LotusFlowerEntity)MSEntityTypes.LOTUS_FLOWER.get().create((Level)level.getLevel());
            if (lotusFlowerEntity == null) {
                throw new IllegalStateException("Unable to create a new lotus flower. Entity factory returned null!");
            }
            lotusFlowerEntity.moveTo(entityVec.getX(), entityVec.getY(), entityVec.getZ(), 0.0f, 0.0f);
            lotusFlowerEntity.setInvulnerable(true);
            level.addFreshEntity((Entity)lotusFlowerEntity);
            this.createRan = true;
        }
    }

    private void buildMainPlatform(BlockState block, WorldGenLevel level, BoundingBox box) {
        for (int a = 0; a < 7; ++a) {
            this.generateBox(level, box, a * 2, 8 * a, a * 2 + 14, (int)(40.0f * (1.0f - (float)a / 20.0f)) + 1, 8 * a + 8, (int)(40.0f * (1.0f - (float)a / 20.0f)) + 1 + 14, block, block, false);
        }
    }

    private void buildStairsAndUnderneath(BlockState block, WorldGenLevel level, BoundingBox boundingBox) {
        int i;
        int pushUp = 0;
        for (i = 0; i < 24; ++i) {
            this.fillWithBlocksCheckWater(level, boundingBox, 17, pushUp, i, 24, pushUp, i, (BlockState)((Block)MSBlocks.STEEP_GREEN_STONE_BRICK_STAIRS_BASE.get()).defaultBlockState().setValue((Property)CustomShapeBlock.FACING, (Comparable)Direction.SOUTH));
            this.fillWithBlocksCheckWater(level, boundingBox, 17, pushUp + 1, i, 24, pushUp + 1, i, (BlockState)((Block)MSBlocks.STEEP_GREEN_STONE_BRICK_STAIRS_TOP.get()).defaultBlockState().setValue((Property)CustomShapeBlock.FACING, (Comparable)Direction.SOUTH));
            this.generateBox(level, boundingBox, 17, pushUp, i + 1, 24, pushUp, 26, ((Block)MSBlocks.GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
            this.generateBox(level, boundingBox, 17, pushUp + 1, i + 1, 24, pushUp + 1, 26, ((Block)MSBlocks.GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
            pushUp += 2;
        }
        this.fillWithBlocksCheckWater(level, boundingBox, 17, 48, 24, 24, 48, 24, (BlockState)((Block)MSBlocks.STEEP_GREEN_STONE_BRICK_STAIRS_BASE.get()).defaultBlockState().setValue((Property)CustomShapeBlock.FACING, (Comparable)Direction.SOUTH));
        this.generateBox(level, boundingBox, 17, -10, 0, 24, -1, 24, ((Block)MSBlocks.GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 0, -10, 14, 41, 0, 55, block, block, false);
        for (i = 0; i < 28; ++i) {
            this.generateBox(level, boundingBox, i, -i - 10, i + 14, 41 - i, -i - 10, 55 - i, block, block, false);
        }
    }

    private void buildWallsAndFloors(BlockState block, WorldGenLevel level, BoundingBox boundingBox, RandomSource rand) {
        this.generateBox(level, boundingBox, 14, 48, 27, 27, 48, 41, block, block, false);
        this.generateBox(level, boundingBox, 13, 50, 27, 28, 54, 42, true, rand, HIEROGLYPHS);
        this.generateBox(level, boundingBox, 13, 49, 27, 28, 49, 42, (BlockState)((Block)MSBlocks.GREEN_STONE_BRICK_TRIM.get()).defaultBlockState().setValue((Property)MSDirectionalBlock.FACING, (Comparable)Direction.UP), ((Block)MSBlocks.GREEN_STONE_BRICK_TRIM.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 13, 55, 27, 28, 55, 42, (BlockState)((Block)MSBlocks.GREEN_STONE_BRICK_TRIM.get()).defaultBlockState().setValue((Property)MSDirectionalBlock.FACING, (Comparable)Direction.DOWN), ((Block)MSBlocks.GREEN_STONE_BRICK_TRIM.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 6, 6, 20, 35, 15, 49, true, rand, HIEROGLYPHS);
        this.generateBox(level, boundingBox, 6, 5, 20, 35, 5, 49, (BlockState)((Block)MSBlocks.GREEN_STONE_BRICK_TRIM.get()).defaultBlockState().setValue((Property)MSDirectionalBlock.FACING, (Comparable)Direction.UP), ((Block)MSBlocks.GREEN_STONE_BRICK_TRIM.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 6, 16, 20, 35, 16, 49, (BlockState)((Block)MSBlocks.GREEN_STONE_BRICK_TRIM.get()).defaultBlockState().setValue((Property)MSDirectionalBlock.FACING, (Comparable)Direction.DOWN), ((Block)MSBlocks.GREEN_STONE_BRICK_TRIM.get()).defaultBlockState(), false);
    }

    private void buildIndoorBlocks(BlockState columnBlock, WorldGenLevel level, BoundingBox boundingBox) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.generateBox(level, boundingBox, 10 + i * 10, 5, 24 + j * 10, 11 + i * 10, 23, 25 + j * 10, (BlockState)columnBlock.setValue((Property)MSDirectionalBlock.FACING, (Comparable)Direction.UP), (BlockState)columnBlock.setValue((Property)MSDirectionalBlock.FACING, (Comparable)Direction.UP), false);
                this.generateBox(level, boundingBox, 8 + i * 10, 16, 22 + j * 10, 13 + i * 10, 16, 27 + j * 10, ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
            }
        }
        this.generateBox(level, boundingBox, 24, 16, 44, 24, 16, 45, ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 30, 16, 41, 31, 16, 41, ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 27, 16, 34, 27, 16, 35, ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 17, 16, 34, 17, 16, 35, ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 10, 16, 31, 11, 16, 31, ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 14, 16, 24, 14, 16, 25, ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), ((Block)MSBlocks.CHISELED_GREEN_STONE_BRICKS.get()).defaultBlockState(), false);
        this.generateBox(level, boundingBox, 20, 5, 49, 21, 16, 49, (BlockState)((Block)MSBlocks.GREEN_STONE_BRICK_EMBEDDED_LADDER.get()).defaultBlockState().setValue((Property)CustomShapeBlock.FACING, (Comparable)Direction.SOUTH), ((Block)MSBlocks.GREEN_STONE_BRICK_EMBEDDED_LADDER.get()).defaultBlockState(), false);
    }

    private void carveRooms(WorldGenLevel level, BoundingBox boundingBox) {
        this.generateAirBox(level, boundingBox, 14, 49, 28, 27, 55, 41);
        this.fillWithAirCheckWater((LevelAccessor)level, boundingBox, 19, 49, 25, 22, 52, 27);
        this.generateAirBox(level, boundingBox, 7, 5, 21, 34, 23, 48);
        this.fillWithAirCheckWater((LevelAccessor)level, boundingBox, 19, 17, 47, 22, 20, 55);
    }

    private void buildFrog(BlockState block, WorldGenLevel level, BoundingBox boundingBox) {
        this.generateBox(level, boundingBox, 23, 57, 28, 27, 58, 31, block, block, false);
        this.generateBox(level, boundingBox, 14, 57, 28, 18, 58, 31, block, block, false);
        this.generateBox(level, boundingBox, 23, 57, 37, 27, 61, 40, block, block, false);
        this.generateBox(level, boundingBox, 14, 57, 37, 18, 61, 40, block, block, false);
        this.generateBox(level, boundingBox, 16, 57, 30, 25, 65, 39, block, block, false);
        this.generateBox(level, boundingBox, 15, 62, 28, 26, 67, 35, block, block, false);
        this.generateBox(level, boundingBox, 23, 65, 29, 27, 68, 33, block, block, false);
        this.generateBox(level, boundingBox, 14, 65, 29, 18, 68, 33, block, block, false);
    }

    protected int getEntityXWithOffset(int x, int z) {
        int posX = this.getWorldX(x, z);
        if (this.getOrientation() == Direction.WEST) {
            ++posX;
        }
        return posX;
    }

    protected int getEntityZWithOffset(int x, int z) {
        int posZ = this.getWorldZ(x, z);
        if (this.getOrientation() == Direction.NORTH) {
            ++posZ;
        }
        return posZ;
    }

    protected void fillWithBlocksCheckWater(WorldGenLevel level, BoundingBox boundingboxIn, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockState blockState) {
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (this.getBlock((BlockGetter)level, x, y, z, boundingboxIn).getFluidState().getType().isSame((Fluid)Fluids.WATER)) {
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                    }
                    this.placeBlock(level, blockState, x, y, z, boundingboxIn);
                }
            }
        }
    }

    protected void fillWithAirCheckWater(LevelAccessor level, BoundingBox structurebb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(this.getWorldX(x, z), this.getWorldY(y), this.getWorldZ(x, z));
                    if (!structurebb.isInside((Vec3i)pos) || this.getBlock((BlockGetter)level, x, y, z, structurebb).getFluidState().getType().isSame((Fluid)Fluids.WATER)) continue;
                    level.removeBlock(pos, false);
                }
            }
        }
    }

    private static List<WeightedEntry.Wrapper<Block>> buildWeightedList() {
        ArrayList weightedBlockList = Lists.newArrayList();
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_FROG.get()), (int)1));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_TURTLE.get()), (int)23));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_SKAIA.get()), (int)23));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_LOTUS.get()), (int)23));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_IGUANA_LEFT.get()), (int)10));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_IGUANA_RIGHT.get()), (int)10));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_NAK_LEFT.get()), (int)10));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_NAK_RIGHT.get()), (int)10));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_SALAMANDER_LEFT.get()), (int)10));
        weightedBlockList.add(WeightedEntry.wrap((Object)((Block)MSBlocks.GREEN_STONE_BRICK_SALAMANDER_RIGHT.get()), (int)10));
        return weightedBlockList;
    }

    static class Selector
    extends StructurePiece.BlockSelector {
        private final List<WeightedEntry.Wrapper<Block>> weightedBlockList = FrogTemplePiece.buildWeightedList();
        private final int totalWeight = WeightedRandom.getTotalWeight(this.weightedBlockList);

        private Selector() {
        }

        public void next(RandomSource rand, int x, int y, int z, boolean wall) {
            WeightedEntry.Wrapper wrappedBlock = (WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)rand, this.weightedBlockList, (int)this.totalWeight).orElseThrow();
            this.next = ((Block)wrappedBlock.data()).defaultBlockState();
        }
    }
}

