/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.MSDirectionalBlock;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class FrogTemplePillarPiece
extends ScatteredFeaturePiece {
    private final boolean eroded;
    private final boolean uraniumFilled;
    private final int randReduction;

    public FrogTemplePillarPiece(RandomSource random, int x, int y, int z) {
        super(MSStructures.FROG_TEMPLE_PILLAR_PIECE.get(), x - 2, y, z - 2, 5, 46, 5, FrogTemplePillarPiece.getRandomHorizontalDirection((RandomSource)random));
        this.eroded = random.nextBoolean();
        this.uraniumFilled = random.nextBoolean();
        this.randReduction = random.nextInt(10);
    }

    public FrogTemplePillarPiece(CompoundTag nbt) {
        super(MSStructures.FROG_TEMPLE_PILLAR_PIECE.get(), nbt);
        this.eroded = nbt.getBoolean("eroded");
        this.uraniumFilled = nbt.getBoolean("uraniumFilled");
        this.randReduction = nbt.getInt("randReduction");
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        tagCompound.putBoolean("eroded", this.eroded);
        tagCompound.putBoolean("uraniumFilled", this.uraniumFilled);
        tagCompound.putInt("randReduction", this.randReduction);
        super.addAdditionalSaveData(context, tagCompound);
    }

    public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGenerator, RandomSource randomIn, BoundingBox boundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
        BlockState columnBlock = (BlockState)((Block)MSBlocks.GREEN_STONE_COLUMN.get()).defaultBlockState().setValue((Property)MSDirectionalBlock.FACING, (Comparable)Direction.UP);
        if (this.eroded) {
            this.generateBox(level, boundingBoxIn, 1, -20, 1, 3, 40 - this.randReduction, 3, columnBlock, columnBlock, false);
        } else {
            Block innerBlock = this.uraniumFilled ? (Block)MSBlocks.URANIUM_BLOCK.get() : (Block)MSBlocks.CRUXITE_BLOCK.get();
            this.generateBox(level, boundingBoxIn, 1, -20, 1, 3, 40, 3, columnBlock, columnBlock, false);
            this.generateBox(level, boundingBoxIn, 0, 41, 0, 4, 45, 4, ((Block)MSBlocks.GREEN_STONE.get()).defaultBlockState(), innerBlock.defaultBlockState(), false);
        }
    }
}

