/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.world.gen.structure.FrogTemplePiece;
import com.mraof.minestuck.world.gen.structure.FrogTemplePillarPiece;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class FrogTempleStructure
extends Structure {
    public static final MapCodec<FrogTempleStructure> CODEC = FrogTempleStructure.simpleCodec(FrogTempleStructure::new);

    public FrogTempleStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return FrogTempleStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, builder -> FrogTempleStructure.generatePieces(builder, context));
    }

    public StructureType<?> type() {
        return MSStructures.FROG_TEMPLE_TYPE.get();
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        FrogTemplePiece mainPiece = new FrogTemplePiece(context.chunkGenerator(), context.heightAccessor(), context.randomState(), (RandomSource)random, context.chunkPos().getMinBlockX(), context.chunkPos().getMinBlockZ());
        builder.addPiece((StructurePiece)mainPiece);
        int y = mainPiece.getBoundingBox().minY();
        int pillarOffset = 40;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (!random.nextBoolean()) continue;
                FrogTemplePillarPiece pillarPiece = new FrogTemplePillarPiece((RandomSource)random, mainPiece.getBoundingBox().minX() + mainPiece.getBoundingBox().getXSpan() / 2 + (pillarOffset - 2 * i * pillarOffset), y, mainPiece.getBoundingBox().minZ() + mainPiece.getBoundingBox().getZSpan() / 2 + (pillarOffset - 2 * j * pillarOffset));
                builder.addPiece((StructurePiece)pillarPiece);
            }
        }
    }
}

