/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mraof.minestuck.world.gen.structure.ImpDungeonPieces;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class ImpDungeonEntryPiece
extends StructurePiece {
    protected boolean definedHeight = false;
    protected int compoHeight;

    public static StructurePiece create(ChunkPos pos, RandomSource rand) {
        return new ImpDungeonEntryPiece(pos.getBlockX(rand.nextInt(16)), pos.getBlockZ(rand.nextInt(16)), ImpDungeonEntryPiece.getRandomHorizontalDirection((RandomSource)rand));
    }

    private ImpDungeonEntryPiece(int x, int z, Direction orientation) {
        super((StructurePieceType)MSStructures.ImpDungeon.ENTRY_PIECE.get(), 0, ImpDungeonEntryPiece.makeBoundingBox((int)x, (int)64, (int)z, (Direction)orientation, (int)6, (int)4, (int)11));
        this.setOrientation(orientation);
    }

    public ImpDungeonEntryPiece(CompoundTag nbt) {
        super((StructurePieceType)MSStructures.ImpDungeon.ENTRY_PIECE.get(), nbt);
        this.definedHeight = nbt.getBoolean("definedHeight");
        this.compoHeight = nbt.getInt("compoHeight");
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        tagCompound.putBoolean("definedHeight", this.definedHeight);
        tagCompound.putInt("compoHeight", this.compoHeight);
    }

    public void addChildren(StructurePiece piece, StructurePieceAccessor builder, RandomSource rand) {
        ImpDungeonPieces.EntryCorridor corridor = ImpDungeonPieces.EntryCorridor.create(this.getOrientation(), this.boundingBox.minX(), this.boundingBox.minZ(), rand);
        this.compoHeight = corridor.getBoundingBox().maxY() - 1;
        builder.addPiece((StructurePiece)corridor);
        corridor.addChildren(piece, builder, rand);
    }

    public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox box, ChunkPos chunkPosIn, BlockPos pos) {
        int x;
        this.checkHeight((LevelAccessor)level, box);
        StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
        BlockState wallBlock = blocks.getBlockState("structure_primary");
        BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
        BlockState floorBlock = blocks.getBlockState("structure_secondary");
        BlockState floorStairs = blocks.getBlockState("structure_secondary_stairs").rotate(Rotation.CLOCKWISE_180);
        BlockState torch = blocks.getBlockState("wall_torch");
        for (x = 1; x < 5; ++x) {
            this.buildFloorTile(floorBlock, x, 0, level, randomIn, box);
        }
        for (int z = 0; z < 5; ++z) {
            this.buildFloorTile(wallBlock, 0, z, level, randomIn, box);
            this.buildFloorTile(wallBlock, 5, z, level, randomIn, box);
            this.buildWall(wallBlock, 0, z, level, randomIn, box, 0);
            this.buildWall(wallBlock, 5, z, level, randomIn, box, 0);
        }
        for (x = 1; x < 5; ++x) {
            this.buildWall(wallBlock, x, 5, level, randomIn, box, 0);
        }
        if (this.getBlock((BlockGetter)level, 1, 2, 5, box) == wallBlock) {
            this.placeBlock(level, wallDecor, 1, 2, 5, box);
        }
        if (this.getBlock((BlockGetter)level, 4, 2, 5, box) == wallBlock) {
            this.placeBlock(level, wallDecor, 4, 2, 5, box);
        }
        this.generateBox(level, box, 1, 0, 1, 1, 0, 4, floorBlock, floorBlock, false);
        this.generateBox(level, box, 4, 0, 1, 4, 0, 4, floorBlock, floorBlock, false);
        this.generateBox(level, box, 1, 0, 5, 4, 0, 5, wallBlock, wallBlock, false);
        this.generateAirBox(level, box, 1, 1, 0, 4, 4, 4);
        this.generateAirBox(level, box, 2, 0, 2, 3, 0, 4);
        this.generateBox(level, box, 2, 0, 1, 3, 0, 1, floorStairs, floorStairs, false);
        this.generateAirBox(level, box, 2, -1, 3, 3, -1, 5);
        this.generateBox(level, box, 2, -1, 2, 3, -1, 2, floorStairs, floorStairs, false);
        this.generateBox(level, box, 1, -1, 6, 4, -1, 6, wallBlock, wallBlock, false);
        this.generateAirBox(level, box, 2, -2, 4, 3, -2, 6);
        this.generateBox(level, box, 2, -2, 3, 3, -2, 3, floorStairs, floorStairs, false);
        this.generateBox(level, box, 1, -2, 7, 4, -2, 10, wallBlock, wallBlock, false);
        this.generateAirBox(level, box, 2, -3, 5, 3, -3, 9);
        this.generateBox(level, box, 2, -3, 4, 3, -3, 4, floorStairs, floorStairs, false);
        this.generateAirBox(level, box, 2, -4, 6, 3, -4, 9);
        this.generateBox(level, box, 2, -4, 5, 3, -4, 5, floorStairs, floorStairs, false);
        this.generateAirBox(level, box, 2, -5, 7, 3, -5, 9);
        this.generateBox(level, box, 2, -5, 6, 3, -5, 6, floorStairs, floorStairs, false);
        this.generateBox(level, box, 1, -6, 6, 4, -6, 8, floorBlock, floorBlock, false);
        this.generateBox(level, box, 1, this.compoHeight - this.boundingBox.minY(), 10, 4, -3, 10, wallBlock, wallBlock, false);
        this.generateBox(level, box, 1, -5, 6, 1, -3, 9, wallBlock, wallBlock, false);
        this.generateBox(level, box, 1, -1, 2, 1, -1, 5, wallBlock, wallBlock, false);
        this.generateBox(level, box, 1, -2, 3, 1, -2, 6, wallBlock, wallBlock, false);
        this.generateBox(level, box, 1, -3, 4, 1, -3, 5, wallBlock, wallBlock, false);
        this.placeBlock(level, wallBlock, 1, -4, 5, box);
        this.generateBox(level, box, 4, -5, 6, 4, -3, 9, wallBlock, wallBlock, false);
        this.generateBox(level, box, 4, -1, 2, 4, -1, 5, wallBlock, wallBlock, false);
        this.generateBox(level, box, 4, -2, 3, 4, -2, 6, wallBlock, wallBlock, false);
        this.generateBox(level, box, 4, -3, 4, 4, -3, 5, wallBlock, wallBlock, false);
        this.placeBlock(level, wallBlock, 4, -4, 5, box);
        this.generateAirBox(level, box, 2, this.compoHeight - this.boundingBox.minY(), 9, 3, -6, 9);
        this.generateBox(level, box, 1, this.compoHeight - this.boundingBox.minY(), 9, 1, -6, 9, wallBlock, wallBlock, false);
        this.generateBox(level, box, 4, this.compoHeight - this.boundingBox.minY(), 9, 4, -6, 9, wallBlock, wallBlock, false);
        this.generateBox(level, box, 1, this.compoHeight - this.boundingBox.minY(), 8, 4, -7, 8, wallBlock, wallBlock, false);
        this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(torch, Direction.EAST), 2, -3, 8, box);
        this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(torch, Direction.WEST), 3, -3, 8, box);
    }

    protected void checkHeight(LevelAccessor level, BoundingBox bb) {
        if (this.definedHeight) {
            return;
        }
        int height = 0;
        int i = 0;
        for (int x = this.boundingBox.minX(); x <= this.boundingBox.maxX(); ++x) {
            for (int z = this.boundingBox.minZ(); z <= this.boundingBox.maxZ(); ++z) {
                if (!bb.isInside((Vec3i)new BlockPos(x, 64, z))) continue;
                int y = Math.max(62, level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z)).getY());
                height += y;
                ++i;
            }
        }
        this.boundingBox.move(0, (height /= i) - this.boundingBox.minY(), 0);
        this.definedHeight = true;
    }

    protected void buildWall(BlockState block, int x, int z, WorldGenLevel level, RandomSource rand, BoundingBox boundingBox, int minY) {
        float f = 0.5f + (float)z * 0.2f;
        for (int y = 1; y < 4; ++y) {
            if (y > minY && rand.nextFloat() >= f) {
                return;
            }
            this.placeBlock(level, block, x, y, z, boundingBox);
            f -= 0.5f;
        }
    }

    protected void buildFloorTile(BlockState block, int x, int z, WorldGenLevel level, RandomSource rand, BoundingBox boundingBox) {
        int y = 0;
        do {
            this.placeBlock(level, block, x, y, z, boundingBox);
        } while (this.boundingBox.minY() + --y >= 0 && !this.getBlock((BlockGetter)level, x, y, z, boundingBox).isSolid());
    }
}

