/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.underling.OgreEntity;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.world.gen.structure.ImprovedStructurePiece;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

@ParametersAreNonnullByDefault
public final class ImpDungeonPieces {
    static boolean generatePartInDirection(int xIndex, int zIndex, Direction direction, int generationDepth, StructureContext ctxt) {
        return ImpDungeonPieces.generatePartAt(xIndex + direction.getStepX(), zIndex + direction.getStepZ(), direction, generationDepth, ctxt);
    }

    static boolean generatePartAt(int xIndex, int zIndex, Direction direction, int generationDepth, StructureContext ctxt) {
        if (Math.abs(xIndex) > 6 || Math.abs(zIndex) > 6) {
            return false;
        }
        StructurePiece structurePiece = ctxt.findPieceInGridSlot(xIndex, zIndex);
        if (structurePiece instanceof ConnectablePiece) {
            ConnectablePiece piece2 = (ConnectablePiece)structurePiece;
            return piece2.connectFrom(direction.getOpposite());
        }
        int corridors = ctxt.corridors;
        BlockPos pos = ctxt.centerPosForGridSlot(xIndex, zIndex);
        Optional<StructurePiece> optionalPiece = ImpDungeonPieces.nextPiece(pos, direction, generationDepth, ctxt);
        optionalPiece.ifPresent(piece -> {
            ctxt.builder.addPiece(piece);
            if (piece instanceof ConnectablePiece) {
                ConnectablePiece connectablePiece = (ConnectablePiece)piece;
                connectablePiece.generateAdjacentPieces((genDirection, depthIncrement) -> ImpDungeonPieces.generatePartInDirection(xIndex, zIndex, genDirection, generationDepth + depthIncrement, ctxt), ctxt.rand);
            }
        });
        ctxt.corridors = corridors;
        return optionalPiece.isPresent();
    }

    private static Optional<StructurePiece> nextPiece(BlockPos pos, Direction direction, int generationDepth, StructureContext ctxt) {
        if (ctxt.rand.nextDouble() >= 1.4 - (double)generationDepth * 0.1) {
            if (ctxt.rand.nextDouble() < 0.3333333333333333) {
                return Optional.of(ImpDungeonPieces.pickRoom(pos, direction, ctxt));
            }
            return Optional.empty();
        }
        double i = ctxt.rand.nextDouble();
        if (i < 1.2 - (double)ctxt.corridors * 0.12) {
            ctxt.corridors += 3;
            return Optional.of(new CrossCorridor(direction, pos, ctxt.rand));
        }
        if (i < 0.96 - (double)ctxt.corridors * 0.06) {
            return Optional.of(ImpDungeonPieces.pickRoom(pos, direction, ctxt));
        }
        --ctxt.corridors;
        return Optional.of(ImpDungeonPieces.pickCorridor(pos, direction, ctxt));
    }

    private static StructurePiece pickCorridor(BlockPos pos, Direction direction, StructureContext ctxt) {
        if (ctxt.rand.nextBoolean()) {
            return TurnCorridor.create(direction, pos, ctxt.rand);
        }
        double i = ctxt.rand.nextFloat();
        if (i < 0.2) {
            return new SpawnerCorridor(direction, pos, ctxt.rand);
        }
        if (i < 0.3 && !ctxt.generatedOgreRoom) {
            ctxt.generatedOgreRoom = true;
            return new OgreCorridor(direction, pos, ctxt.rand);
        }
        if (i < 0.4) {
            return new LargeSpawnerCorridor(direction, pos, ctxt.rand);
        }
        return new StraightCorridor(direction, pos, ctxt.rand);
    }

    private static StructurePiece pickRoom(BlockPos pos, Direction direction, StructureContext ctxt) {
        float i = ctxt.rand.nextFloat();
        if (!ctxt.generatedReturn || (double)i < 0.2) {
            ctxt.generatedReturn = true;
            if (ctxt.rand.nextBoolean()) {
                return new ReturnRoom(direction, pos);
            }
            return new ReturnRoomAlt(direction, pos);
        }
        if ((double)i < 0.5) {
            return new BookcaseRoom(direction, pos, ctxt.rand);
        }
        return new SpawnerRoom(direction, pos, ctxt.rand);
    }

    private static EntityType<?> getTypeForSpawners() {
        return (Boolean)MinestuckConfig.SERVER.hardMode.get() != false ? MSEntityTypes.LICH.get() : MSEntityTypes.IMP.get();
    }

    private static BoundingBox makeGridBoundingBox(int minX, int minY, int minZ, int sizeX, int sizeY, int sizeZ, BlockPos centerPos, Direction orientation) {
        int maxX = minX + sizeX - 1;
        int maxY = minY + sizeY - 1;
        int maxZ = minZ + sizeZ - 1;
        int startX = centerPos.getX() - 4;
        int startZ = centerPos.getZ() - 4;
        int endX = startX + 10 - 1;
        int endZ = startZ + 10 - 1;
        int y = centerPos.getY();
        return switch (orientation) {
            case Direction.SOUTH -> new BoundingBox(startX + minX, y + minY, startZ + minZ, startX + maxX, y + maxY, startZ + maxZ);
            case Direction.NORTH -> new BoundingBox(endX - maxX, y + minY, endZ - maxZ, endX - minX, y + maxY, endZ - minZ);
            case Direction.EAST -> new BoundingBox(startX + minZ, y + minY, endZ - maxX, startX + maxZ, y + maxY, endZ - minX);
            case Direction.WEST -> new BoundingBox(endX - maxZ, y + minY, startZ + minX, endX - minZ, y + maxY, startZ + maxX);
            default -> throw new IllegalArgumentException("Invalid orientation");
        };
    }

    public static class StructureContext {
        final BlockPos zeroPos;
        final StructurePieceAccessor builder;
        final RandomSource rand;
        int corridors = 3;
        boolean generatedReturn = false;
        boolean generatedOgreRoom = false;

        public StructureContext(BlockPos centerPos, StructurePieceAccessor builder, RandomSource rand) {
            this.zeroPos = centerPos;
            this.builder = builder;
            this.rand = rand;
        }

        BlockPos centerPosForGridSlot(int xIndex, int zIndex) {
            return this.zeroPos.offset(10 * xIndex, 0, 10 * zIndex);
        }

        @Nullable
        StructurePiece findPieceInGridSlot(int xIndex, int zIndex) {
            BlockPos centerPos = this.centerPosForGridSlot(xIndex, zIndex);
            BoundingBox box = ImpDungeonPieces.makeGridBoundingBox(0, 0, 0, 10, 2, 10, centerPos, Direction.NORTH);
            return this.builder.findCollisionPiece(box);
        }
    }

    public static interface ConnectablePiece {
        public boolean connectFrom(Direction var1);

        default public void generateAdjacentPieces(LocalPieceGenerator generator, RandomSource rand) {
        }
    }

    public static class CrossCorridor
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        private boolean isFrontBlocked;
        private boolean isLeftBlocked;
        private boolean isRightBlocked;
        boolean light;

        CrossCorridor(Direction direction, BlockPos pos, RandomSource rand) {
            super((StructurePieceType)MSStructures.ImpDungeon.CROSS_CORRIDOR_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(0, 0, 0, 10, 6, 10, pos, direction));
            this.setOrientation(direction);
            this.light = rand.nextFloat() < 0.3f;
        }

        @Override
        public void generateAdjacentPieces(LocalPieceGenerator generator, RandomSource rand) {
            Direction orientation = Objects.requireNonNull(this.getOrientation());
            if (rand.nextBoolean()) {
                this.isRightBlocked = !generator.tryGenerateInDirection(orientation.getClockWise(), 1);
                this.isLeftBlocked = !generator.tryGenerateInDirection(orientation.getCounterClockWise(), 1);
            } else {
                this.isLeftBlocked = !generator.tryGenerateInDirection(orientation.getCounterClockWise(), 1);
                this.isRightBlocked = !generator.tryGenerateInDirection(orientation.getClockWise(), 1);
            }
            this.isFrontBlocked = !generator.tryGenerateInDirection(orientation, 2);
        }

        public CrossCorridor(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.CROSS_CORRIDOR_PIECE.get(), nbt);
            this.isRightBlocked = nbt.getBoolean("bl0");
            this.isFrontBlocked = nbt.getBoolean("bl1");
            this.isLeftBlocked = nbt.getBoolean("bl2");
            this.light = nbt.getBoolean("l");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putBoolean("bl0", this.isRightBlocked);
            tagCompound.putBoolean("bl1", this.isFrontBlocked);
            tagCompound.putBoolean("bl2", this.isLeftBlocked);
            tagCompound.putBoolean("l", this.light);
        }

        @Override
        public boolean connectFrom(Direction facing) {
            if (this.getOrientation().getClockWise().equals((Object)facing)) {
                this.isRightBlocked = false;
            } else if (this.getOrientation().equals((Object)facing)) {
                this.isFrontBlocked = false;
            } else if (this.getOrientation().getCounterClockWise().equals((Object)facing)) {
                this.isLeftBlocked = false;
            }
            return true;
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 0, 5, 0, 9, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 4, 3, 0, 5, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 4, 9, 0, 5, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 0, 3, 4, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 0, 6, 4, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 6, 3, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 6, 6, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 3, 2, 4, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 6, 2, 4, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 0, 3, 9, 4, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 0, 6, 9, 4, 6, wallBlock, wallBlock, false);
            this.generateAirBox(level, structureBoundingBoxIn, 4, 1, 0, 5, 3, 9);
            this.generateAirBox(level, structureBoundingBoxIn, 0, 1, 4, 3, 3, 5);
            this.generateAirBox(level, structureBoundingBoxIn, 6, 1, 4, 9, 3, 5);
            this.generateAirBox(level, structureBoundingBoxIn, 4, 4, 4, 5, 4, 5);
            this.generateBox(level, structureBoundingBoxIn, 4, 4, 0, 5, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 4, 3, 5, 4, 3, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 4, 7, 5, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 4, 6, 5, 4, 6, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 4, 4, 2, 4, 5, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 4, 4, 3, 4, 5, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 4, 4, 9, 4, 5, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 4, 4, 6, 4, 5, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 5, 3, 6, 5, 6, wallBlock, wallBlock, false);
            if (this.isRightBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 0, 1, 4, 0, 3, 5, wallBlock, wallBlock, false);
            }
            if (this.isFrontBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 4, 1, 9, 5, 3, 9, wallBlock, wallBlock, false);
            }
            if (this.isLeftBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 9, 1, 4, 9, 3, 5, wallBlock, wallBlock, false);
            }
            if (this.light) {
                BlockState lightBlock = blocks.getBlockState("light_block");
                this.generateBox(level, structureBoundingBoxIn, 4, 5, 4, 5, 5, 5, lightBlock, lightBlock, false);
            }
        }
    }

    public static class TurnCorridor
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        private boolean isBackBlocked;
        private boolean isRightBlocked;
        private final boolean light;
        private boolean direction;

        static TurnCorridor create(Direction orientation, BlockPos pos, RandomSource rand) {
            boolean direction;
            return new TurnCorridor(direction, (direction = rand.nextBoolean()) ? orientation.getClockWise() : orientation, pos, rand);
        }

        private TurnCorridor(boolean direction, Direction orientation, BlockPos pos, RandomSource rand) {
            super((StructurePieceType)MSStructures.ImpDungeon.TURN_CORRIDOR_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(0, 0, 0, 7, 5, 7, pos, orientation));
            this.setOrientation(orientation);
            this.direction = direction;
            this.light = rand.nextFloat() < 0.2f;
        }

        @Override
        public void generateAdjacentPieces(LocalPieceGenerator generator, RandomSource rand) {
            boolean isBlocked;
            Direction orientation = Objects.requireNonNull(this.getOrientation());
            Direction newFacing = this.direction ? orientation.getOpposite() : orientation.getClockWise();
            boolean bl = isBlocked = !generator.tryGenerateInDirection(newFacing, 1);
            if (this.direction) {
                this.isBackBlocked = isBlocked;
            } else {
                this.isRightBlocked = isBlocked;
            }
        }

        public TurnCorridor(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.TURN_CORRIDOR_PIECE.get(), nbt);
            this.isBackBlocked = nbt.getBoolean("bl0");
            this.isRightBlocked = nbt.getBoolean("bl1");
            this.light = nbt.getBoolean("l");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putBoolean("bl0", this.isBackBlocked);
            tagCompound.putBoolean("bl1", this.isRightBlocked);
            tagCompound.putBoolean("l", this.light);
        }

        @Override
        public boolean connectFrom(Direction facing) {
            if (this.getOrientation().getClockWise().equals((Object)facing)) {
                this.isRightBlocked = false;
            } else if (this.getOrientation().getOpposite().equals((Object)facing)) {
                this.isBackBlocked = false;
            } else {
                return false;
            }
            return true;
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 0, 5, 0, 5, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 4, 3, 0, 5, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 0, 6, 4, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 0, 3, 4, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 3, 2, 4, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 6, 5, 4, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 4, 0, 5, 4, 5, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 4, 4, 3, 4, 5, wallBlock, wallBlock, false);
            this.generateAirBox(level, structureBoundingBoxIn, 4, 1, 0, 5, 3, 5);
            this.generateAirBox(level, structureBoundingBoxIn, 0, 1, 4, 3, 3, 5);
            if (this.isBackBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 4, 1, 0, 5, 3, 0, wallBlock, wallBlock, false);
            }
            if (this.isRightBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 0, 1, 4, 0, 3, 5, wallBlock, wallBlock, false);
            }
            if (this.light) {
                BlockState torch = blocks.getBlockState("wall_torch");
                this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(torch, Direction.WEST), 5, 2, 3, structureBoundingBoxIn);
                this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(torch, Direction.NORTH), 3, 2, 5, structureBoundingBoxIn);
            }
        }
    }

    public static class SpawnerCorridor
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        private boolean isFrontBlocked;
        private boolean isBackBlocked;
        private boolean spawner1;
        private boolean spawner2;
        private final boolean chestPos;

        SpawnerCorridor(Direction orientation, BlockPos pos, RandomSource rand) {
            super((StructurePieceType)MSStructures.ImpDungeon.SPAWNER_CORRIDOR_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(2, 0, 0, 6, 5, 10, pos, orientation));
            this.setOrientation(orientation);
            if (rand.nextBoolean()) {
                this.spawner1 = true;
                this.spawner2 = true;
            } else {
                this.spawner1 = rand.nextBoolean();
                this.spawner2 = !this.spawner1;
            }
            this.chestPos = rand.nextBoolean();
        }

        @Override
        public void generateAdjacentPieces(LocalPieceGenerator generator, RandomSource rand) {
            boolean isBlocked;
            Direction orientation = Objects.requireNonNull(this.getOrientation());
            boolean mirror = rand.nextBoolean();
            if (mirror) {
                this.setOrientation(orientation.getOpposite());
            }
            boolean bl = isBlocked = !generator.tryGenerateInDirection(orientation, 1);
            if (mirror) {
                this.isBackBlocked = isBlocked;
            } else {
                this.isFrontBlocked = isBlocked;
            }
        }

        public SpawnerCorridor(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.SPAWNER_CORRIDOR_PIECE.get(), nbt);
            this.isBackBlocked = nbt.getBoolean("bl0");
            this.isFrontBlocked = nbt.getBoolean("bl1");
            this.spawner1 = nbt.getBoolean("sp1");
            this.spawner2 = nbt.getBoolean("sp2");
            this.chestPos = nbt.getBoolean("ch");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putBoolean("bl0", this.isBackBlocked);
            tagCompound.putBoolean("bl1", this.isFrontBlocked);
            tagCompound.putBoolean("sp1", this.spawner1);
            tagCompound.putBoolean("sp2", this.spawner2);
            tagCompound.putBoolean("ch", this.chestPos);
        }

        @Override
        public boolean connectFrom(Direction facing) {
            if (this.getOrientation().getAxis().equals((Object)facing.getAxis())) {
                if (this.getOrientation().equals((Object)facing)) {
                    this.isFrontBlocked = false;
                } else {
                    this.isBackBlocked = false;
                }
                return true;
            }
            return false;
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            BlockPos spawnerPos;
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 0, 3, 0, 9, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 3, 1, 0, 6, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 3, 4, 0, 6, floorBlock, floorBlock, false);
            this.generateAirBox(level, structureBoundingBoxIn, 2, 1, 0, 3, 3, 9);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 3, 1, 3, 6);
            this.generateAirBox(level, structureBoundingBoxIn, 4, 1, 3, 4, 3, 6);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 0, 1, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 0, 4, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 2, 0, 4, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 2, 5, 4, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 7, 1, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 7, 4, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 4, 0, 3, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 4, 3, 1, 4, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 4, 3, 4, 4, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 2, 4, 0, 2, 5, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 2, 4, 5, 2, 5, wallDecor, wallDecor, false);
            if (this.spawner1) {
                spawnerPos = new BlockPos(this.getWorldX(1, 4), this.getWorldY(1), this.getWorldZ(1, 4));
                boolean bl = this.spawner1 = !StructureBlockUtil.placeSpawner(spawnerPos, (LevelAccessor)level, structureBoundingBoxIn, ImpDungeonPieces.getTypeForSpawners(), randomIn);
            }
            if (this.spawner2) {
                spawnerPos = new BlockPos(this.getWorldX(1, 5), this.getWorldY(1), this.getWorldZ(1, 5));
                this.spawner2 = !StructureBlockUtil.placeSpawner(spawnerPos, (LevelAccessor)level, structureBoundingBoxIn, ImpDungeonPieces.getTypeForSpawners(), randomIn);
            }
            int z = this.chestPos ? 4 : 5;
            BlockPos chestPos = new BlockPos(this.getWorldX(4, z), this.getWorldY(1), this.getWorldZ(4, z));
            StructureBlockUtil.placeLootChest(chestPos, (LevelAccessor)level, structureBoundingBoxIn, this.getOrientation().getClockWise(), MSLootTables.BASIC_MEDIUM_CHEST, randomIn);
            if (this.isBackBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 2, 0, 0, 3, 3, 0, wallBlock, wallBlock, false);
            }
            if (this.isFrontBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 2, 0, 9, 3, 3, 9, wallBlock, wallBlock, false);
            }
        }
    }

    public static class OgreCorridor
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        private boolean isFrontBlocked;
        private final boolean chestPos;
        private boolean ogreSpawned;

        OgreCorridor(Direction orientation, BlockPos pos, RandomSource rand) {
            super((StructurePieceType)MSStructures.ImpDungeon.OGRE_CORRIDOR_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(1, 0, 0, 8, 5, 10, pos, orientation));
            this.setOrientation(orientation);
            this.chestPos = rand.nextBoolean();
        }

        @Override
        public void generateAdjacentPieces(LocalPieceGenerator generator, RandomSource rand) {
            Direction orientation = Objects.requireNonNull(this.getOrientation());
            this.isFrontBlocked = !generator.tryGenerateInDirection(orientation, 1);
        }

        public OgreCorridor(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.OGRE_CORRIDOR_PIECE.get(), nbt);
            this.isFrontBlocked = nbt.getBoolean("bl0");
            this.chestPos = nbt.getBoolean("ch");
            this.ogreSpawned = nbt.getBoolean("spwn");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putBoolean("bl0", this.isFrontBlocked);
            tagCompound.putBoolean("ch", this.chestPos);
            tagCompound.putBoolean("spwn", this.ogreSpawned);
        }

        @Override
        public boolean connectFrom(Direction facing) {
            if (this.getOrientation().equals((Object)facing.getOpposite())) {
                this.isFrontBlocked = false;
                return true;
            }
            return false;
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            BlockState floorDecor = blocks.getBlockState("structure_secondary_decorative");
            BlockState light = blocks.getBlockState("light_block");
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 0, 4, 0, 9, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 2, 2, 0, 7, floorDecor, floorDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 2, 5, 0, 7, floorDecor, floorDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 2, 1, 0, 7, light, light, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 2, 6, 0, 7, light, light, false);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 2, 6, 5, 7);
            this.generateAirBox(level, structureBoundingBoxIn, 2, 6, 3, 5, 6, 6);
            this.generateAirBox(level, structureBoundingBoxIn, 3, 1, 0, 4, 3, 2);
            this.generateAirBox(level, structureBoundingBoxIn, 3, 1, 7, 4, 3, 9);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 1, 2, 3, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 0, 2, 3, 0, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 1, 6, 3, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 0, 5, 3, 0, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 1, 0, 5, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 0, 1, 7, 5, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 8, 2, 3, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 9, 2, 3, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 8, 6, 3, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 9, 5, 3, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 4, 1, 6, 6, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 4, 0, 5, 4, 0, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 4, 8, 6, 6, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 4, 9, 5, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 6, 2, 6, 6, 2, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 6, 3, 1, 6, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 6, 7, 6, 6, 7, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 6, 3, 6, 6, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 7, 3, 5, 7, 6, wallBlock, wallBlock, false);
            int x = this.chestPos ? 1 : 6;
            Direction chestDirection = this.chestPos ? this.getOrientation().getCounterClockWise() : this.getOrientation().getClockWise();
            BlockPos chestPos = new BlockPos(this.getWorldX(x, 4), this.getWorldY(1), this.getWorldZ(x, 4));
            StructureBlockUtil.placeLootChest(chestPos, (LevelAccessor)level, structureBoundingBoxIn, chestDirection, this.chestPos ? ChestType.LEFT : ChestType.RIGHT, MSLootTables.BASIC_MEDIUM_CHEST, randomIn);
            chestPos = new BlockPos(this.getWorldX(x, 5), this.getWorldY(1), this.getWorldZ(x, 5));
            StructureBlockUtil.placeLootChest(chestPos, (LevelAccessor)level, structureBoundingBoxIn, chestDirection, this.chestPos ? ChestType.RIGHT : ChestType.LEFT, MSLootTables.BASIC_MEDIUM_CHEST, randomIn);
            if (!this.ogreSpawned && structureBoundingBoxIn.isInside((Vec3i)new BlockPos(this.getWorldX(3, 4), this.getWorldY(1), this.getWorldZ(3, 4)))) {
                this.spawnOgre(3, 1, 4, level, randomIn);
            }
            if (this.isFrontBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 3, 0, 9, 4, 3, 9, wallBlock, wallBlock, false);
            }
        }

        private void spawnOgre(int xPos, int yPos, int zPos, WorldGenLevel level, RandomSource rand) {
            BlockPos pos = new BlockPos(this.getWorldX(xPos, zPos), this.getWorldY(yPos), this.getWorldZ(xPos, zPos));
            OgreEntity ogre = (OgreEntity)MSEntityTypes.OGRE.get().create((Level)level.getLevel());
            ogre.moveTo(pos.getX(), pos.getY(), pos.getZ(), rand.nextFloat() * 360.0f, 0.0f);
            ogre.finalizeSpawn((ServerLevelAccessor)level, null, MobSpawnType.STRUCTURE, null);
            ogre.restrictTo(pos, 2);
            level.addFreshEntity((Entity)ogre);
        }
    }

    public static class LargeSpawnerCorridor
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        private boolean isFrontBlocked;
        private boolean isBackBlocked;
        private boolean spawner1;
        private boolean spawner2;
        private final boolean chestPos;

        LargeSpawnerCorridor(Direction orientation, BlockPos pos, RandomSource rand) {
            super((StructurePieceType)MSStructures.ImpDungeon.LARGE_SPAWNER_CORRIDOR_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(0, 0, 0, 10, 5, 10, pos, orientation));
            this.setOrientation(orientation);
            if (rand.nextBoolean()) {
                this.spawner1 = true;
                this.spawner2 = true;
            } else {
                this.spawner1 = rand.nextBoolean();
                this.spawner2 = !this.spawner1;
            }
            this.chestPos = rand.nextBoolean();
        }

        @Override
        public void generateAdjacentPieces(LocalPieceGenerator generator, RandomSource rand) {
            boolean isBlocked;
            Direction orientation = Objects.requireNonNull(this.getOrientation());
            boolean mirror = rand.nextBoolean();
            if (mirror) {
                this.setOrientation(orientation.getOpposite());
            }
            boolean bl = isBlocked = !generator.tryGenerateInDirection(orientation, 1);
            if (mirror) {
                this.isBackBlocked = isBlocked;
            } else {
                this.isFrontBlocked = isBlocked;
            }
        }

        public LargeSpawnerCorridor(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.LARGE_SPAWNER_CORRIDOR_PIECE.get(), nbt);
            this.isBackBlocked = nbt.getBoolean("bl0");
            this.isFrontBlocked = nbt.getBoolean("bl1");
            this.spawner1 = nbt.getBoolean("sp1");
            this.spawner2 = nbt.getBoolean("sp2");
            this.chestPos = nbt.getBoolean("ch");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putBoolean("bl0", this.isBackBlocked);
            tagCompound.putBoolean("bl1", this.isFrontBlocked);
            tagCompound.putBoolean("sp1", this.spawner1);
            tagCompound.putBoolean("sp2", this.spawner2);
            tagCompound.putBoolean("ch", this.chestPos);
        }

        @Override
        public boolean connectFrom(Direction facing) {
            if (this.getOrientation().getAxis().equals((Object)facing.getAxis())) {
                if (this.getOrientation().equals((Object)facing)) {
                    this.isFrontBlocked = false;
                } else {
                    this.isBackBlocked = false;
                }
                return true;
            }
            return false;
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            BlockPos spawnerPos;
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 0, 5, 0, 9, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 2, 3, 0, 7, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 2, 8, 0, 7, floorBlock, floorBlock, false);
            this.generateAirBox(level, structureBoundingBoxIn, 4, 1, 0, 5, 3, 9);
            this.generateAirBox(level, structureBoundingBoxIn, 0, 1, 2, 3, 3, 7);
            this.generateAirBox(level, structureBoundingBoxIn, 6, 1, 2, 9, 3, 7);
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 0, 3, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 1, 2, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 7, 2, 4, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 0, 6, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 0, 1, 8, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 0, 7, 8, 4, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 1, 0, 4, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 9, 0, 1, 9, 4, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 7, 3, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 7, 6, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 4, 0, 5, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 4, 2, 3, 4, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 4, 2, 8, 4, 7, wallBlock, wallBlock, false);
            if (this.spawner1) {
                spawnerPos = new BlockPos(this.getWorldX(1, 3), this.getWorldY(1), this.getWorldZ(1, 3));
                boolean bl = this.spawner1 = !StructureBlockUtil.placeSpawner(spawnerPos, (LevelAccessor)level, structureBoundingBoxIn, ImpDungeonPieces.getTypeForSpawners(), randomIn);
            }
            if (this.spawner2) {
                spawnerPos = new BlockPos(this.getWorldX(8, 5), this.getWorldY(1), this.getWorldZ(8, 5));
                this.spawner2 = !StructureBlockUtil.placeSpawner(spawnerPos, (LevelAccessor)level, structureBoundingBoxIn, ImpDungeonPieces.getTypeForSpawners(), randomIn);
            }
            BlockPos chestPos = new BlockPos(this.getWorldX(4, 4), this.getWorldY(1), this.getWorldZ(4, 4));
            StructureBlockUtil.placeLootChest(chestPos, (LevelAccessor)level, structureBoundingBoxIn, this.getOrientation().getOpposite(), ChestType.LEFT, MSLootTables.BASIC_MEDIUM_CHEST, randomIn);
            chestPos = new BlockPos(this.getWorldX(5, 4), this.getWorldY(1), this.getWorldZ(5, 4));
            StructureBlockUtil.placeLootChest(chestPos, (LevelAccessor)level, structureBoundingBoxIn, this.getOrientation().getOpposite(), ChestType.RIGHT, MSLootTables.BASIC_MEDIUM_CHEST, randomIn);
            if (this.isBackBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 4, 0, 0, 5, 3, 0, wallBlock, wallBlock, false);
            }
            if (this.isFrontBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 4, 0, 9, 5, 3, 9, wallBlock, wallBlock, false);
            }
        }
    }

    public static class StraightCorridor
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        private boolean isFrontBlocked;
        private final boolean light;
        private byte lightPos;

        StraightCorridor(Direction coordBaseMode, BlockPos pos, RandomSource rand) {
            super((StructurePieceType)MSStructures.ImpDungeon.STRAIGHT_CORRIDOR_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(3, 0, 0, 4, 5, 10, pos, coordBaseMode));
            this.setOrientation(coordBaseMode);
            boolean bl = this.light = rand.nextFloat() < 0.4f;
            if (this.light) {
                this.lightPos = (byte)rand.nextInt(4);
            }
        }

        @Override
        public void generateAdjacentPieces(LocalPieceGenerator generator, RandomSource rand) {
            Direction orientation = Objects.requireNonNull(this.getOrientation());
            this.isFrontBlocked = !generator.tryGenerateInDirection(orientation, 1);
        }

        public StraightCorridor(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.STRAIGHT_CORRIDOR_PIECE.get(), nbt);
            this.isFrontBlocked = nbt.getBoolean("bl0");
            this.light = nbt.getBoolean("l");
            if (this.light) {
                this.lightPos = nbt.getByte("lpos");
            }
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putBoolean("bl0", this.isFrontBlocked);
            tagCompound.putBoolean("l", this.light);
            if (this.light) {
                tagCompound.putByte("lpos", this.lightPos);
            }
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 0, 2, 0, 9, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 4, 0, 2, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 0, 0, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 0, 3, 4, 9, wallBlock, wallBlock, false);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 0, 2, 3, 9);
            if (this.isFrontBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 1, 1, 9, 2, 3, 9, wallBlock, wallBlock, false);
            }
            if (this.light) {
                BlockState torch = blocks.getBlockState("wall_torch");
                if (this.lightPos / 2 == 0) {
                    this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(torch, Direction.WEST), 2, 2, 4 + this.lightPos % 2, structureBoundingBoxIn);
                } else {
                    this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(torch, Direction.EAST), 1, 2, 4 + this.lightPos % 2, structureBoundingBoxIn);
                }
            }
        }

        @Override
        public boolean connectFrom(Direction facing) {
            if (this.getOrientation().equals((Object)facing)) {
                this.isFrontBlocked = false;
            }
            return this.getOrientation().getAxis().equals((Object)facing.getAxis());
        }
    }

    public static class ReturnRoom
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        ReturnRoom(Direction orientation, BlockPos pos) {
            super((StructurePieceType)MSStructures.ImpDungeon.RETURN_ROOM_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(2, 0, 0, 6, 11, 8, pos, orientation));
            this.setOrientation(orientation);
        }

        public ReturnRoom(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.RETURN_ROOM_PIECE.get(), nbt);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        }

        @Override
        public boolean connectFrom(Direction facing) {
            return this.getOrientation().getOpposite().equals((Object)facing);
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            BlockState floorDecor = blocks.getBlockState("structure_secondary_decorative");
            BlockState light = blocks.getBlockState("light_block");
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 0, 3, 0, 2, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 3, 4, 0, 6, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 4, 3, 0, 5, floorDecor, floorDecor, false);
            this.generateAirBox(level, structureBoundingBoxIn, 2, 1, 0, 3, 3, 2);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 3, 4, 4, 6);
            this.generateAirBox(level, structureBoundingBoxIn, 2, 5, 4, 3, 9, 5);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 0, 1, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 0, 4, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 2, 0, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 2, 5, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 7, 4, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 4, 0, 3, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 5, 2, 4, 5, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 3, 4, 0, 3, 5, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 3, 4, 5, 3, 5, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 3, 7, 3, 3, 7, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 5, 3, 4, 10, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 5, 6, 4, 10, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 5, 4, 1, 10, 5, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 5, 4, 4, 10, 5, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 10, 4, 3, 10, 5, light, light, false);
            this.placeReturnNode((LevelAccessor)level, structureBoundingBoxIn, 2, 1, 4);
        }
    }

    public static class ReturnRoomAlt
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        ReturnRoomAlt(Direction coordBaseMode, BlockPos pos) {
            super((StructurePieceType)MSStructures.ImpDungeon.ALT_RETURN_ROOM_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(1, -1, 0, 8, 8, 10, pos, coordBaseMode));
            this.setOrientation(coordBaseMode);
        }

        public ReturnRoomAlt(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.ALT_RETURN_ROOM_PIECE.get(), nbt);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        }

        @Override
        public boolean connectFrom(Direction facing) {
            return this.getOrientation().getOpposite().equals((Object)facing);
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState floorStairsFront = blocks.getStairs("structure_secondary_stairs", Direction.SOUTH, false);
            BlockState floorStairsBack = blocks.getStairs("structure_secondary_stairs", Direction.NORTH, false);
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            BlockState floorDecor = blocks.getBlockState("structure_secondary_decorative");
            BlockState light = blocks.getBlockState("light_block");
            this.generateBox(level, structureBoundingBoxIn, 3, 1, 0, 4, 1, 1, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 1, 2, 7, 1, 2, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 4, 1, 0, 5, floorDecor, floorDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 4, 5, 0, 5, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 4, 6, 0, 5, floorDecor, floorDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 1, 7, 6, 1, 8, floorBlock, floorBlock, false);
            this.generateAirBox(level, structureBoundingBoxIn, 3, 2, 0, 4, 4, 1);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 2, 2, 6, 5, 3);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 3, 6, 6, 5);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 2, 6, 6, 6, 8);
            this.generateBox(level, structureBoundingBoxIn, 1, 1, 3, 6, 1, 3, floorStairsBack, floorStairsBack, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 1, 6, 6, 1, 6, floorStairsFront, floorStairsFront, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 2, 0, 2, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 2, 0, 5, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 2, 1, 1, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 2, 1, 7, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 5, 1, 7, 6, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 1, 2, 0, 6, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 1, 2, 7, 6, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 2, 9, 7, 6, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 5, 0, 4, 5, 0, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 6, 2, 6, 6, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 7, 4, 6, 7, 8, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 7, 5, 1, 7, 6, light, light, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 7, 5, 6, 7, 6, light, light, false);
            this.placeReturnNode((LevelAccessor)level, structureBoundingBoxIn, 3, 2, 7);
        }
    }

    public static class BookcaseRoom
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        float bookChance;
        boolean light;

        BookcaseRoom(Direction direction, BlockPos pos, RandomSource rand) {
            super((StructurePieceType)MSStructures.ImpDungeon.BOOKCASE_ROOM_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(1, 0, 0, 8, 5, 8, pos, direction));
            this.setOrientation(direction);
            this.light = rand.nextFloat() < 0.4f;
            this.bookChance = rand.nextBoolean() ? 0.0f : 0.8f;
        }

        public BookcaseRoom(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.BOOKCASE_ROOM_PIECE.get(), nbt);
            this.bookChance = nbt.getFloat("b");
            this.light = nbt.getBoolean("l");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putFloat("b", this.bookChance);
            tagCompound.putBoolean("l", this.light);
        }

        @Override
        public boolean connectFrom(Direction facing) {
            return this.getOrientation().getOpposite().equals((Object)facing);
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            BlockState floorDecor = blocks.getBlockState("structure_secondary_decorative");
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 0, 4, 0, 0, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 1, 6, 0, 1, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 6, 6, 0, 6, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 2, 1, 0, 5, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 2, 6, 0, 5, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 3, 4, 0, 4, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 2, 5, 0, 2, floorDecor, floorDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 5, 5, 0, 5, floorDecor, floorDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 3, 2, 0, 4, floorDecor, floorDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 3, 5, 0, 4, floorDecor, floorDecor, false);
            this.generateAirBox(level, structureBoundingBoxIn, 3, 1, 0, 4, 3, 0);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 1, 6, 4, 6);
            this.generateAirBox(level, structureBoundingBoxIn, 2, 5, 2, 5, 5, 5);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 0, 2, 5, 0, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 0, 7, 5, 0, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 1, 0, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 0, 1, 7, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 7, 6, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 4, 0, 4, 5, 0, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 5, 1, 1, 5, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 5, 1, 6, 5, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 5, 1, 5, 5, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 5, 6, 5, 5, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 6, 1, 6, 6, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 6, 3, 4, 6, 4, wallDecor, wallDecor, false);
            BlockState bookshelf = Blocks.BOOKSHELF.defaultBlockState();
            this.generateMaybeBox(level, structureBoundingBoxIn, randomIn, this.bookChance, 1, 1, 1, 1, 4, 2, bookshelf, bookshelf, false, false);
            this.generateMaybeBox(level, structureBoundingBoxIn, randomIn, this.bookChance, 1, 1, 5, 1, 4, 6, bookshelf, bookshelf, false, false);
            this.generateMaybeBox(level, structureBoundingBoxIn, randomIn, this.bookChance, 6, 1, 1, 6, 4, 2, bookshelf, bookshelf, false, false);
            this.generateMaybeBox(level, structureBoundingBoxIn, randomIn, this.bookChance, 6, 1, 5, 6, 4, 6, bookshelf, bookshelf, false, false);
            this.generateMaybeBox(level, structureBoundingBoxIn, randomIn, this.bookChance, 3, 1, 6, 4, 4, 6, bookshelf, bookshelf, false, false);
            if (this.light) {
                BlockState torch = blocks.getBlockState("torch");
                if (randomIn.nextBoolean()) {
                    this.placeBlock(level, torch, 2, 1, 2, structureBoundingBoxIn);
                }
                if (randomIn.nextBoolean()) {
                    this.placeBlock(level, torch, 5, 1, 2, structureBoundingBoxIn);
                }
                if (randomIn.nextBoolean()) {
                    this.placeBlock(level, torch, 2, 1, 5, structureBoundingBoxIn);
                }
                if (randomIn.nextBoolean()) {
                    this.placeBlock(level, torch, 5, 1, 5, structureBoundingBoxIn);
                }
            }
        }
    }

    public static class SpawnerRoom
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        private boolean spawner1;
        private boolean spawner2;

        SpawnerRoom(Direction orientation, BlockPos pos, RandomSource rand) {
            super((StructurePieceType)MSStructures.ImpDungeon.SPAWNER_ROOM_PIECE.get(), 0, ImpDungeonPieces.makeGridBoundingBox(1, 0, 0, 8, 5, 7, pos, orientation));
            this.setOrientation(orientation);
            if (rand.nextBoolean()) {
                this.spawner1 = true;
                this.spawner2 = true;
            } else {
                this.spawner1 = rand.nextBoolean();
                this.spawner2 = !this.spawner1;
            }
        }

        public SpawnerRoom(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.SPAWNER_ROOM_PIECE.get(), nbt);
            this.spawner1 = nbt.getBoolean("sp1");
            this.spawner2 = nbt.getBoolean("sp2");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putBoolean("sp1", this.spawner1);
            tagCompound.putBoolean("sp2", this.spawner2);
        }

        @Override
        public boolean connectFrom(Direction facing) {
            return this.getOrientation().getOpposite().equals((Object)facing);
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            BlockPos spawnerPos;
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            BlockState floorDecor = blocks.getBlockState("structure_secondary_decorative");
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 0, 4, 0, 2, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 3, 6, 0, 5, floorBlock, floorBlock, false);
            this.placeBlock(level, floorBlock, 1, 0, 2, structureBoundingBoxIn);
            this.placeBlock(level, floorBlock, 6, 0, 2, structureBoundingBoxIn);
            this.generateBox(level, structureBoundingBoxIn, 3, 0, 5, 4, 0, 5, floorDecor, floorDecor, false);
            this.generateAirBox(level, structureBoundingBoxIn, 3, 1, 0, 4, 3, 2);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 3, 6, 3, 5);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 2, 1, 3, 2);
            this.generateAirBox(level, structureBoundingBoxIn, 6, 1, 2, 6, 3, 2);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 0, 2, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 0, 5, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 2, 2, 4, 2, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 2, 5, 4, 2, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 1, 1, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 6, 0, 1, 6, 4, 1, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 1, 0, 4, 5, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 7, 0, 1, 7, 4, 5, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 6, 7, 4, 6, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 3, 4, 0, 4, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 4, 3, 6, 4, 5, wallBlock, wallBlock, false);
            this.placeBlock(level, wallBlock, 1, 4, 2, structureBoundingBoxIn);
            this.placeBlock(level, wallBlock, 6, 4, 2, structureBoundingBoxIn);
            if (this.spawner1) {
                spawnerPos = new BlockPos(this.getWorldX(1, 2), this.getWorldY(1), this.getWorldZ(1, 2));
                boolean bl = this.spawner1 = !StructureBlockUtil.placeSpawner(spawnerPos, (LevelAccessor)level, structureBoundingBoxIn, ImpDungeonPieces.getTypeForSpawners(), randomIn);
            }
            if (this.spawner2) {
                spawnerPos = new BlockPos(this.getWorldX(6, 2), this.getWorldY(1), this.getWorldZ(6, 2));
                this.spawner2 = !StructureBlockUtil.placeSpawner(spawnerPos, (LevelAccessor)level, structureBoundingBoxIn, ImpDungeonPieces.getTypeForSpawners(), randomIn);
            }
            BlockPos chestPos = new BlockPos(this.getWorldX(3, 5), this.getWorldY(1), this.getWorldZ(3, 5));
            StructureBlockUtil.placeLootChest(chestPos, (LevelAccessor)level, structureBoundingBoxIn, this.getOrientation().getOpposite(), ChestType.LEFT, MSLootTables.BASIC_MEDIUM_CHEST, randomIn);
            chestPos = new BlockPos(this.getWorldX(4, 5), this.getWorldY(1), this.getWorldZ(4, 5));
            StructureBlockUtil.placeLootChest(chestPos, (LevelAccessor)level, structureBoundingBoxIn, this.getOrientation().getOpposite(), ChestType.RIGHT, MSLootTables.BASIC_MEDIUM_CHEST, randomIn);
        }
    }

    public static interface LocalPieceGenerator {
        public boolean tryGenerateInDirection(Direction var1, int var2);
    }

    public static class EntryCorridor
    extends ImprovedStructurePiece
    implements ConnectablePiece {
        private boolean isFrontBlocked;
        private boolean isBackBlocked;

        public static EntryCorridor create(Direction orientation, int posX, int posZ, RandomSource rand) {
            int offset = orientation.getAxisDirection().equals((Object)Direction.AxisDirection.POSITIVE) ? 4 : -3;
            int x = posX + (orientation.getAxis().equals((Object)Direction.Axis.Z) ? 0 : offset);
            int y = 45 - rand.nextInt(8);
            int z = posZ + (orientation.getAxis().equals((Object)Direction.Axis.X) ? 0 : offset);
            return new EntryCorridor(orientation, x, y, z);
        }

        private EntryCorridor(Direction orientation, int x, int y, int z) {
            super((StructurePieceType)MSStructures.ImpDungeon.ENTRY_CORRIDOR_PIECE.get(), 0, EntryCorridor.makeBoundingBox((int)x, (int)y, (int)z, (Direction)orientation, (int)6, (int)7, (int)10));
            this.setOrientation(orientation);
        }

        public EntryCorridor(CompoundTag nbt) {
            super((StructurePieceType)MSStructures.ImpDungeon.ENTRY_CORRIDOR_PIECE.get(), nbt);
            this.isFrontBlocked = nbt.getBoolean("bl0");
            this.isBackBlocked = nbt.getBoolean("bl1");
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            tagCompound.putBoolean("bl0", this.isFrontBlocked);
            tagCompound.putBoolean("bl1", this.isBackBlocked);
        }

        @Override
        public boolean connectFrom(Direction facing) {
            if (this.getOrientation().equals((Object)facing)) {
                this.isFrontBlocked = false;
            } else if (this.getOrientation().getOpposite().equals((Object)facing)) {
                this.isBackBlocked = false;
            }
            return this.getOrientation().getAxis().equals((Object)facing.getAxis());
        }

        public void addChildren(StructurePiece piece, StructurePieceAccessor builder, RandomSource rand) {
            BlockPos compoPos = new BlockPos(this.boundingBox.minX() + (this.boundingBox.getXSpan() / 2 - 1), this.boundingBox.minY(), this.boundingBox.minZ() + (this.boundingBox.getZSpan() / 2 - 1));
            StructureContext ctxt = new StructureContext(compoPos, builder, rand);
            Direction orientation = Objects.requireNonNull(this.getOrientation());
            if (rand.nextBoolean()) {
                this.isFrontBlocked = !ImpDungeonPieces.generatePartInDirection(0, 0, orientation, 0, ctxt);
                this.isBackBlocked = !ImpDungeonPieces.generatePartInDirection(0, 0, orientation.getOpposite(), 0, ctxt);
            } else {
                this.isBackBlocked = !ImpDungeonPieces.generatePartInDirection(0, 0, orientation.getOpposite(), 0, ctxt);
                this.isFrontBlocked = !ImpDungeonPieces.generatePartInDirection(0, 0, orientation, 0, ctxt);
            }
        }

        public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
            BlockState wallBlock = blocks.getBlockState("structure_primary");
            BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
            BlockState floorBlock = blocks.getBlockState("structure_secondary");
            BlockState floorDecor = blocks.getBlockState("structure_secondary_decorative");
            BlockState fluid = blocks.getBlockState("fall_fluid");
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 4, 4, 0, 6, floorBlock, floorBlock, false);
            this.generateAirBox(level, structureBoundingBoxIn, 1, 1, 4, 4, 4, 6);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 5, 3, 0, 5, fluid, fluid, false);
            this.generateBox(level, structureBoundingBoxIn, 2, -1, 5, 3, -1, 5, floorDecor, floorDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 0, 0, 3, 0, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 5, 0, 3, 5, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 4, 3, 4, 5, 3, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 4, 7, 4, 5, 7, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 3, 1, 3, 3, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 0, 7, 1, 3, 7, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 3, 4, 3, 3, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 0, 7, 4, 3, 7, wallDecor, wallDecor, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 0, 3, 0, 3, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 0, 7, 3, 0, 9, floorBlock, floorBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 4, 0, 3, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 2, 4, 8, 3, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 1, 0, 1, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 1, 0, 4, 4, 2, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 1, 1, 8, 1, 4, 9, wallBlock, wallBlock, false);
            this.generateBox(level, structureBoundingBoxIn, 4, 1, 8, 4, 4, 9, wallBlock, wallBlock, false);
            this.generateAirBox(level, structureBoundingBoxIn, 2, 1, 0, 3, 3, 3);
            this.generateAirBox(level, structureBoundingBoxIn, 2, 1, 7, 3, 3, 9);
            if (this.isFrontBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 2, 1, 9, 3, 3, 9, wallBlock, wallBlock, false);
            }
            if (this.isBackBlocked) {
                this.generateBox(level, structureBoundingBoxIn, 2, 1, 0, 3, 3, 0, wallBlock, wallBlock, false);
            }
        }
    }
}

