/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mraof.minestuck.block.ReturnNodeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FluidState;

public abstract class ImprovedStructurePiece
extends StructurePiece {
    protected ImprovedStructurePiece(StructurePieceType structurePieceTypeIn, int genDepth, BoundingBox boundingBox) {
        super(structurePieceTypeIn, genDepth, boundingBox);
    }

    public ImprovedStructurePiece(StructurePieceType structurePierceTypeIn, CompoundTag nbt) {
        super(structurePierceTypeIn, nbt);
    }

    protected void generateDoor(WorldGenLevel level, BoundingBox sbb, RandomSource rand, int x, int y, int z, Direction direction, Block door, DoorHingeSide hinge) {
        BlockState state = door.defaultBlockState();
        if (state.hasProperty((Property)DoorBlock.FACING) && state.hasProperty((Property)DoorBlock.HINGE)) {
            state = (BlockState)((BlockState)state.setValue((Property)DoorBlock.FACING, (Comparable)direction)).setValue((Property)DoorBlock.HINGE, (Comparable)hinge);
        }
        this.placeBlock(level, state, x, y, z, sbb);
        if (state.hasProperty((Property)DoorBlock.HALF)) {
            this.placeBlock(level, (BlockState)state.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), x, y + 1, z, sbb);
        } else {
            this.placeBlock(level, state, x, y + 1, z, sbb);
        }
    }

    protected void generateBed(WorldGenLevel level, BoundingBox sbb, RandomSource rand, int x, int y, int z, Direction direction, BlockState state) {
        state = (BlockState)state.setValue((Property)BedBlock.FACING, (Comparable)direction);
        this.placeBlock(level, state, x, y, z, sbb);
        this.placeBlock(level, (BlockState)state.setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD), x + direction.getStepX(), y, z + direction.getStepZ(), sbb);
    }

    protected void placeReturnNode(LevelAccessor level, BoundingBox boundingBox, int x, int y, int z) {
        int posX = this.getWorldX(x, z);
        int posY = this.getWorldY(y);
        int posZ = this.getWorldZ(x, z);
        if (this.getOrientation() == Direction.NORTH || this.getOrientation() == Direction.WEST) {
            --posX;
        }
        if (this.getOrientation() == Direction.NORTH || this.getOrientation() == Direction.EAST) {
            --posZ;
        }
        ReturnNodeBlock.placeReturnNode(level, new BlockPos(posX, posY, posZ), boundingBox);
    }

    protected int getAverageGroundLevel(LevelAccessor level, ChunkGenerator chunkGeneratorIn, BoundingBox structurebb) {
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int k = this.boundingBox.minZ(); k <= this.boundingBox.maxZ(); ++k) {
            for (int l = this.boundingBox.minX(); l <= this.boundingBox.maxX(); ++l) {
                mutablePos.set(l, 64, k);
                if (!structurebb.isInside((Vec3i)mutablePos)) continue;
                i += Math.max(level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, (BlockPos)mutablePos).getY(), chunkGeneratorIn.getSpawnHeight((LevelHeightAccessor)level) - 1);
                ++j;
            }
        }
        if (j == 0) {
            return -1;
        }
        return i / j;
    }

    protected int getWorldX(int x, int z) {
        Direction direction = this.getOrientation();
        if (direction == null) {
            return x;
        }
        switch (direction) {
            case NORTH: {
                return this.boundingBox.maxX() - x;
            }
            case SOUTH: {
                return this.boundingBox.minX() + x;
            }
            case WEST: {
                return this.boundingBox.maxX() - z;
            }
            case EAST: {
                return this.boundingBox.minX() + z;
            }
        }
        return x;
    }

    protected int getWorldZ(int x, int z) {
        Direction direction = this.getOrientation();
        if (direction == null) {
            return z;
        }
        switch (direction) {
            case NORTH: {
                return this.boundingBox.maxZ() - z;
            }
            case SOUTH: {
                return this.boundingBox.minZ() + z;
            }
            case WEST: {
                return this.boundingBox.minZ() + x;
            }
            case EAST: {
                return this.boundingBox.maxZ() - x;
            }
        }
        return z;
    }

    protected boolean needPostprocessing(Block block) {
        return block instanceof CrossCollisionBlock || block instanceof TorchBlock || block instanceof LadderBlock || block instanceof StairBlock || block instanceof WallBlock;
    }

    protected void placeBlock(WorldGenLevel level, BlockState blockstateIn, int x, int y, int z, BoundingBox boundingboxIn) {
        BlockPos blockpos = new BlockPos(this.getWorldX(x, z), this.getWorldY(y), this.getWorldZ(x, z));
        if (boundingboxIn.isInside((Vec3i)blockpos)) {
            Direction direction = this.getOrientation();
            switch (direction) {
                case NORTH: {
                    blockstateIn = blockstateIn.rotate(Rotation.CLOCKWISE_180);
                    break;
                }
                case WEST: {
                    blockstateIn = blockstateIn.rotate(Rotation.CLOCKWISE_90);
                    break;
                }
                case EAST: {
                    blockstateIn = blockstateIn.rotate(Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
            }
            level.setBlock(blockpos, blockstateIn, 2);
            FluidState fluid = level.getFluidState(blockpos);
            if (!fluid.isEmpty()) {
                level.scheduleTick(blockpos, fluid.getType(), 0);
            }
            if (this.needPostprocessing(blockstateIn.getBlock())) {
                level.getChunk(blockpos).markPosForPostprocessing(blockpos);
            }
        }
    }
}

