/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.world.gen.feature.TemplatePlacement;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.SimpleTemplatePiece;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class LargeWoodObjectStructure
extends Structure {
    public static final MapCodec<LargeWoodObjectStructure> CODEC = LargeWoodObjectStructure.simpleCodec(LargeWoodObjectStructure::new);
    private static final List<ResourceLocation> TEMPLATES = List.of(Minestuck.id("large_unfinished_table"), Minestuck.id("massive_framing"), Minestuck.id("massive_table"));

    public LargeWoodObjectStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return LargeWoodObjectStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> LargeWoodObjectStructure.generatePieces(builder, context));
    }

    public StructureType<?> type() {
        return MSStructures.LARGE_WOOD_OBJECT_TYPE.get();
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        StructureTemplateManager templateManager = context.structureTemplateManager();
        ResourceLocation templateId = (ResourceLocation)Util.getRandom(TEMPLATES, (RandomSource)random);
        int x = context.chunkPos().getBlockX(random.nextInt(16));
        int z = context.chunkPos().getBlockZ(random.nextInt(16));
        TemplatePlacement placement = TemplatePlacement.centeredWithRandomRotation(templateManager.getOrCreate(templateId), new BlockPos(x, 0, z), (RandomSource)random);
        int minY = placement.xzCorners().mapToInt(corner -> context.chunkGenerator().getBaseHeight(corner.getX(), corner.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState())).min().orElseThrow();
        builder.addPiece((StructurePiece)new SimpleTemplatePiece(templateManager, templateId, placement.zeroPos().atY(minY), placement.rotation()));
    }
}

