/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.world.gen.structure.FrogTemplePiece;
import com.mraof.minestuck.world.gen.structure.FrogTemplePillarPiece;
import com.mraof.minestuck.world.gen.structure.FrogTempleStructure;
import com.mraof.minestuck.world.gen.structure.ImpDungeonEntryPiece;
import com.mraof.minestuck.world.gen.structure.ImpDungeonPieces;
import com.mraof.minestuck.world.gen.structure.ImpDungeonStructure;
import com.mraof.minestuck.world.gen.structure.LargeWoodObjectStructure;
import com.mraof.minestuck.world.gen.structure.PinkTowerPiece;
import com.mraof.minestuck.world.gen.structure.PinkTowerStructure;
import com.mraof.minestuck.world.gen.structure.SimpleTemplatePiece;
import com.mraof.minestuck.world.gen.structure.SmallRuinPiece;
import com.mraof.minestuck.world.gen.structure.SmallRuinStructure;
import com.mraof.minestuck.world.gen.structure.castle.CastleLibraryPiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleRoomPiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleSolidPiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleStaircasePiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleStartPiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleStructure;
import com.mraof.minestuck.world.gen.structure.castle.CastleWallPiece;
import com.mraof.minestuck.world.gen.structure.gate.GateMushroomPiece;
import com.mraof.minestuck.world.gen.structure.gate.GatePillarPiece;
import com.mraof.minestuck.world.gen.structure.gate.GateStructure;
import com.mraof.minestuck.world.gen.structure.gate.LandGatePlacement;
import com.mraof.minestuck.world.gen.structure.village.ConsortVillageCenter;
import com.mraof.minestuck.world.gen.structure.village.ConsortVillagePieces;
import com.mraof.minestuck.world.gen.structure.village.ConsortVillageStructure;
import com.mraof.minestuck.world.gen.structure.village.IguanaVillagePieces;
import com.mraof.minestuck.world.gen.structure.village.NakagatorVillagePieces;
import com.mraof.minestuck.world.gen.structure.village.SalamanderVillagePieces;
import com.mraof.minestuck.world.gen.structure.village.TurtleVillagePieces;
import java.util.function.Supplier;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.neoforged.neoforge.registries.DeferredRegister;

@FieldsAreNonnullByDefault
public final class MSStructures {
    public static final DeferredRegister<StructurePlacementType<?>> PLACEMENT_REGISTER = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PLACEMENT, (String)"minestuck");
    public static final DeferredRegister<StructureType<?>> TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"minestuck");
    public static final DeferredRegister<StructurePieceType> PIECE_REGISTER = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PIECE, (String)"minestuck");
    public static final Supplier<StructurePieceType> SIMPLE_TEMPLATE_PIECE = PIECE_REGISTER.register("simple_template", () -> MSStructures.template(SimpleTemplatePiece::new));
    public static final Supplier<StructureType<FrogTempleStructure>> FROG_TEMPLE_TYPE = TYPE_REGISTER.register("frog_temple", () -> MSStructures.asType(FrogTempleStructure.CODEC));
    public static final ResourceKey<Structure> FROG_TEMPLE = MSStructures.key("frog_temple");
    public static final Supplier<StructurePieceType> FROG_TEMPLE_PIECE = PIECE_REGISTER.register("frog_temple", () -> MSStructures.contextless(FrogTemplePiece::new));
    public static final Supplier<StructurePieceType> FROG_TEMPLE_PILLAR_PIECE = PIECE_REGISTER.register("frog_temple/pillar", () -> MSStructures.contextless(FrogTemplePillarPiece::new));
    public static final Supplier<StructurePlacementType<LandGatePlacement>> LAND_GATE_PLACEMENT = PLACEMENT_REGISTER.register("land_gate", () -> () -> LandGatePlacement.CODEC);
    public static final Supplier<StructureType<GateStructure>> LAND_GATE_TYPE = TYPE_REGISTER.register("land_gate", () -> MSStructures.asType(GateStructure.CODEC));
    public static final ResourceKey<Structure> LAND_GATE = MSStructures.key("land_gate");
    public static final Supplier<StructurePieceType> GATE_PILLAR_PIECE = PIECE_REGISTER.register("land_gate/pillar", () -> MSStructures.contextless(GatePillarPiece::new));
    public static final Supplier<StructurePieceType> GATE_MUSHROOM_PIECE = PIECE_REGISTER.register("land_gate/mushroom", () -> MSStructures.contextless(GateMushroomPiece::new));
    public static final Supplier<StructureType<SmallRuinStructure>> SMALL_RUIN_TYPE = TYPE_REGISTER.register("small_ruin", () -> MSStructures.asType(SmallRuinStructure.CODEC));
    public static final ResourceKey<Structure> SMALL_RUIN = MSStructures.key("small_ruin");
    public static final Supplier<StructurePieceType> SMALL_RUIN_PIECE = PIECE_REGISTER.register("small_ruin", () -> MSStructures.contextless(SmallRuinPiece::new));
    public static final Supplier<StructureType<LargeWoodObjectStructure>> LARGE_WOOD_OBJECT_TYPE;
    public static final ResourceKey<Structure> LARGE_WOOD_OBJECT;
    public static final Supplier<StructureType<PinkTowerStructure>> PINK_TOWER_TYPE;
    public static final ResourceKey<Structure> PINK_TOWER;
    public static final Supplier<StructurePieceType> PINK_TOWER_PIECE;
    public static final ResourceKey<Structure> SKAIAN_CATHEDRAL;

    public static <S extends Structure> StructureType<S> asType(MapCodec<S> codec) {
        return () -> codec;
    }

    private static ResourceKey<Structure> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)name));
    }

    private static StructurePieceType contextless(StructurePieceType.ContextlessType type) {
        return type;
    }

    private static StructurePieceType template(StructurePieceType.StructureTemplateType type) {
        return type;
    }

    static {
        ImpDungeon.init();
        ConsortVillage.init();
        LARGE_WOOD_OBJECT_TYPE = TYPE_REGISTER.register("large_wood_object", () -> MSStructures.asType(LargeWoodObjectStructure.CODEC));
        LARGE_WOOD_OBJECT = MSStructures.key("large_wood_object");
        PINK_TOWER_TYPE = TYPE_REGISTER.register("pink_tower", () -> MSStructures.asType(PinkTowerStructure.CODEC));
        PINK_TOWER = MSStructures.key("pink_tower");
        PINK_TOWER_PIECE = PIECE_REGISTER.register("pink_tower", () -> MSStructures.template(PinkTowerPiece::new));
        SKAIAN_CATHEDRAL = MSStructures.key("skaian_cathedral");
        SkaiaCastle.init();
    }

    public static final class ImpDungeon {
        public static final Supplier<StructureType<ImpDungeonStructure>> TYPE = TYPE_REGISTER.register("imp_dungeon", () -> MSStructures.asType(ImpDungeonStructure.CODEC));
        public static final ResourceKey<Structure> KEY = MSStructures.key("imp_dungeon");
        public static final Supplier<StructurePieceType.ContextlessType> ENTRY_PIECE = PIECE_REGISTER.register("imp_dungeon/entry", () -> ImpDungeonEntryPiece::new);
        public static final Supplier<StructurePieceType.ContextlessType> ENTRY_CORRIDOR_PIECE = PIECE_REGISTER.register("imp_dungeon/entry_corridor", () -> ImpDungeonPieces.EntryCorridor::new);
        public static final Supplier<StructurePieceType.ContextlessType> STRAIGHT_CORRIDOR_PIECE = PIECE_REGISTER.register("imp_dungeon/straight_corridor", () -> ImpDungeonPieces.StraightCorridor::new);
        public static final Supplier<StructurePieceType.ContextlessType> CROSS_CORRIDOR_PIECE = PIECE_REGISTER.register("imp_dungeon/cross_corridor", () -> ImpDungeonPieces.CrossCorridor::new);
        public static final Supplier<StructurePieceType.ContextlessType> TURN_CORRIDOR_PIECE = PIECE_REGISTER.register("imp_dungeon/turn_corridor", () -> ImpDungeonPieces.TurnCorridor::new);
        public static final Supplier<StructurePieceType.ContextlessType> RETURN_ROOM_PIECE = PIECE_REGISTER.register("imp_dungeon/return_room", () -> ImpDungeonPieces.ReturnRoom::new);
        public static final Supplier<StructurePieceType.ContextlessType> ALT_RETURN_ROOM_PIECE = PIECE_REGISTER.register("imp_dungeon/alt_return_room", () -> ImpDungeonPieces.ReturnRoomAlt::new);
        public static final Supplier<StructurePieceType.ContextlessType> SPAWNER_ROOM_PIECE = PIECE_REGISTER.register("imp_dungeon/spawner_room", () -> ImpDungeonPieces.SpawnerRoom::new);
        public static final Supplier<StructurePieceType.ContextlessType> SPAWNER_CORRIDOR_PIECE = PIECE_REGISTER.register("imp_dungeon/spawner_corridor", () -> ImpDungeonPieces.SpawnerCorridor::new);
        public static final Supplier<StructurePieceType.ContextlessType> LARGE_SPAWNER_CORRIDOR_PIECE = PIECE_REGISTER.register("imp_dungeon/large_spawner_corridor", () -> ImpDungeonPieces.LargeSpawnerCorridor::new);
        public static final Supplier<StructurePieceType.ContextlessType> BOOKCASE_ROOM_PIECE = PIECE_REGISTER.register("imp_dungeon/bookcase_room", () -> ImpDungeonPieces.BookcaseRoom::new);
        public static final Supplier<StructurePieceType.ContextlessType> OGRE_CORRIDOR_PIECE = PIECE_REGISTER.register("imp_dungeon/ogre_corridor", () -> ImpDungeonPieces.OgreCorridor::new);

        private static void init() {
        }
    }

    public static final class ConsortVillage {
        public static final Supplier<StructureType<ConsortVillageStructure>> TYPE = TYPE_REGISTER.register("consort_village", () -> MSStructures.asType(ConsortVillageStructure.CODEC));
        public static final ResourceKey<Structure> KEY = MSStructures.key("consort_village");
        public static final Supplier<StructurePieceType> VILLAGE_PATH_PIECE = PIECE_REGISTER.register("village_path", () -> MSStructures.contextless(ConsortVillagePieces.VillagePath::new));
        public static final Supplier<StructurePieceType> MARKET_CENTER_PIECE = PIECE_REGISTER.register("market_center", () -> MSStructures.contextless(ConsortVillageCenter.VillageMarketCenter::new));
        public static final Supplier<StructurePieceType> ROCK_CENTER_PIECE = PIECE_REGISTER.register("rock_center", () -> MSStructures.contextless(ConsortVillageCenter.RockCenter::new));
        public static final Supplier<StructurePieceType> CACTUS_PYRAMID_CENTER_PIECE = PIECE_REGISTER.register("cactus_pyramid_center", () -> MSStructures.contextless(ConsortVillageCenter.CactusPyramidCenter::new));
        public static final Supplier<StructurePieceType> MUSHROOM_TOWER_CENTER_PIECE = PIECE_REGISTER.register("mushroom_tower_center", () -> MSStructures.contextless(SalamanderVillagePieces.RuinedTowerMushroomCenter::new));
        public static final Supplier<StructurePieceType> PIPE_HOUSE_1_PIECE = PIECE_REGISTER.register("pipe_house_1", () -> MSStructures.contextless(SalamanderVillagePieces.PipeHouse1::new));
        public static final Supplier<StructurePieceType> HIGH_PIPE_HOUSE_1_PIECE = PIECE_REGISTER.register("high_pipe_house_1", () -> MSStructures.contextless(SalamanderVillagePieces.HighPipeHouse1::new));
        public static final Supplier<StructurePieceType> SMALL_TOWER_STORE_PIECE = PIECE_REGISTER.register("small_tower_store", () -> MSStructures.contextless(SalamanderVillagePieces.SmallTowerStore::new));
        public static final Supplier<StructurePieceType> TURTLE_WELL_CENTER_PIECE = PIECE_REGISTER.register("turtle_well_center", () -> MSStructures.contextless(TurtleVillagePieces.TurtleWellCenter::new));
        public static final Supplier<StructurePieceType> SHELL_HOUSE_1_PIECE = PIECE_REGISTER.register("village_shell_house_1", () -> MSStructures.contextless(TurtleVillagePieces.ShellHouse1::new));
        public static final Supplier<StructurePieceType> TURTLE_MARKET_1_PIECE = PIECE_REGISTER.register("turtle_market_1", () -> MSStructures.contextless(TurtleVillagePieces.TurtleMarket1::new));
        public static final Supplier<StructurePieceType> TURTLE_TEMPLE_1_PIECE = PIECE_REGISTER.register("turtle_temple_1", () -> MSStructures.contextless(TurtleVillagePieces.TurtleTemple1::new));
        public static final Supplier<StructurePieceType> SMALL_VILLAGE_TENT_1_PIECE = PIECE_REGISTER.register("small_village_tent_1", () -> MSStructures.contextless(IguanaVillagePieces.SmallTent1::new));
        public static final Supplier<StructurePieceType> LARGE_VILLAGE_TENT_1_PIECE = PIECE_REGISTER.register("large_village_tent_1", () -> MSStructures.contextless(IguanaVillagePieces.LargeTent1::new));
        public static final Supplier<StructurePieceType> SMALL_TENT_STORE_PIECE = PIECE_REGISTER.register("small_tent_store", () -> MSStructures.contextless(IguanaVillagePieces.SmallTentStore::new));
        public static final Supplier<StructurePieceType> RADIO_TOWER_CENTER_PIECE = PIECE_REGISTER.register("radio_tower_center", () -> MSStructures.contextless(NakagatorVillagePieces.RadioTowerCenter::new));
        public static final Supplier<StructurePieceType> HIGH_NAK_HOUSING_1_PIECE = PIECE_REGISTER.register("high_nak_housing_1", () -> MSStructures.contextless(NakagatorVillagePieces.HighNakHousing1::new));
        public static final Supplier<StructurePieceType> HIGH_NAK_MARKET_PIECE = PIECE_REGISTER.register("high_nak_market", () -> MSStructures.contextless(NakagatorVillagePieces.HighNakMarket1::new));
        public static final Supplier<StructurePieceType> HIGH_NAK_INN_PIECE = PIECE_REGISTER.register("high_nak_inn", () -> MSStructures.contextless(NakagatorVillagePieces.HighNakInn1::new));

        private static void init() {
        }
    }

    public static final class SkaiaCastle {
        public static final Supplier<StructureType<CastleStructure>> TYPE = TYPE_REGISTER.register("skaia_castle", () -> MSStructures.asType(CastleStructure.CODEC));
        public static final ResourceKey<Structure> KEY = MSStructures.key("skaia_castle");
        public static final Supplier<StructurePieceType> START_PIECE = PIECE_REGISTER.register("skaia_castle/start", () -> MSStructures.contextless(CastleStartPiece::new));
        public static final Supplier<StructurePieceType> SOLID_PIECE = PIECE_REGISTER.register("skaia_castle/solid", () -> MSStructures.contextless(CastleSolidPiece::new));
        public static final Supplier<StructurePieceType> WALL_PIECE = PIECE_REGISTER.register("skaia_castle/wall", () -> MSStructures.contextless(CastleWallPiece::new));
        public static final Supplier<StructurePieceType> ROOM_PIECE = PIECE_REGISTER.register("skaia_castle/room", () -> MSStructures.contextless(CastleRoomPiece::new));
        public static final Supplier<StructurePieceType> LIBRARY_PIECE = PIECE_REGISTER.register("skaia_castle/library", () -> MSStructures.contextless(CastleLibraryPiece::new));
        public static final Supplier<StructurePieceType> STAIRCASE_PIECE = PIECE_REGISTER.register("skaia_castle/staircase", () -> MSStructures.contextless(CastleStaircasePiece::new));

        private static void init() {
        }
    }
}

