/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.world.gen.feature.TemplatePlacement;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.PinkTowerPiece;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PinkTowerStructure
extends Structure {
    public static final MapCodec<PinkTowerStructure> CODEC = PinkTowerStructure.simpleCodec(PinkTowerStructure::new);

    public PinkTowerStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return PinkTowerStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> PinkTowerStructure.generatePieces(builder, context));
    }

    public StructureType<?> type() {
        return MSStructures.PINK_TOWER_TYPE.get();
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        StructureTemplateManager templateManager = context.structureTemplateManager();
        ResourceLocation templateId = Minestuck.id("pink_tower");
        int x = context.chunkPos().getBlockX(1);
        int z = context.chunkPos().getBlockZ(1);
        TemplatePlacement placement = TemplatePlacement.centeredWithRandomRotation(templateManager.getOrCreate(templateId), new BlockPos(x, 0, z), (RandomSource)random);
        int y = context.chunkGenerator().getBaseHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState());
        builder.addPiece((StructurePiece)new PinkTowerPiece(templateManager, templateId, placement.zeroPos().atY(y - 3), placement.rotation()));
    }
}

