/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.underling.OgreEntity;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class SmallRuinPiece
extends ScatteredFeaturePiece {
    private final boolean[] torches = new boolean[4];
    private final boolean[] placedOgres = new boolean[4];
    private boolean placedChest;

    public SmallRuinPiece(RandomSource random, int minX, int minZ, float skyLight) {
        super(MSStructures.SMALL_RUIN_PIECE.get(), minX, 64, minZ, 7, 4, 10, SmallRuinPiece.getRandomHorizontalDirection((RandomSource)random));
        float torchChance = 1.0f - skyLight;
        this.torches[0] = random.nextFloat() < 0.5f * torchChance;
        this.torches[1] = random.nextFloat() < 0.5f * torchChance;
        this.torches[2] = random.nextFloat() < torchChance;
        this.torches[3] = random.nextFloat() < torchChance;
    }

    public SmallRuinPiece(CompoundTag nbt) {
        super(MSStructures.SMALL_RUIN_PIECE.get(), nbt);
        int i;
        for (i = 0; i < 4; ++i) {
            this.torches[i] = nbt.getBoolean("torch" + i);
        }
        for (i = 0; i < 4; ++i) {
            this.placedOgres[i] = nbt.getBoolean("placed_ogres" + i);
        }
        this.placedChest = nbt.getBoolean("placed_chest");
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        int i;
        super.addAdditionalSaveData(context, nbt);
        for (i = 0; i < 4; ++i) {
            nbt.putBoolean("torch" + i, this.torches[i]);
        }
        for (i = 0; i < 4; ++i) {
            nbt.putBoolean("placed_ogres" + i, this.placedOgres[i]);
        }
        nbt.putBoolean("placed_chest", this.placedChest);
    }

    public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGeneratorIn, RandomSource randomIn, BoundingBox boundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
        int x;
        if (!this.updateAverageGroundHeight((LevelAccessor)level, boundingBoxIn, 0)) {
            return;
        }
        StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(chunkGeneratorIn);
        BlockState wallBlock = blocks.getBlockState("structure_primary");
        BlockState wallDecor = blocks.getBlockState("structure_primary_decorative");
        BlockState floorBlock = blocks.getBlockState("structure_secondary");
        BlockState wallTorch = blocks.getBlockState("wall_torch");
        for (int z = 0; z < 8; ++z) {
            for (int x2 = 0; x2 < 7; ++x2) {
                if (x2 == 0 || x2 == 6) {
                    boolean torch = false;
                    if (z == 3 || z == 6) {
                        torch = this.torches[(x2 == 0 ? 0 : 1) + (z == 3 ? 0 : 2)];
                    }
                    if (!this.buildFloorTile(wallBlock, x2, z, level, randomIn, boundingBoxIn)) continue;
                    this.buildWall(wallBlock, x2, z, level, randomIn, boundingBoxIn, torch ? 2 : 0);
                    continue;
                }
                this.buildFloorTile(floorBlock, x2, z, level, randomIn, boundingBoxIn);
            }
        }
        for (x = 1; x < 6; ++x) {
            if (x == 1 || x == 5) {
                this.buildFloorTile(wallBlock, x, 8, level, randomIn, boundingBoxIn);
                this.buildWall(wallBlock, x, 8, level, randomIn, boundingBoxIn, 0);
                if (this.getBlock((BlockGetter)level, x, 2, 8, boundingBoxIn) != wallBlock) continue;
                this.placeBlock(level, wallDecor, x, 2, 8, boundingBoxIn);
                continue;
            }
            this.buildFloorTile(floorBlock, x, 8, level, randomIn, boundingBoxIn);
        }
        for (x = 2; x < 5; ++x) {
            this.buildFloorTile(wallBlock, x, 9, level, randomIn, boundingBoxIn);
            this.buildWall(wallBlock, x, 9, level, randomIn, boundingBoxIn, 0);
        }
        this.generateAirBox(level, boundingBoxIn, 1, 1, 0, 5, 3, 7);
        this.generateAirBox(level, boundingBoxIn, 2, 1, 8, 4, 3, 8);
        if (!this.placedChest) {
            this.placedChest = this.generateChest(level, boundingBoxIn, randomIn, 3, 1, 6, this.getOrientation().getOpposite(), MSLootTables.BASIC_MEDIUM_CHEST);
        }
        if (this.torches[0]) {
            this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(wallTorch, Direction.EAST), 1, 2, 3, boundingBoxIn);
        }
        if (this.torches[1]) {
            this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(wallTorch, Direction.WEST), 5, 2, 3, boundingBoxIn);
        }
        if (this.torches[2]) {
            this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(wallTorch, Direction.EAST), 1, 2, 6, boundingBoxIn);
        }
        if (this.torches[3]) {
            this.placeBlock(level, StructureBlockRegistry.getModifiedTorch(wallTorch, Direction.WEST), 5, 2, 6, boundingBoxIn);
        }
        if (!this.placedOgres[0]) {
            this.placedOgres[0] = this.placeUnderling(this.boundingBox.minX() - 3, this.boundingBox.minZ() - 3, boundingBoxIn, level, randomIn);
        }
        if (!this.placedOgres[1]) {
            this.placedOgres[1] = this.placeUnderling(this.boundingBox.maxX() + 3, this.boundingBox.minZ() - 3, boundingBoxIn, level, randomIn);
        }
        if (!this.placedOgres[2]) {
            this.placedOgres[2] = this.placeUnderling(this.boundingBox.minX() - 3, this.boundingBox.maxZ() + 3, boundingBoxIn, level, randomIn);
        }
        if (!this.placedOgres[3]) {
            this.placedOgres[3] = this.placeUnderling(this.boundingBox.maxX() + 3, this.boundingBox.maxZ() + 3, boundingBoxIn, level, randomIn);
        }
    }

    private boolean generateChest(WorldGenLevel level, BoundingBox boundingBoxIn, RandomSource randomIn, int x, int y, int z, Direction direction, ResourceKey<LootTable> lootTable) {
        BlockPos blockpos = new BlockPos(this.getWorldX(x, z), this.getWorldY(y), this.getWorldZ(x, z));
        return this.createChest((ServerLevelAccessor)level, boundingBoxIn, randomIn, blockpos, lootTable, (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)direction));
    }

    private void buildWall(BlockState block, int x, int z, WorldGenLevel level, RandomSource rand, BoundingBox boundingBox, int minY) {
        float f = (float)z * 0.2f;
        for (int y = 1; y < 4; ++y) {
            if (y > minY && rand.nextFloat() >= f) {
                return;
            }
            this.placeBlock(level, block, x, y, z, boundingBox);
            f -= 0.5f;
        }
    }

    private boolean buildFloorTile(BlockState block, int x, int z, WorldGenLevel level, RandomSource rand, BoundingBox boundingBox) {
        int y = 0;
        float f = (float)(3 - z) * 0.25f;
        if (this.getBlock((BlockGetter)level, x, y, z, boundingBox).isSolid()) {
            f -= 0.25f;
        }
        boolean b = true;
        do {
            if (rand.nextFloat() >= f) {
                this.placeBlock(level, block, x, y, z, boundingBox);
                f = 0.0f;
                continue;
            }
            b = false;
            f -= 0.25f;
        } while (this.boundingBox.minY() + --y >= 0 && !this.getBlock((BlockGetter)level, x, y, z, boundingBox).isSolid());
        return b;
    }

    private boolean placeUnderling(int xPos, int zPos, BoundingBox boundingBox, WorldGenLevel level, RandomSource rand) {
        if (!boundingBox.isInside((Vec3i)new BlockPos(xPos, 64, zPos))) {
            return false;
        }
        int minY = level.getMaxBuildHeight();
        int maxY = level.getMinBuildHeight();
        for (int x = xPos - 1; x <= xPos + 1; ++x) {
            for (int z = zPos - 1; z <= zPos + 1; ++z) {
                int y = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos(x, 0, z)).getY();
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        if (maxY - minY < 3) {
            OgreEntity ogre = (OgreEntity)MSEntityTypes.OGRE.get().create((Level)level.getLevel());
            if (ogre == null) {
                throw new IllegalStateException("Unable to create a new ogre. Entity factory returned null!");
            }
            ogre.setPersistenceRequired();
            ogre.moveTo((double)xPos + 0.5, maxY, (double)zPos + 0.5, rand.nextFloat() * 360.0f, 0.0f);
            ogre.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(new BlockPos(xPos, maxY, zPos)), MobSpawnType.STRUCTURE, null);
            ogre.restrictTo(new BlockPos(xPos, this.boundingBox.minY(), zPos), 10);
            level.addFreshEntity((Entity)ogre);
        }
        return true;
    }
}

