/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.SmallRuinPiece;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class SmallRuinStructure
extends Structure {
    public static final MapCodec<SmallRuinStructure> CODEC = SmallRuinStructure.simpleCodec(SmallRuinStructure::new);

    public SmallRuinStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return SmallRuinStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> SmallRuinStructure.generatePieces(builder, context));
    }

    public StructureType<?> type() {
        return MSStructures.SMALL_RUIN_TYPE.get();
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        int x = context.chunkPos().getBlockX(random.nextInt(16));
        int z = context.chunkPos().getBlockZ(random.nextInt(16));
        SmallRuinPiece piece = new SmallRuinPiece((RandomSource)random, x, z, 0.5f);
        builder.addPiece((StructurePiece)piece);
    }
}

