/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.blocks;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.world.gen.LandChunkGenerator;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StructureBlockRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, BlockEntry> staticRegistry = new HashMap<String, BlockEntry>();
    private static final Map<Block, String> templateBlockMap = new HashMap<Block, String>();
    private static final StructureBlockRegistry fallbackRegistry = new StructureBlockRegistry();
    public static final String CRUXITE_ORE = "cruxite_ore";
    public static final String URANIUM_ORE = "uranium_ore";
    public static final String GROUND = "ground";
    public static final String GROUND_SLAB = "ground_slab";
    public static final String UPPER = "upper";
    public static final String SURFACE = "surface";
    public static final String SURFACE_ROUGH = "surface_rough";
    public static final String OCEAN = "ocean";
    public static final String OCEAN_SURFACE = "ocean_surface";
    public static final String RIVER = "river";
    public static final String SAND = "sand";
    public static final String STRUCTURE_PRIMARY = "structure_primary";
    public static final String STRUCTURE_PRIMARY_DECORATIVE = "structure_primary_decorative";
    public static final String STRUCTURE_PRIMARY_CRACKED = "structure_primary_cracked";
    public static final String STRUCTURE_PRIMARY_COLUMN = "structure_primary_column";
    public static final String STRUCTURE_PRIMARY_STAIRS = "structure_primary_stairs";
    public static final String STRUCTURE_PRIMARY_SLAB = "structure_primary_slab";
    public static final String STRUCTURE_PRIMARY_WALL = "structure_primary_wall";
    public static final String STRUCTURE_PRIMARY_MOSSY = "structure_primary_mossy";
    public static final String STRUCTURE_PRIMARY_MOSSY_STAIRS = "structure_primary_mossy_stairs";
    public static final String STRUCTURE_PRIMARY_MOSSY_SLAB = "structure_primary_mossy_slab";
    public static final String STRUCTURE_PRIMARY_MOSSY_WALL = "structure_primary_mossy_wall";
    public static final String STRUCTURE_SECONDARY = "structure_secondary";
    public static final String STRUCTURE_SECONDARY_DECORATIVE = "structure_secondary_decorative";
    public static final String STRUCTURE_SECONDARY_STAIRS = "structure_secondary_stairs";
    public static final String STRUCTURE_SECONDARY_SLAB = "structure_secondary_slab";
    public static final String STRUCTURE_SECONDARY_WALL = "structure_secondary_wall";
    public static final String STRUCTURE_WOOD = "structure_wood";
    public static final String STRUCTURE_LOG = "structure_log";
    public static final String STRUCTURE_STRIPPED_WOOD = "structure_stripped_wood";
    public static final String STRUCTURE_STRIPPED_LOG = "structure_stripped_log";
    public static final String STRUCTURE_PLANKS = "structure_planks";
    public static final String STRUCTURE_BOOKSHELF = "structure_bookshelf";
    public static final String STRUCTURE_PLANKS_STAIRS = "structure_planks_stairs";
    public static final String STRUCTURE_PLANKS_SLAB = "structure_planks_slab";
    public static final String STRUCTURE_PLANKS_FENCE = "structure_planks_fence";
    public static final String STRUCTURE_PLANKS_FENCE_GATE = "structure_planks_fence_gate";
    public static final String STRUCTURE_PLANKS_DOOR = "structure_planks_door";
    public static final String STRUCTURE_PLANKS_TRAPDOOR = "structure_planks_trapdoor";
    public static final String STRUCTURE_WOOL_1 = "structure_wool_1";
    public static final String STRUCTURE_WOOL_2 = "structure_wool_2";
    public static final String STRUCTURE_WOOL_3 = "structure_wool_3";
    public static final String CARPET = "carpet";
    public static final String STRUCTURE_GROUND_COVER = "structure_ground_cover";
    public static final String STRUCTURE_ROOF_COVER = "structure_roof_cover";
    public static final String VILLAGE_DOOR = "village_door";
    public static final String VILLAGE_PATH = "village_path";
    public static final String VILLAGE_FENCE = "village_fence";
    public static final String SALAMANDER_FLOOR = "salamander_floor";
    public static final String FALL_FLUID = "fall_fluid";
    public static final String LIGHT_BLOCK = "light_block";
    public static final String MUSHROOM_1 = "mushroom_1";
    public static final String MUSHROOM_2 = "mushroom_2";
    public static final String BUSH = "bush";
    public static final String TORCH = "torch";
    public static final String WALL_TORCH = "wall_torch";
    public static final String BUCKET_1 = "bucket_1";
    public static final String BUCKET_2 = "bucket_2";
    public static final String GLASS = "glass";
    public static final String STAINED_GLASS_1 = "stained_glass_1";
    public static final String STAINED_GLASS_2 = "stained_glass_2";
    public static final String SLIME = "slime";
    private final Map<String, BlockState> blockRegistry = new HashMap<String, BlockState>();
    private RuleTest groundType = new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD);

    public static void registerBlock(String name, BlockState defaultBlock) {
        StructureBlockRegistry.registerBlock(name, defaultBlock, Block.class);
    }

    public static void registerBlock(String name, BlockState defaultBlock, Class<? extends Block> extension) {
        if (defaultBlock == null || name == null) {
            throw new IllegalArgumentException("Null parameters not allowed.");
        }
        if (staticRegistry.containsKey(name)) {
            throw new IllegalStateException("\"" + name + "\" has already been registered!");
        }
        if (!extension.isInstance(defaultBlock.getBlock())) {
            throw new IllegalArgumentException("The default block \"" + String.valueOf(defaultBlock.getBlock()) + "\" has to extend the minimum class \"" + String.valueOf(extension) + "\"!");
        }
        if (templateBlockMap.containsKey(defaultBlock.getBlock())) {
            throw new IllegalStateException("Can't have two identical template blocks!");
        }
        staticRegistry.put(name, new BlockEntry(defaultBlock, extension));
        templateBlockMap.put(defaultBlock.getBlock(), name);
    }

    public static void registerBlock(String name, String parent, Block templateState) {
        StructureBlockRegistry.registerBlock(name, parent, templateState, Block.class);
    }

    public static void registerBlock(String name, String parent, Block templateState, Class<? extends Block> extension) {
        if (parent == null || name == null) {
            throw new IllegalArgumentException("Null parameters not allowed.");
        }
        if (staticRegistry.containsKey(name)) {
            throw new IllegalStateException("\"" + name + "\" has already been registered!");
        }
        if (!staticRegistry.containsKey(parent)) {
            throw new IllegalStateException("The parent entry \"" + parent + "\" isn't registered! Make sure to register the parent first.");
        }
        if (!extension.isAssignableFrom(StructureBlockRegistry.staticRegistry.get((Object)parent).extension)) {
            throw new IllegalArgumentException("The class specified must be the same or a superclass to the class used by the parent \"" + parent + "\".");
        }
        if (templateBlockMap.containsKey(templateState)) {
            throw new IllegalStateException("Can't have two identical template blocks!");
        }
        staticRegistry.put(name, new BlockEntry(parent, extension));
        templateBlockMap.put(templateState, name);
    }

    public static void registerEmptyFallbackBlock(String name, Block defaultBlock) {
        StructureBlockRegistry.registerEmptyFallbackBlock(name, defaultBlock, Block.class);
    }

    public static void registerEmptyFallbackBlock(String name, Block defaultBlock, Class<? extends Block> extension) {
        if (defaultBlock == null || name == null) {
            throw new IllegalArgumentException("Null parameters not allowed.");
        }
        if (staticRegistry.containsKey(name)) {
            throw new IllegalStateException("\"" + name + "\" has already been registered!");
        }
        staticRegistry.put(name, new BlockEntry("air", extension));
        templateBlockMap.put(defaultBlock, name);
    }

    public static StructureBlockRegistry getOrDefault(ChunkGenerator generator) {
        if (generator instanceof LandChunkGenerator) {
            return ((LandChunkGenerator)generator).blockRegistry;
        }
        return fallbackRegistry;
    }

    public static StructureBlockRegistry init(LandTypePair landTypes) {
        try {
            StructureBlockRegistry blockRegistry = new StructureBlockRegistry();
            landTypes.getTerrain().registerBlocks(blockRegistry);
            landTypes.getTitle().registerBlocks(blockRegistry);
            return blockRegistry;
        }
        catch (RuntimeException e) {
            LOGGER.error("Caught exception while setting up StructureBlockRegistry.", (Throwable)e);
            return fallbackRegistry;
        }
    }

    public void setBlock(String name, Supplier<? extends Block> block) {
        this.setBlock(name, block.get());
    }

    public void setBlock(String name, Block block) {
        this.setBlockState(name, block.defaultBlockState());
    }

    public void setBlockState(String name, BlockState state) {
        if (state == null || name == null) {
            throw new NullPointerException("Null parameters not allowed.");
        }
        if (!staticRegistry.containsKey(name)) {
            throw new IllegalStateException("Structure block \"" + name + "\" isn't registered, and can therefore not be set.");
        }
        if (!StructureBlockRegistry.staticRegistry.get((Object)name).extension.isInstance(state.getBlock())) {
            throw new IllegalArgumentException("The provided block must extend \"" + String.valueOf(StructureBlockRegistry.staticRegistry.get((Object)name).extension) + "\".");
        }
        this.blockRegistry.put(name, state);
        if (name.equals(GROUND)) {
            this.groundType = new BlockStateMatchTest(state);
        }
    }

    public BlockState getBlockState(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null parameters not allowed.");
        }
        if (!staticRegistry.containsKey(name)) {
            throw new IllegalStateException("Structure block \"" + name + "\" isn't registered, and can therefore not be obtained.");
        }
        if (this.blockRegistry.containsKey(name)) {
            return this.blockRegistry.get(name);
        }
        return staticRegistry.get(name).getBlockState(this);
    }

    public boolean isUsingDefault(String name) {
        return this.blockRegistry.get(name) == null;
    }

    public BlockState getStairs(String name, Direction facing, boolean upsideDown) {
        BlockState state = this.getBlockState(name);
        state = StructureBlockRegistry.withOptionally(state, BlockStateProperties.HORIZONTAL_FACING, facing);
        if (upsideDown) {
            state = StructureBlockRegistry.withOptionally(state, BlockStateProperties.HALF, Half.TOP);
        }
        return state;
    }

    public static BlockState getModifiedTorch(BlockState state, Direction facing) {
        state = StructureBlockRegistry.withOptionally(state, WallTorchBlock.FACING, facing);
        return state;
    }

    public RuleTest getGroundType() {
        return this.groundType;
    }

    public BlockState getTemplateState(BlockState state) {
        if (templateBlockMap.containsKey(state.getBlock())) {
            BlockState newState = this.getBlockState(templateBlockMap.get(state.getBlock()));
            for (Property property : state.getProperties()) {
                newState = StructureBlockRegistry.with(state, newState, property);
            }
            return newState;
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState with(BlockState fromState, BlockState toState, Property<T> property) {
        if (toState.hasProperty(property)) {
            return (BlockState)toState.setValue(property, fromState.getValue(property));
        }
        return toState;
    }

    public static <T extends Comparable<T>> BlockState withOptionally(BlockState state, Property<T> property, T value) {
        if (state.hasProperty(property)) {
            state = (BlockState)state.setValue(property, value);
        }
        return state;
    }

    static {
        staticRegistry.put("air", new BlockEntry(Blocks.AIR.defaultBlockState(), Block.class));
        StructureBlockRegistry.registerBlock(CRUXITE_ORE, ((Block)MSBlocks.STONE_CRUXITE_ORE.get()).defaultBlockState());
        StructureBlockRegistry.registerBlock(URANIUM_ORE, ((Block)MSBlocks.STONE_URANIUM_ORE.get()).defaultBlockState());
        StructureBlockRegistry.registerBlock(GROUND, Blocks.STONE.defaultBlockState());
        StructureBlockRegistry.registerBlock(GROUND_SLAB, GROUND, Blocks.STONE_SLAB);
        StructureBlockRegistry.registerBlock(UPPER, GROUND, Blocks.DIRT);
        StructureBlockRegistry.registerBlock(SURFACE, UPPER, Blocks.GRASS_BLOCK);
        StructureBlockRegistry.registerBlock(SURFACE_ROUGH, SURFACE, Blocks.PODZOL);
        StructureBlockRegistry.registerBlock(OCEAN, Blocks.WATER.defaultBlockState());
        StructureBlockRegistry.registerBlock(OCEAN_SURFACE, UPPER, Blocks.GRAVEL);
        StructureBlockRegistry.registerBlock(RIVER, OCEAN, Blocks.BLUE_WOOL);
        StructureBlockRegistry.registerBlock(SAND, Blocks.SAND.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY, Blocks.STONE_BRICKS.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_DECORATIVE, STRUCTURE_PRIMARY, Blocks.CHISELED_STONE_BRICKS);
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_CRACKED, STRUCTURE_PRIMARY, Blocks.CRACKED_STONE_BRICKS);
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_COLUMN, STRUCTURE_PRIMARY, (Block)MSBlocks.COARSE_STONE_COLUMN.get());
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_STAIRS, STRUCTURE_PRIMARY, Blocks.STONE_BRICK_STAIRS);
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_SLAB, STRUCTURE_PRIMARY, Blocks.STONE_BRICK_SLAB);
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_WALL, STRUCTURE_PRIMARY, Blocks.STONE_BRICK_WALL);
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_MOSSY, STRUCTURE_PRIMARY, Blocks.MOSSY_STONE_BRICKS);
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_MOSSY_STAIRS, STRUCTURE_PRIMARY_MOSSY, Blocks.MOSSY_STONE_BRICK_STAIRS);
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_MOSSY_SLAB, STRUCTURE_PRIMARY_MOSSY, Blocks.MOSSY_STONE_BRICK_SLAB);
        StructureBlockRegistry.registerBlock(STRUCTURE_PRIMARY_MOSSY_WALL, STRUCTURE_PRIMARY_MOSSY, Blocks.MOSSY_STONE_BRICK_WALL);
        StructureBlockRegistry.registerBlock(STRUCTURE_SECONDARY, STRUCTURE_PRIMARY, Blocks.NETHER_BRICKS);
        StructureBlockRegistry.registerBlock(STRUCTURE_SECONDARY_DECORATIVE, STRUCTURE_SECONDARY, Blocks.RED_NETHER_BRICKS);
        StructureBlockRegistry.registerBlock(STRUCTURE_SECONDARY_STAIRS, STRUCTURE_SECONDARY, Blocks.NETHER_BRICK_STAIRS);
        StructureBlockRegistry.registerBlock(STRUCTURE_SECONDARY_SLAB, STRUCTURE_SECONDARY, Blocks.NETHER_BRICK_SLAB);
        StructureBlockRegistry.registerBlock(STRUCTURE_SECONDARY_WALL, STRUCTURE_SECONDARY, Blocks.NETHER_BRICK_WALL);
        StructureBlockRegistry.registerBlock(STRUCTURE_WOOD, Blocks.OAK_WOOD.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_LOG, Blocks.OAK_LOG.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_STRIPPED_WOOD, STRUCTURE_WOOD, Blocks.STRIPPED_OAK_WOOD);
        StructureBlockRegistry.registerBlock(STRUCTURE_STRIPPED_LOG, STRUCTURE_LOG, Blocks.STRIPPED_OAK_LOG);
        StructureBlockRegistry.registerBlock(STRUCTURE_PLANKS, Blocks.OAK_PLANKS.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_BOOKSHELF, Blocks.BOOKSHELF.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_PLANKS_STAIRS, STRUCTURE_PLANKS, Blocks.OAK_STAIRS);
        StructureBlockRegistry.registerBlock(STRUCTURE_PLANKS_SLAB, Blocks.OAK_SLAB.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_PLANKS_FENCE, Blocks.OAK_FENCE.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_PLANKS_TRAPDOOR, Blocks.OAK_TRAPDOOR.defaultBlockState());
        StructureBlockRegistry.registerEmptyFallbackBlock(STRUCTURE_PLANKS_FENCE_GATE, Blocks.OAK_FENCE_GATE);
        StructureBlockRegistry.registerEmptyFallbackBlock(STRUCTURE_PLANKS_DOOR, Blocks.OAK_DOOR, DoorBlock.class);
        StructureBlockRegistry.registerBlock(STRUCTURE_WOOL_1, Blocks.WHITE_WOOL.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_WOOL_2, Blocks.LIGHT_GRAY_WOOL.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_WOOL_3, Blocks.GRAY_WOOL.defaultBlockState());
        StructureBlockRegistry.registerBlock(CARPET, Blocks.WHITE_CARPET.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_GROUND_COVER, Blocks.MOSS_CARPET.defaultBlockState());
        StructureBlockRegistry.registerBlock(STRUCTURE_ROOF_COVER, Blocks.HANGING_ROOTS.defaultBlockState());
        StructureBlockRegistry.registerBlock(VILLAGE_DOOR, STRUCTURE_PLANKS_DOOR, Blocks.DARK_OAK_DOOR, DoorBlock.class);
        StructureBlockRegistry.registerBlock(VILLAGE_PATH, STRUCTURE_SECONDARY, Blocks.COBBLESTONE);
        StructureBlockRegistry.registerBlock(VILLAGE_FENCE, STRUCTURE_PLANKS_FENCE, Blocks.DARK_OAK_FENCE);
        StructureBlockRegistry.registerBlock(SALAMANDER_FLOOR, UPPER, Blocks.COARSE_DIRT);
        StructureBlockRegistry.registerBlock(FALL_FLUID, OCEAN, Blocks.LIGHT_BLUE_WOOL);
        StructureBlockRegistry.registerBlock(LIGHT_BLOCK, Blocks.GLOWSTONE.defaultBlockState());
        StructureBlockRegistry.registerBlock(MUSHROOM_1, Blocks.RED_MUSHROOM.defaultBlockState());
        StructureBlockRegistry.registerBlock(MUSHROOM_2, Blocks.BROWN_MUSHROOM.defaultBlockState());
        StructureBlockRegistry.registerBlock(BUSH, Blocks.DEAD_BUSH.defaultBlockState());
        StructureBlockRegistry.registerBlock(TORCH, Blocks.TORCH.defaultBlockState());
        StructureBlockRegistry.registerBlock(WALL_TORCH, Blocks.WALL_TORCH.defaultBlockState());
        StructureBlockRegistry.registerBlock(BUCKET_1, Blocks.QUARTZ_BLOCK.defaultBlockState());
        StructureBlockRegistry.registerBlock(BUCKET_2, Blocks.IRON_BLOCK.defaultBlockState());
        StructureBlockRegistry.registerBlock(GLASS, Blocks.GLASS.defaultBlockState());
        StructureBlockRegistry.registerBlock(STAINED_GLASS_1, Blocks.GRAY_STAINED_GLASS.defaultBlockState());
        StructureBlockRegistry.registerBlock(STAINED_GLASS_2, Blocks.LIGHT_GRAY_STAINED_GLASS.defaultBlockState());
        StructureBlockRegistry.registerBlock(SLIME, Blocks.SLIME_BLOCK.defaultBlockState());
        fallbackRegistry.setBlock(SURFACE, Blocks.GRASS_BLOCK);
        fallbackRegistry.setBlock(UPPER, Blocks.DIRT);
        fallbackRegistry.setBlock(OCEAN_SURFACE, Blocks.GRAVEL);
    }

    private static class BlockEntry {
        Class<? extends Block> extension;
        BlockState defaultBlock;
        String parentEntry;

        BlockEntry(BlockState state, Class<? extends Block> clazz) {
            this.defaultBlock = state;
            this.extension = clazz;
        }

        BlockEntry(String str, Class<? extends Block> clazz) {
            this.parentEntry = str;
            this.extension = clazz;
        }

        BlockState getBlockState(StructureBlockRegistry registry) {
            if (this.parentEntry == null) {
                return this.defaultBlock;
            }
            if (this.parentEntry.equals("air")) {
                return Blocks.AIR.defaultBlockState();
            }
            return registry.getBlockState(this.parentEntry);
        }
    }
}

