/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootTable;

public class StructureBlockUtil {
    public static boolean placeSpawner(BlockPos pos, LevelAccessor level, BoundingBox bb, EntityType<?> entityType, RandomSource random) {
        if (bb.isInside((Vec3i)pos)) {
            level.setBlock(pos, Blocks.SPAWNER.defaultBlockState(), 2);
            BlockEntity te = level.getBlockEntity(pos);
            if (te instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)te;
                spawner.setEntityId(entityType, random);
                return true;
            }
        }
        return false;
    }

    public static void placeLootChest(BlockPos pos, LevelAccessor level, BoundingBox bb, Direction direction, ResourceKey<LootTable> lootTable, RandomSource rand) {
        StructureBlockUtil.placeLootChest(pos, level, bb, direction, ChestType.SINGLE, lootTable, rand);
    }

    public static void placeLootChest(BlockPos pos, LevelAccessor level, BoundingBox bb, Direction direction, ChestType type, ResourceKey<LootTable> lootTable, RandomSource rand) {
        if (bb == null || bb.isInside((Vec3i)pos)) {
            level.setBlock(pos, (BlockState)((BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)direction)).setValue((Property)ChestBlock.TYPE, (Comparable)type), 2);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                chest.setLootTable(lootTable, rand.nextLong());
            }
            if (bb != null) {
                level.getChunk(pos).markPosForPostprocessing(pos);
            }
        }
    }
}

