/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.castle;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.castle.CastlePiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleStartPiece;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class CastleStructure
extends Structure {
    public static final MapCodec<CastleStructure> CODEC = CastleStructure.simpleCodec(CastleStructure::new);

    public CastleStructure(Structure.StructureSettings pSettings) {
        super(pSettings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return CastleStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> CastleStructure.generatePieces(builder, context));
    }

    public StructureType<?> type() {
        return MSStructures.SkaiaCastle.TYPE.get();
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        boolean isBlack = random.nextBoolean();
        CastleStartPiece startPiece = new CastleStartPiece(context.chunkPos().getMinBlockX(), context.chunkPos().getMinBlockZ(), isBlack);
        builder.addPiece((StructurePiece)startPiece);
        startPiece.addChildren(startPiece, (StructurePieceAccessor)builder, (RandomSource)random);
        ArrayList<CastlePiece> pendingPieces = startPiece.pendingPieces;
        while (!pendingPieces.isEmpty()) {
            int k = random.nextInt(pendingPieces.size());
            CastlePiece structurePiece = (CastlePiece)((Object)pendingPieces.remove(k));
            structurePiece.addChildren(startPiece, (StructurePieceAccessor)builder, (RandomSource)random);
        }
        int minY = 64;
        builder.offsetPiecesVertically(minY);
    }
}

