/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.castle;

import com.mraof.minestuck.world.gen.structure.castle.CastlePiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleRoomPiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleSolidPiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleStartPiece;
import com.mraof.minestuck.world.gen.structure.castle.CastleWallPiece;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;

public class StructureCastlePieces {
    public static StructurePiece getNextValidComponent(CastleStartPiece startPiece, StructurePieceAccessor accessor, RandomSource par2Random, int x, int y, int z, int par6, Type type) {
        CastlePiece newPiece = StructureCastlePieces.getNextComponent(startPiece, par2Random, x, y, z, par6, type);
        if (newPiece != null) {
            accessor.addPiece((StructurePiece)newPiece);
            startPiece.pendingPieces.add(newPiece);
        }
        return newPiece;
    }

    public static CastlePiece getNextComponent(CastleStartPiece startPiece, RandomSource random, int x, int y, int z, int par6, Type type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> CastleSolidPiece.findValidPlacement(startPiece.isBlack, x, y, z);
            case 1 -> CastleWallPiece.findValidPlacement(startPiece.isBlack, x, y, z, par6, false);
            case 2 -> CastleRoomPiece.findValidPlacement(startPiece.isBlack, x, y, z);
            case 3 -> CastleRoomPiece.createRandomRoom(startPiece.isBlack, startPiece.bottom, x, y, z, random);
        };
    }

    public static enum Type {
        SOLID,
        WALL,
        ROOM,
        RANDOM_ROOM;

    }
}

