/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.gate;

import com.mraof.minestuck.block.GateBlock;
import com.mraof.minestuck.world.GateHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class GatePiece
extends ScatteredFeaturePiece {
    public GatePiece(StructurePieceType type, LevelHeightAccessor level, RandomState randomState, ChunkGenerator generator, RandomSource random, int x, int z, int width, int height, int depth, int heightOffset) {
        super(type, x, 64, z, width, height, depth, GatePiece.getRandomHorizontalDirection((RandomSource)random));
        int count = 0;
        int heightSum = 0;
        for (int xPos = this.boundingBox.minX(); xPos <= this.boundingBox.maxX(); ++xPos) {
            for (int zPos = this.boundingBox.minZ(); zPos <= this.boundingBox.maxZ(); ++zPos) {
                int posHeight = generator.getBaseHeight(xPos, zPos, Heightmap.Types.OCEAN_FLOOR_WG, level, randomState);
                heightSum += posHeight;
                ++count;
            }
        }
        if (count > 0) {
            this.boundingBox.move(0, heightSum / count + heightOffset - this.boundingBox.minY(), 0);
        }
    }

    public GatePiece(StructurePieceType type, CompoundTag nbt) {
        super(type, nbt);
    }

    protected final BlockPos getGatePos() {
        BlockPos relativePos = this.getRelativeGatePos();
        int x = relativePos.getX();
        int y = relativePos.getY();
        int z = relativePos.getZ();
        return new BlockPos(this.getWorldX(x, z), this.getWorldY(y), this.getWorldZ(x, z));
    }

    protected abstract BlockPos getRelativeGatePos();

    protected boolean updateAverageGroundHeight(LevelAccessor level, BoundingBox boundsIn, int heightIn) {
        throw new UnsupportedOperationException("Shouldn't change the bounding box after creating the gate piece. Look at other gate pieces for an example of what to do instead.");
    }

    public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        this.placeGate((LevelAccessor)level, box);
    }

    private void placeGate(LevelAccessor level, BoundingBox boundingBoxIn) {
        BlockPos gatePos = this.getGatePos();
        if (boundingBoxIn.isInside((Vec3i)gatePos)) {
            GateBlock.placeGate((CommonLevelAccessor)level, gatePos, GateHandler.Type.LAND_GATE, 2);
        }
    }
}

