/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.gate;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.world.gen.LandChunkGenerator;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.gate.GatePiece;
import com.mraof.minestuck.world.gen.structure.gate.GatePillarPiece;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class GateStructure
extends Structure {
    public static final MapCodec<GateStructure> CODEC = GateStructure.simpleCodec(GateStructure::new);

    public GateStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return Optional.of(new Structure.GenerationStub(context.chunkPos().getWorldPosition(), builder -> GateStructure.generatePieces(builder, context)));
    }

    public StructureType<?> type() {
        return MSStructures.LAND_GATE_TYPE.get();
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        ChunkGenerator generator = context.chunkGenerator();
        ChunkPos pos = context.chunkPos();
        PieceFactory factory = GateStructure.getFactory(generator);
        if (factory == null) {
            factory = GatePillarPiece::new;
        }
        builder.addPiece((StructurePiece)factory.create(generator, context.heightAccessor(), context.randomState(), (RandomSource)context.random(), pos.getMinBlockX(), pos.getMinBlockZ()));
    }

    private static PieceFactory getFactory(ChunkGenerator generator) {
        if (generator instanceof LandChunkGenerator) {
            return ((LandChunkGenerator)generator).gatePiece;
        }
        return null;
    }

    public static interface PieceFactory {
        public GatePiece create(ChunkGenerator var1, LevelHeightAccessor var2, RandomState var3, RandomSource var4, int var5, int var6);
    }
}

