/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.gate;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.world.gen.LandStructureState;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.gate.GatePiece;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LandGatePlacement
extends StructurePlacement {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final MapCodec<LandGatePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> LandGatePlacement.placementCodec((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, LandGatePlacement::new));

    public LandGatePlacement() {
        this(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 0, Optional.empty());
    }

    public LandGatePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone);
    }

    public StructurePlacementType<LandGatePlacement> type() {
        return MSStructures.LAND_GATE_PLACEMENT.get();
    }

    public boolean isPlacementChunk(ChunkGeneratorStructureState structureState, int chunkX, int chunkZ) {
        if (structureState instanceof LandStructureState) {
            LandStructureState landState = (LandStructureState)structureState;
            ChunkPos chunkPos = landState.getOrFindLandGatePosition();
            return chunkPos.x == chunkX && chunkPos.z == chunkZ;
        }
        return false;
    }

    public static BlockPos findLandGatePos(ServerLevel level) {
        ChunkGeneratorStructureState chunkGeneratorStructureState = level.getChunkSource().getGeneratorState();
        if (chunkGeneratorStructureState instanceof LandStructureState) {
            LandStructureState landStructureState = (LandStructureState)chunkGeneratorStructureState;
            Structure landGate = (Structure)level.registryAccess().registryOrThrow(Registries.STRUCTURE).get(MSStructures.LAND_GATE);
            Objects.requireNonNull(landGate, "Unable to find land gate structure instance");
            ChunkPos chunkPos = landStructureState.getOrFindLandGatePosition();
            StructureStart start = level.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.STRUCTURE_STARTS).getStartForStructure(landGate);
            if (start != null) {
                for (StructurePiece piece : start.getPieces()) {
                    if (!(piece instanceof GatePiece)) continue;
                    GatePiece gatePiece = (GatePiece)piece;
                    return gatePiece.getGatePos();
                }
                LOGGER.error("Did not find a gate piece in gate structure. Instead had components {}.", (Object)start.getPieces());
            } else {
                LOGGER.warn("Expected to find gate structure at chunk coords {}, in dimension {}, but found nothing!", (Object)chunkPos, (Object)level.dimension());
            }
        } else {
            LOGGER.warn("No land gate position could be found for dimension {}.", (Object)level.dimension());
        }
        return null;
    }
}

