/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.village;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.village.ConsortVillageCenter;
import com.mraof.minestuck.world.gen.structure.village.ConsortVillagePieces;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class ConsortVillageStructure
extends Structure {
    public static final MapCodec<ConsortVillageStructure> CODEC = ConsortVillageStructure.simpleCodec(ConsortVillageStructure::new);

    public ConsortVillageStructure(Structure.StructureSettings pSettings) {
        super(pSettings);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return ConsortVillageStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> ConsortVillageStructure.generatePieces(builder, context));
    }

    public StructureType<?> type() {
        return MSStructures.ConsortVillage.TYPE.get();
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        LandTypePair landTypes = LandTypePair.getTypesOrDefaulted(context.chunkGenerator());
        int x = context.chunkPos().getBlockX(random.nextInt(16));
        int z = context.chunkPos().getBlockZ(random.nextInt(16));
        List<ConsortVillagePieces.PieceWeight> pieceWeightList = ConsortVillagePieces.getStructureVillageWeightedPieceList((RandomSource)random, landTypes);
        ConsortVillageCenter.VillageCenter start = ConsortVillageCenter.getVillageStart(x, z, (RandomSource)random, pieceWeightList, landTypes);
        builder.addPiece((StructurePiece)start);
        start.addChildren(start, (StructurePieceAccessor)builder, (RandomSource)random);
        while (!start.pendingHouses.isEmpty() || !start.pendingRoads.isEmpty()) {
            StructurePiece component;
            int index;
            if (!start.pendingRoads.isEmpty()) {
                index = random.nextInt(start.pendingRoads.size());
                component = start.pendingRoads.remove(index);
                component.addChildren((StructurePiece)start, (StructurePieceAccessor)builder, (RandomSource)random);
                continue;
            }
            index = random.nextInt(start.pendingHouses.size());
            component = start.pendingHouses.remove(index);
            component.addChildren((StructurePiece)start, (StructurePieceAccessor)builder, (RandomSource)random);
        }
    }
}

