/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.wfc;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.wfc.WFC;
import com.mraof.minestuck.world.gen.structure.wfc.WFCData;
import com.mraof.minestuck.world.gen.structure.wfc.WFCUtil;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ProspitWFCDemoStructure {
    public static final WFCUtil.CellSize CELL_SIZE = new WFCUtil.CellSize(8, 8);
    public static final int WIDTH_IN_PIECES = 16;
    public static final int HEIGHT_IN_PIECES = 14;
    public static final WFCUtil.Dimensions WFC_DIMENSIONS = new WFCUtil.Dimensions(16, 14, 16);
    public static final int WIDTH_IN_CHUNKS = CELL_SIZE.width() * 16 / 16;
    public static final int BOTTOM_Y = 1;
    public static final ResourceKey<Structure> STRUCTURE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Minestuck.id("prospit_wfc_demo"));
    public static final Supplier<StructurePlacementType<FixedPlacement>> FIXED_PLACEMENT_TYPE = MSStructures.PLACEMENT_REGISTER.register("fixed", () -> () -> FixedPlacement.CODEC);
    public static final Supplier<StructureType<TerrainStructure>> STRUCTURE_TYPE = MSStructures.TYPE_REGISTER.register("prospit_wfc_demo", () -> MSStructures.asType(TerrainStructure.CODEC));

    public static void init() {
    }

    public static final class TerrainStructure
    extends Structure {
        public static final MapCodec<TerrainStructure> CODEC = TerrainStructure.simpleCodec(TerrainStructure::new);

        public TerrainStructure(Structure.StructureSettings settings) {
            super(settings);
        }

        public StructureType<TerrainStructure> type() {
            return STRUCTURE_TYPE.get();
        }

        protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
            return Optional.of(new Structure.GenerationStub(context.chunkPos().getWorldPosition(), builder -> this.generatePieces((StructurePiecesBuilder)builder, context)));
        }

        private void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context) {
            StructureTemplateManager templateManager = context.structureTemplateManager();
            HolderLookup.RegistryLookup paletteLookup = context.registryAccess().lookupOrThrow(WFCData.PaletteData.REGISTRY_KEY);
            PositionalRandomFactory randomFactory = RandomSource.create((long)context.seed()).forkPositional().fromHashOf(Minestuck.id("prospit")).forkPositional();
            WFCUtil.PositionTransform middleTransform = new WFCUtil.PositionTransform(context.chunkPos().getMiddleBlockPosition(1), CELL_SIZE);
            ResourceKey<WFCData.PaletteData> centerPaletteKey = context.random().nextBoolean() ? Palettes.NORMAL : Palettes.OPEN_ZONE;
            WFCData.EntryPalette centerPalette = ((WFCData.PaletteData)paletteLookup.getOrThrow(centerPaletteKey).value()).build(CELL_SIZE, templateManager);
            WFCData.EntryPalette borderPalette = ((WFCData.PaletteData)paletteLookup.getOrThrow(Palettes.BORDER).value()).build(CELL_SIZE, templateManager);
            WFC.InfiniteModularGeneration.generateModule(middleTransform, WFC_DIMENSIONS, centerPalette, borderPalette, randomFactory, (StructurePieceAccessor)piecesBuilder, null);
        }
    }

    public static final class FixedPlacement
    extends StructurePlacement {
        public static final MapCodec<FixedPlacement> CODEC = MapCodec.unit(FixedPlacement::new);

        public FixedPlacement() {
            super(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 0, Optional.empty());
        }

        public StructurePlacementType<FixedPlacement> type() {
            return FIXED_PLACEMENT_TYPE.get();
        }

        protected boolean isPlacementChunk(ChunkGeneratorStructureState structureState, int x, int z) {
            return Math.floorMod(x, WIDTH_IN_CHUNKS) == 0 && Math.floorMod(z, WIDTH_IN_CHUNKS) == 0;
        }
    }

    public static final class Palettes {
        public static final ResourceKey<WFCData.PaletteData> BORDER = Palettes.key("border");
        public static final ResourceKey<WFCData.PaletteData> NORMAL = Palettes.key("normal");
        public static final ResourceKey<WFCData.PaletteData> OPEN_ZONE = Palettes.key("open_zone");

        private static ResourceKey<WFCData.PaletteData> key(String name) {
            return ResourceKey.create(WFCData.PaletteData.REGISTRY_KEY, (ResourceLocation)Minestuck.id("prospit/" + name));
        }
    }
}

