/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.wfc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.world.gen.structure.SimpleTemplatePiece;
import com.mraof.minestuck.world.gen.structure.wfc.WFCUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.MOD)
public final class WFCData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Codec<EntryPrototype> ENTRY_PROTOTYPE_DIRECT_CODEC = PrototypeType.CODEC.dispatch(EntryPrototype::type, type -> type.prototypeCodec);
    private static final Codec<Holder<EntryPrototype>> ENTRY_PROTOTYPE_HOLDER_CODEC = RegistryFileCodec.create(EntryPrototype.REGISTRY_KEY, ENTRY_PROTOTYPE_DIRECT_CODEC);

    private static Map<Direction, ConnectorType> rotateConnectors(Map<Direction, ConnectorType> connections, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return Map.copyOf(connections);
        }
        return Map.of(Direction.DOWN, connections.get(Direction.DOWN), Direction.UP, connections.get(Direction.UP), rotation.rotate(Direction.NORTH), connections.get(Direction.NORTH), rotation.rotate(Direction.EAST), connections.get(Direction.EAST), rotation.rotate(Direction.SOUTH), connections.get(Direction.SOUTH), rotation.rotate(Direction.WEST), connections.get(Direction.WEST));
    }

    @SubscribeEvent
    private static void onDatapackNewRegistryEvent(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(EntryPrototype.REGISTRY_KEY, ENTRY_PROTOTYPE_DIRECT_CODEC);
    }

    public record ConnectorType(ResourceLocation id) {
        public static final Codec<ConnectorType> CODEC = ResourceLocation.CODEC.xmap(ConnectorType::new, ConnectorType::id);
        public static final ConnectorType TOP_BORDER = new ConnectorType(Minestuck.id("top_border"));
        public static final ConnectorType BOTTOM_BORDER = new ConnectorType(Minestuck.id("bottom_border"));
    }

    public static sealed interface EntryPrototype
    permits EmptyEntryPrototype, TemplateEntryPrototype {
        public static final ResourceKey<Registry<EntryPrototype>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Minestuck.id("wfc_entry_prototype"));

        public PrototypeType type();

        public void build(EntryBuilderContext var1);
    }

    public static enum PrototypeType implements StringRepresentable
    {
        EMPTY(EmptyEntryPrototype.CODEC),
        TEMPLATE(TemplateEntryPrototype.CODEC);

        public static final Codec<PrototypeType> CODEC;
        private final MapCodec<? extends EntryPrototype> prototypeCodec;

        private PrototypeType(MapCodec<? extends EntryPrototype> prototypeCodec) {
            this.prototypeCodec = prototypeCodec;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(PrototypeType::values);
        }
    }

    @EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.MOD)
    public record PaletteData(Holder<ConnectionSet> connectionSet, List<WeightedEntry.Wrapper<Holder<EntryPrototype>>> entries) {
        public static final ResourceKey<Registry<PaletteData>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Minestuck.id("wfc_palette"));
        private static final Codec<WeightedEntry.Wrapper<Holder<EntryPrototype>>> ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ENTRY_PROTOTYPE_HOLDER_CODEC.fieldOf("prototype").forGetter(WeightedEntry.Wrapper::data), (App)Weight.CODEC.fieldOf("weight").forGetter(WeightedEntry.Wrapper::weight)).apply((Applicative)instance, WeightedEntry.Wrapper::new));
        private static final Codec<PaletteData> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConnectionSet.HOLDER_CODEC.fieldOf("connection_set").forGetter(PaletteData::connectionSet), (App)ENTRY_CODEC.listOf().fieldOf("entries").forGetter(PaletteData::entries)).apply((Applicative)instance, PaletteData::new));

        @SubscribeEvent
        private static void onDatapackNewRegistryEvent(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(REGISTRY_KEY, DIRECT_CODEC);
        }

        public EntryPalette build(WFCUtil.CellSize cellSize, StructureTemplateManager templateManager) {
            EntriesBuilder builder = new EntriesBuilder(cellSize, templateManager);
            builder.add(this.connectionSet);
            for (WeightedEntry.Wrapper<Holder<EntryPrototype>> entry : this.entries) {
                builder.add((Holder<EntryPrototype>)((Holder)entry.data()), entry.getWeight());
            }
            return builder.build();
        }
    }

    @EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.MOD)
    public record ConnectionSet(List<Pair<ConnectorType, ConnectorType>> connections) {
        public static final ResourceKey<Registry<ConnectionSet>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Minestuck.id("wfc_connection_set"));
        private static final Codec<Pair<ConnectorType, ConnectorType>> CONNECTION_CODEC = ConnectorType.CODEC.listOf(2, 2).xmap(list -> Pair.of((Object)((ConnectorType)list.getFirst()), (Object)((ConnectorType)list.get(1))), pair -> List.of((ConnectorType)pair.getFirst(), (ConnectorType)pair.getSecond()));
        private static final Codec<ConnectionSet> DIRECT_CODEC = CONNECTION_CODEC.listOf().xmap(ConnectionSet::new, ConnectionSet::connections);
        static final Codec<Holder<ConnectionSet>> HOLDER_CODEC = RegistryFileCodec.create(REGISTRY_KEY, DIRECT_CODEC);

        @SubscribeEvent
        private static void onDatapackNewRegistryEvent(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(REGISTRY_KEY, DIRECT_CODEC);
        }
    }

    public static final class EntriesBuilder {
        private final WFCUtil.CellSize cellSize;
        private final StructureTemplateManager templateManager;
        private final ConnectionsBuilder connectionsBuilder = new ConnectionsBuilder();
        private final ImmutableList.Builder<WeightedEntry.Wrapper<PieceEntry>> pieceEntries = ImmutableList.builder();

        public EntriesBuilder(WFCUtil.CellSize cellSize, StructureTemplateManager templateManager) {
            this.cellSize = cellSize;
            this.templateManager = templateManager;
        }

        public ConnectionsBuilder connections() {
            return this.connectionsBuilder;
        }

        public void add(Holder<ConnectionSet> connectionSet) {
            ((ConnectionSet)connectionSet.value()).connections().forEach(pair -> this.connectionsBuilder.connect((ConnectorType)pair.getFirst(), (ConnectorType)pair.getSecond()));
        }

        public void add(Holder<EntryPrototype> provider, int weight) {
            this.add(provider, Weight.of((int)weight));
        }

        public void add(Holder<EntryPrototype> provider, Weight weight) {
            ((EntryPrototype)provider.value()).build(new EntryBuilderContext(this.connectionsBuilder, pieceEntry -> this.pieceEntries.add((Object)new WeightedEntry.Wrapper((Object)pieceEntry, weight)), this.cellSize, this.templateManager));
        }

        public EntryPalette build() {
            ImmutableList entriesList = this.pieceEntries.build();
            ConnectionTester connectionTester = this.connectionsBuilder.buildConnectionTester();
            entriesList.stream().flatMap(entry -> ((PieceEntry)entry.data()).connections.values().stream()).forEach(connector -> {
                if (!connectionTester.isKnown((ConnectorType)connector)) {
                    LOGGER.warn("Found unknown connector: {}", (Object)connector.id());
                }
            });
            return new EntryPalette((Collection<WeightedEntry.Wrapper<PieceEntry>>)entriesList, connectionTester);
        }
    }

    public static final class ConnectionsBuilder {
        private final Map<ConnectorType, ImmutableSet.Builder<ConnectorType>> connections = new HashMap<ConnectorType, ImmutableSet.Builder<ConnectorType>>();

        public void connectSelf(ConnectorType type) {
            this.connect(type, type);
        }

        public void connect(ConnectorType type1, ConnectorType type2) {
            this.connections.computeIfAbsent(type1, ignored -> ImmutableSet.builder()).add((Object)type2);
            this.connections.computeIfAbsent(type2, ignored -> ImmutableSet.builder()).add((Object)type1);
        }

        private ConnectionTester buildConnectionTester() {
            Map map = (Map)this.connections.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
            return new ConnectionTester(map);
        }
    }

    public record EntryPalette(Collection<WeightedEntry.Wrapper<PieceEntry>> entries, ConnectionTester connectionTester) {
    }

    public static final class ConnectionTester {
        private final Map<ConnectorType, Set<ConnectorType>> connectionMap;

        private ConnectionTester(Map<ConnectorType, Set<ConnectorType>> connectionMap) {
            this.connectionMap = connectionMap;
        }

        public boolean canConnect(ConnectorType type, Set<ConnectorType> otherTypes) {
            Set<ConnectorType> supportedTypes = this.connectionMap.get(type);
            if (supportedTypes == null) {
                return false;
            }
            return otherTypes.stream().anyMatch(supportedTypes::contains);
        }

        public boolean isKnown(ConnectorType connectorType) {
            return this.connectionMap.containsKey(connectorType);
        }
    }

    public record EntryBuilderContext(ConnectionsBuilder connectionsBuilder, WeightedEntriesBuilder entriesBuilder, WFCUtil.CellSize cellSize, StructureTemplateManager templateManager) {
    }

    public static interface WeightedEntriesBuilder {
        public void add(PieceEntry var1);

        default public void add(PieceEntry ... entries) {
            for (PieceEntry entry : entries) {
                this.add(entry);
            }
        }

        default public void add(Iterable<PieceEntry> entries) {
            entries.forEach(this::add);
        }
    }

    private record LoadedTemplateEntry(ResourceLocation templateId, WFCUtil.Dimensions templateDimensions, Map<WFCUtil.CellPos, Map<Direction, ConnectorType>> edgeConnectors) {
        void build(Rotation rotation, EntryBuilderContext context) {
            EnumMap connectors = new EnumMap(Direction.Axis.class);
            BiFunction<Direction.Axis, WFCUtil.CellPos, ConnectorType> innerConnectorGetter = (axis, cellPos) -> connectors.computeIfAbsent((Direction.Axis)axis, ignored -> new HashMap()).computeIfAbsent(cellPos, ignored -> this.addNewConnector((WFCUtil.CellPos)cellPos, (Direction.Axis)axis, rotation, context.connectionsBuilder()));
            for (WFCUtil.CellPos cellPos2 : this.templateDimensions.iterateAll()) {
                Function<BlockPos, StructurePiece> constructor = cellPos2.x() == 0 && cellPos2.y() == 0 && cellPos2.z() == 0 ? this.templateConstructor(context.cellSize(), rotation, context.templateManager()) : pos -> null;
                Map<Direction, ConnectorType> entryConnectors = Map.of(Direction.DOWN, this.templateDimensions.isOnEdge(cellPos2, Direction.DOWN) ? this.edgeConnectors().get(cellPos2).get(Direction.DOWN) : innerConnectorGetter.apply(Direction.Axis.Y, new WFCUtil.CellPos(cellPos2.x(), cellPos2.y() - 1, cellPos2.z())), Direction.UP, this.templateDimensions.isOnEdge(cellPos2, Direction.UP) ? this.edgeConnectors().get(cellPos2).get(Direction.UP) : innerConnectorGetter.apply(Direction.Axis.Y, cellPos2), Direction.NORTH, this.templateDimensions.isOnEdge(cellPos2, Direction.NORTH) ? this.edgeConnectors().get(cellPos2).get(Direction.NORTH) : innerConnectorGetter.apply(Direction.Axis.Z, new WFCUtil.CellPos(cellPos2.x(), cellPos2.y(), cellPos2.z() - 1)), Direction.EAST, this.templateDimensions.isOnEdge(cellPos2, Direction.EAST) ? this.edgeConnectors().get(cellPos2).get(Direction.EAST) : innerConnectorGetter.apply(Direction.Axis.X, cellPos2), Direction.SOUTH, this.templateDimensions.isOnEdge(cellPos2, Direction.SOUTH) ? this.edgeConnectors().get(cellPos2).get(Direction.SOUTH) : innerConnectorGetter.apply(Direction.Axis.Z, cellPos2), Direction.WEST, this.templateDimensions.isOnEdge(cellPos2, Direction.WEST) ? this.edgeConnectors().get(cellPos2).get(Direction.WEST) : innerConnectorGetter.apply(Direction.Axis.X, new WFCUtil.CellPos(cellPos2.x() - 1, cellPos2.y(), cellPos2.z())));
                PieceEntry entry = new PieceEntry(constructor, WFCData.rotateConnectors(entryConnectors, rotation));
                context.entriesBuilder().add(entry);
            }
        }

        private ConnectorType addNewConnector(WFCUtil.CellPos pos, Direction.Axis axis, Rotation rotation, ConnectionsBuilder builder) {
            ConnectorType newConnector = new ConnectorType(this.templateId.withSuffix("/" + pos.x() + "_" + pos.y() + "_" + pos.z() + "_" + axis.getSerializedName() + "_" + rotation.getSerializedName()));
            builder.connectSelf(newConnector);
            return newConnector;
        }

        private Function<BlockPos, StructurePiece> templateConstructor(WFCUtil.CellSize cellSize, Rotation rotation, StructureTemplateManager templateManager) {
            BlockPos zeroPos = StructureTemplate.getZeroPositionWithTransform((BlockPos)BlockPos.ZERO, (Mirror)Mirror.NONE, (Rotation)rotation, (int)cellSize.width(), (int)cellSize.width());
            return pos -> new SimpleTemplatePiece(templateManager, this.templateId, pos.offset((Vec3i)zeroPos), rotation);
        }
    }

    private static final class TemplateEntryBuilder {
        private final ResourceLocation templateId;
        private final WFCUtil.Dimensions templateDimensions;
        final Map<WFCUtil.CellPos, Map<Direction, ConnectorType>> connectors = new HashMap<WFCUtil.CellPos, Map<Direction, ConnectorType>>();
        boolean failed = false;

        private TemplateEntryBuilder(ResourceLocation templateId, WFCUtil.Dimensions templateDimensions) {
            this.templateId = templateId;
            this.templateDimensions = templateDimensions;
        }

        static Optional<TemplateEntryBuilder> init(ResourceLocation templateId, Vec3i templateSize, WFCUtil.CellSize cellSize) {
            if (templateSize.getX() % cellSize.width() != 0 || templateSize.getY() % cellSize.height() != 0 || templateSize.getZ() % cellSize.width() != 0) {
                LOGGER.error("Template {} of size {} is not a multiple of {}", (Object)templateId, (Object)templateSize, (Object)cellSize);
                return Optional.empty();
            }
            WFCUtil.Dimensions dimensions = new WFCUtil.Dimensions(templateSize.getX() / cellSize.width(), templateSize.getY() / cellSize.height(), templateSize.getZ() / cellSize.width());
            return Optional.of(new TemplateEntryBuilder(templateId, dimensions));
        }

        void put(WFCUtil.CellPos pos, Direction direction, ConnectorType connectorType) {
            if (!this.templateDimensions.isOnEdge(pos, direction)) {
                LOGGER.warn("Connector {} in template {} is not at the edge", (Object)connectorType, (Object)this.templateId);
                return;
            }
            if (this.connectors.computeIfAbsent(pos, ignored -> new HashMap()).put(direction, connectorType) != null) {
                LOGGER.error("Template {} has multiple jigsaws for the same side ({})", (Object)this.templateId, (Object)direction);
                this.failed = false;
            }
        }

        Optional<LoadedTemplateEntry> verify() {
            List<Direction> missingDirections = Arrays.stream(Direction.values()).filter(this::isConnectorMissingOnSide).toList();
            if (!missingDirections.isEmpty()) {
                LOGGER.error("Template {} is missing connector type for the following sides: {}", (Object)this.templateId, missingDirections);
                return Optional.empty();
            }
            if (this.failed) {
                return Optional.empty();
            }
            return Optional.of(new LoadedTemplateEntry(this.templateId, this.templateDimensions, (Map)this.connectors.entrySet().stream().map(entry -> Map.entry((WFCUtil.CellPos)entry.getKey(), Map.copyOf((Map)entry.getValue()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))));
        }

        private boolean isConnectorMissingOnSide(Direction direction) {
            return Streams.stream(this.templateDimensions.iterateEdge(direction)).anyMatch(pos -> !this.connectors.getOrDefault(pos, Collections.emptyMap()).containsKey(direction));
        }
    }

    public record TemplateEntryPrototype(ResourceLocation templateId, Symmetry symmetry) implements EntryPrototype
    {
        public static final MapCodec<TemplateEntryPrototype> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("template").forGetter(TemplateEntryPrototype::templateId), (App)Symmetry.CODEC.optionalFieldOf("symmetry", (Object)Symmetry.ROTATABLE).forGetter(TemplateEntryPrototype::symmetry)).apply((Applicative)instance, TemplateEntryPrototype::new));

        @Override
        public PrototypeType type() {
            return PrototypeType.TEMPLATE;
        }

        @Override
        public void build(EntryBuilderContext context) {
            StructureTemplate template = context.templateManager().getOrCreate(this.templateId);
            TemplateEntryBuilder.init(this.templateId, template.getSize(), context.cellSize()).flatMap(builder -> {
                TemplateEntryPrototype.loadConnectorsFromJigsaws(this.templateId, template, context.cellSize(), builder);
                return builder.verify();
            }).ifPresent(loadedEntry -> {
                for (Rotation rotation : this.symmetry.rotations) {
                    loadedEntry.build(rotation, context);
                }
            });
        }

        private static void loadConnectorsFromJigsaws(ResourceLocation templateId, StructureTemplate template, WFCUtil.CellSize cellSize, TemplateEntryBuilder builder) {
            for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(BlockPos.ZERO, new StructurePlaceSettings(), Blocks.JIGSAW, false)) {
                if (blockInfo.nbt() == null) {
                    LOGGER.warn("Jigsaw block is missing data in template {} at {}", (Object)templateId, (Object)blockInfo.pos());
                    continue;
                }
                String connectorName = blockInfo.nbt().getString("name");
                ResourceLocation connectorId = ResourceLocation.tryParse((String)connectorName);
                if (connectorId == null) {
                    LOGGER.error("Connector name \"{}\" in template {} is not a valid id", (Object)connectorName, (Object)templateId);
                    continue;
                }
                ConnectorType connectorType = new ConnectorType(connectorId);
                WFCUtil.CellPos pos = new WFCUtil.CellPos(blockInfo.pos().getX() / cellSize.width(), blockInfo.pos().getY() / cellSize.height(), blockInfo.pos().getZ() / cellSize.width());
                Direction direction = ((FrontAndTop)blockInfo.state().getValue((Property)JigsawBlock.ORIENTATION)).front();
                builder.put(pos, direction, connectorType);
            }
        }
    }

    public static enum Symmetry implements StringRepresentable
    {
        SYMMETRIC(List.of(Rotation.NONE)),
        AXIS_SYMMETRIC(List.of(Rotation.NONE, Rotation.CLOCKWISE_90)),
        ROTATABLE(List.of(Rotation.values()));

        public static final Codec<Symmetry> CODEC;
        private final List<Rotation> rotations;

        private Symmetry(List<Rotation> rotations) {
            this.rotations = rotations;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Symmetry::values);
        }
    }

    public record EmptyEntryPrototype(ConnectorType connector) implements EntryPrototype
    {
        public static final MapCodec<EmptyEntryPrototype> CODEC = ConnectorType.CODEC.fieldOf("connector").xmap(EmptyEntryPrototype::new, EmptyEntryPrototype::connector);

        @Override
        public PrototypeType type() {
            return PrototypeType.EMPTY;
        }

        @Override
        public void build(EntryBuilderContext context) {
            context.entriesBuilder().add(new PieceEntry(pos -> null, Map.of(Direction.DOWN, this.connector, Direction.UP, this.connector, Direction.NORTH, this.connector, Direction.EAST, this.connector, Direction.SOUTH, this.connector, Direction.WEST, this.connector)));
        }
    }

    public record PieceEntry(Function<BlockPos, StructurePiece> constructor, Map<Direction, ConnectorType> connections) {
    }
}

