/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.structure.wfc;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public final class WFCUtil {

    public static final class PerformanceMeasurer {
        private final Map<Type, Long> measuredTimes = new EnumMap<Type, Long>(Type.class);
        private final Map<Type, Long> measurementStarts = new EnumMap<Type, Long>(Type.class);

        void start(Type type) {
            this.measurementStarts.put(type, System.currentTimeMillis());
        }

        void end(Type type) {
            long measuredTime = System.currentTimeMillis() - this.measurementStarts.remove((Object)type);
            this.measuredTimes.merge(type, measuredTime, Long::sum);
        }

        public String toString() {
            return this.measuredTimes.toString();
        }

        static enum Type {
            CENTER,
            ENTROPY_SEARCH,
            ENTROPY_CALC,
            ADJACENCY_UPDATE;

        }
    }

    static final class MinValueSearchResult<T> {
        private final List<T> entries = new ArrayList<T>();
        private final double value;

        public MinValueSearchResult(T entry, double value) {
            this.value = value;
            this.entries.add(entry);
        }

        public MinValueSearchResult() {
            this.value = Double.MAX_VALUE;
        }

        public static <T> MinValueSearchResult<T> search(Collection<T> collection, ToDoubleFunction<T> valueExtraction) {
            return collection.stream().map(entry -> new MinValueSearchResult<Object>(entry, valueExtraction.applyAsDouble(entry))).reduce(new MinValueSearchResult<T>(), MinValueSearchResult::combine);
        }

        public MinValueSearchResult<T> combine(MinValueSearchResult<T> other) {
            if (this.value < other.value) {
                return this;
            }
            if (other.value < this.value) {
                return other;
            }
            this.entries.addAll(other.entries);
            return this;
        }

        public List<T> entries() {
            return this.entries;
        }
    }

    static final class EntropyList<T extends WeightedEntry> {
        private final List<T> entries;
        private double cachedEntropy = -1.0;

        EntropyList(List<T> entries) {
            this.entries = entries;
        }

        double getEntropy() {
            if (this.cachedEntropy == -1.0) {
                this.cachedEntropy = EntropyList.calculateEntropy(this.entries);
            }
            return this.cachedEntropy;
        }

        Stream<T> stream() {
            return this.entries.stream();
        }

        boolean removeIf(Predicate<? super T> predicate) {
            boolean removed = this.entries.removeIf(predicate);
            if (removed) {
                this.cachedEntropy = -1.0;
            }
            return removed;
        }

        List<T> entries() {
            return this.entries;
        }

        private static double calculateEntropy(List<? extends WeightedEntry> entries) {
            int totalWeight = WeightedRandom.getTotalWeight(entries);
            double entropy = 0.0;
            for (WeightedEntry weightedEntry : entries) {
                if (weightedEntry.getWeight().asInt() == 0) continue;
                double probability = (double)weightedEntry.getWeight().asInt() / (double)totalWeight;
                entropy += -probability * Math.log(probability);
            }
            return entropy;
        }
    }

    public record PositionTransform(BlockPos cornerPos, CellSize cellSize) {
        public BlockPos toBlockPos(CellPos cellPos) {
            return this.cornerPos.offset(cellPos.x * this.cellSize.width(), cellPos.y * this.cellSize.height(), cellPos.z * this.cellSize.width());
        }

        public RandomSource random(PositionalRandomFactory randomFactory) {
            return randomFactory.at(this.cornerPos);
        }

        public PositionTransform offset(int x, int z) {
            return new PositionTransform(this.cornerPos.offset(x * this.cellSize.width(), 0, z * this.cellSize.width()), this.cellSize);
        }
    }

    public record CellPos(int x, int y, int z) {
        public Optional<CellPos> tryOffset(Direction direction, Dimensions dimensions, boolean loopHorizontalEdges) {
            int newX = this.x + direction.getStepX();
            int newY = this.y + direction.getStepY();
            int newZ = this.z + direction.getStepZ();
            if (loopHorizontalEdges) {
                newX = dimensions.loopX(newX);
                newZ = dimensions.loopZ(newZ);
            }
            if (!dimensions.isInBounds(newX, newY, newZ)) {
                return Optional.empty();
            }
            return Optional.of(new CellPos(newX, newY, newZ));
        }

        public static Iterable<CellPos> iterateBox(final int minX, final int minY, final int minZ, final int maxX, final int maxY, final int maxZ) {
            return () -> new AbstractIterator<CellPos>(){
                @Nullable
                CellPos pos = null;

                @Nullable
                protected CellPos computeNext() {
                    if (this.pos == null) {
                        this.pos = new CellPos(minX, minY, minZ);
                    } else if (this.pos.y < maxY) {
                        this.pos = new CellPos(this.pos.x, this.pos.y + 1, this.pos.z);
                    } else if (this.pos.z < maxZ) {
                        this.pos = new CellPos(this.pos.x, minY, this.pos.z + 1);
                    } else if (this.pos.x < maxX) {
                        this.pos = new CellPos(this.pos.x + 1, minY, minZ);
                    } else {
                        return (CellPos)this.endOfData();
                    }
                    return this.pos;
                }
            };
        }
    }

    public record CellSize(int width, int height) {
    }

    public record Dimensions(int xAxisCells, int yAxisCells, int zAxisCells) {
        public Dimensions {
            if (xAxisCells <= 0) {
                throw new IllegalArgumentException("Nonpositive x size: " + xAxisCells);
            }
            if (yAxisCells <= 0) {
                throw new IllegalArgumentException("Nonpositive y size: " + xAxisCells);
            }
            if (zAxisCells <= 0) {
                throw new IllegalArgumentException("Nonpositive z size: " + xAxisCells);
            }
        }

        public boolean isInBounds(int x, int y, int z) {
            return 0 <= x && x < this.xAxisCells() && 0 <= y && y < this.yAxisCells() && 0 <= z && z < this.zAxisCells();
        }

        public boolean isOnEdge(CellPos cellPos, Direction edge) {
            return switch (edge) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> {
                    if (cellPos.y() == 0) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.UP -> {
                    if (cellPos.y() == this.yAxisCells() - 1) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.NORTH -> {
                    if (cellPos.z() == 0) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.SOUTH -> {
                    if (cellPos.z() == this.zAxisCells() - 1) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.WEST -> {
                    if (cellPos.x() == 0) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.EAST -> cellPos.x() == this.xAxisCells() - 1;
            };
        }

        public int loopX(int x) {
            if (x < 0) {
                return this.xAxisCells() - 1;
            }
            if (x >= this.xAxisCells()) {
                return 0;
            }
            return x;
        }

        public int loopZ(int z) {
            if (z < 0) {
                return this.zAxisCells() - 1;
            }
            if (z >= this.zAxisCells()) {
                return 0;
            }
            return z;
        }

        public CellPos projectOntoEdge(CellPos pos, Direction edge) {
            int z;
            int y;
            int x = edge == Direction.WEST ? 0 : (edge == Direction.EAST ? this.xAxisCells() - 1 : pos.x);
            if (!this.isInBounds(x, y = edge == Direction.DOWN ? 0 : (edge == Direction.UP ? this.yAxisCells() - 1 : pos.y), z = edge == Direction.NORTH ? 0 : (edge == Direction.SOUTH ? this.zAxisCells() - 1 : pos.z))) {
                throw new IllegalArgumentException("Unable to project pos " + String.valueOf(pos) + " on edge " + String.valueOf(edge) + " in dimensions " + String.valueOf(this));
            }
            return new CellPos(x, y, z);
        }

        public Iterable<CellPos> iterateAll() {
            return CellPos.iterateBox(0, 0, 0, this.xAxisCells() - 1, this.yAxisCells() - 1, this.zAxisCells() - 1);
        }

        public Iterable<CellPos> iterateEdge(Direction direction) {
            int minX = direction != Direction.EAST ? 0 : this.xAxisCells() - 1;
            int minY = direction != Direction.UP ? 0 : this.yAxisCells() - 1;
            int minZ = direction != Direction.SOUTH ? 0 : this.zAxisCells() - 1;
            int maxX = direction != Direction.WEST ? this.xAxisCells() - 1 : 0;
            int maxY = direction != Direction.DOWN ? this.yAxisCells() - 1 : 0;
            int maxZ = direction != Direction.NORTH ? this.zAxisCells() - 1 : 0;
            return CellPos.iterateBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }
}

