/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypeSpawnCategory;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.world.gen.LandChunkGenerator;
import com.mraof.minestuck.world.lands.GristTypeLayer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber
public class GristLayerInfo {
    public static final String INFO = "grist_layer.info";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceKey<Level>, GristLayerInfo> infoByWorldMap = new HashMap<ResourceKey<Level>, GristLayerInfo>();
    private final GristTypeLayer anyGristLayer;
    private final GristTypeLayer commonGristLayer;
    private final GristTypeLayer uncommonGristLayer;

    @SubscribeEvent
    public static void serverStopped(ServerStoppedEvent event) {
        infoByWorldMap.clear();
    }

    private static Optional<GristLayerInfo> initAndGetGristLayer(ServerLevel level) {
        ChunkGenerator generator = level.getChunkSource().getGenerator();
        if (generator instanceof LandChunkGenerator) {
            GristType baseType;
            long seed = level.getSeed();
            Optional<SburbPlayerData> landData = SburbPlayerData.getForLand(level);
            if (landData.isPresent()) {
                baseType = landData.get().getBaseGrist();
            } else {
                LOGGER.error("Unable to find sburb connection for land dimension \"{}\" when creating grist layers. Defaulting to amber base type.", (Object)level.dimension().location());
                baseType = GristTypes.AMBER.get();
            }
            GristLayerInfo info = new GristLayerInfo(seed, baseType);
            infoByWorldMap.put((ResourceKey<Level>)level.dimension(), info);
            return Optional.of(info);
        }
        return Optional.empty();
    }

    public static Optional<GristLayerInfo> get(ServerLevel world) {
        if (infoByWorldMap.containsKey(world.dimension())) {
            return Optional.ofNullable(infoByWorldMap.get(world.dimension()));
        }
        return GristLayerInfo.initAndGetGristLayer(world);
    }

    private GristLayerInfo(long seed, GristType baseType) {
        this.commonGristLayer = GristTypeLayer.createLayer(GristTypeSpawnCategory.COMMON, 0, seed, 10, null);
        this.anyGristLayer = GristTypeLayer.createLayer(GristTypeSpawnCategory.ANY, 1, seed, 8, baseType);
        this.uncommonGristLayer = GristTypeLayer.createLayer(GristTypeSpawnCategory.UNCOMMON, 2, seed, 7, baseType);
    }

    public GristType randomTypeFor(LivingEntity entity) {
        if (((Boolean)MinestuckConfig.SERVER.hardMode.get()).booleanValue() && entity.getRandom().nextBoolean()) {
            return GristTypes.ARTIFACT.get();
        }
        BlockPos pos = entity.blockPosition();
        return this.randomLayer(entity.getRandom()).getTypeAt(pos.getX(), pos.getZ());
    }

    private GristTypeLayer randomLayer(RandomSource rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return this.commonGristLayer;
            }
            case 1: {
                return this.uncommonGristLayer;
            }
        }
        return this.anyGristLayer;
    }

    public Component getGristLayerInfo(int x, int z) {
        GristType commonType = this.commonGristLayer.getTypeAt(x, z);
        GristType uncommonType = this.uncommonGristLayer.getTypeAt(x, z);
        GristType anyType = this.anyGristLayer.getTypeAt(x, z);
        return Component.translatable((String)INFO, (Object[])new Object[]{commonType.getDisplayName(), uncommonType.getDisplayName(), anyType.getDisplayName()});
    }

    public GristTypeLayer getCommonGristLayer() {
        return this.commonGristLayer;
    }

    public GristTypeLayer getUncommonGristLayer() {
        return this.uncommonGristLayer;
    }

    public GristTypeLayer getAnyGristLayer() {
        return this.anyGristLayer;
    }
}

