/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands;

import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypeSpawnCategory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class GristTypeLayer {
    private final List<WeightedEntry.Wrapper<GristType>> gristTypes;
    private final int weightSum;
    @Nullable
    private final GristType baseType;
    private final int areaSize;
    private final NormalNoise xShift;
    private final NormalNoise zShift;
    private final PositionalRandomFactory selectionRandom;

    private GristTypeLayer(GristTypeSpawnCategory category, int index, long seed, int zoomLevel, @Nullable GristType baseType) {
        this.gristTypes = category.gristTypes().map(type -> WeightedEntry.wrap((Object)type, (int)Math.round(type.getRarity() * 100.0f))).toList();
        this.weightSum = WeightedRandom.getTotalWeight(this.gristTypes);
        this.baseType = baseType;
        this.areaSize = 1 << zoomLevel;
        PositionalRandomFactory randomFactory = WorldgenRandom.Algorithm.XOROSHIRO.newInstance(seed).forkPositional();
        this.xShift = NormalNoise.create((RandomSource)randomFactory.fromHashOf("minestuck:grist_x_shift_" + index), (int)(-(zoomLevel - 1)), (double[])new double[]{1.0});
        this.zShift = NormalNoise.create((RandomSource)randomFactory.fromHashOf("minestuck:grist_z_shift_" + index), (int)(-(zoomLevel - 1)), (double[])new double[]{1.0});
        this.selectionRandom = randomFactory.fromHashOf("minestuck:grist_layer_" + index).forkPositional();
    }

    public static GristTypeLayer createLayer(GristTypeSpawnCategory category, int index, long seed, int zoomLevel, @Nullable GristType baseType) {
        return new GristTypeLayer(category, index, seed, zoomLevel, baseType);
    }

    public GristType getTypeAt(int posX, int posZ) {
        double shiftedX = (double)posX / (double)this.areaSize + 0.2 * this.xShift.getValue((double)posX, 0.0, (double)posZ);
        double shiftedZ = (double)posZ / (double)this.areaSize + 0.2 * this.zShift.getValue((double)posX, 0.0, (double)posZ);
        return this.pickGristWithoutZoom((int)Math.round(shiftedX), (int)Math.round(shiftedZ));
    }

    private GristType pickGristWithoutZoom(int x, int z) {
        if (this.baseType != null && x * x + z * z <= 1) {
            return this.baseType;
        }
        return (GristType)((WeightedEntry.Wrapper)WeightedRandom.getWeightedItem(this.gristTypes, (int)this.selectionRandom.at(x, 0, z).nextInt(this.weightSum)).orElseThrow()).data();
    }
}

