/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands;

import com.mraof.minestuck.world.biome.LandBiomeSetType;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import net.minecraft.world.phys.Vec3;

public class LandProperties {
    public final LandBiomeSetType biomes;
    public float skylightBase;
    private Vec3 skyColor;
    private Vec3 fogColor;
    public ForceType forceRain = ForceType.OFF;
    public ForceType forceThunder = ForceType.OFF;

    public static LandProperties create(LandTypePair types) {
        LandProperties properties = LandProperties.createPartial(types.getTerrain());
        types.getTitle().setProperties(properties);
        return properties;
    }

    public static LandProperties createPartial(TerrainLandType type) {
        LandProperties properties = new LandProperties(type);
        type.setProperties(properties);
        return properties;
    }

    private LandProperties(TerrainLandType type) {
        this.biomes = type.getBiomeSet();
        this.skylightBase = type.getSkylightBase();
        this.skyColor = type.getSkyColor();
        this.fogColor = type.getFogColor();
    }

    public void mergeFogColor(Vec3 fogColor, float strength) {
        double d1 = (this.fogColor.x + fogColor.x * (double)strength) / (double)(1.0f + strength);
        double d2 = (this.fogColor.y + fogColor.y * (double)strength) / (double)(1.0f + strength);
        double d3 = (this.fogColor.z + fogColor.z * (double)strength) / (double)(1.0f + strength);
        this.fogColor = new Vec3(d1, d2, d3);
    }

    public Vec3 getSkyColor() {
        return this.skyColor;
    }

    public Vec3 getFogColor() {
        return this.fogColor;
    }

    public static enum ForceType {
        ON,
        DEFAULT,
        OFF;

    }
}

