/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands;

import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.util.Teleport;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="minestuck")
public class LandRespawnHandler {
    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player;
        if (event.isEndConquered() || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.getRespawnPosition() != null) {
            return;
        }
        ResourceKey<Level> land = SburbPlayerData.get(IdentifierHandler.encode((Player)player2), player2.server).getLandDimensionIfEntered();
        if (land == null) {
            return;
        }
        ServerLevel landLevel = player2.server.getLevel(land);
        if (landLevel == null) {
            return;
        }
        int spawnFuzz = 12;
        int spawnFuzzHalf = spawnFuzz / 2;
        BlockPos spawn = new BlockPos(player2.getRandom().nextInt(spawnFuzz) - spawnFuzzHalf, 0, player2.getRandom().nextInt(spawnFuzz) - spawnFuzzHalf);
        int y = landLevel.getChunk(spawn).getHeight(Heightmap.Types.MOTION_BLOCKING, spawn.getX() & 0xF, spawn.getZ() & 0xF) + 1;
        if (y >= 0) {
            spawn = new BlockPos(spawn.getX(), y, spawn.getZ());
        }
        Teleport.teleportEntity((Entity)player2, landLevel, (double)spawn.getX() + 0.5, spawn.getY(), (double)spawn.getZ() + 0.5);
    }
}

