/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.gen.LandChunkGenerator;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.LandTypes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class LandTypeExtensions {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final FileToIdConverter TERRAIN_EXTENSIONS_LOCATION = FileToIdConverter.json((String)"minestuck/land_type_extension/terrain");
    public static final FileToIdConverter TITLE_EXTENSIONS_LOCATION = FileToIdConverter.json((String)"minestuck/land_type_extension/title");
    private final Map<ILandType, List<Extension>> extensionsMap;
    private static LandTypeExtensions instance;

    private LandTypeExtensions(Map<ILandType, List<Extension>> extensionsMap) {
        this.extensionsMap = extensionsMap;
    }

    public void addBiomeGenExtensions(LandBiomeGenBuilder builder, LandTypePair landTypes) {
        this.extensionsMap.getOrDefault(landTypes.getTerrain(), Collections.emptyList()).forEach(extension -> extension.addTo(builder));
        this.extensionsMap.getOrDefault(landTypes.getTitle(), Collections.emptyList()).forEach(extension -> extension.addTo(builder));
    }

    public void addMobSpawnExtensions(MobSpawnSettings.Builder builder, LandBiomeType type, LandTypePair landTypes) {
        this.extensionsMap.getOrDefault(landTypes.getTerrain(), Collections.emptyList()).forEach(extension -> extension.addTo(builder, type));
        this.extensionsMap.getOrDefault(landTypes.getTitle(), Collections.emptyList()).forEach(extension -> extension.addTo(builder, type));
    }

    public List<StructureSetExtension> getStructureSetsFor(ILandType landType) {
        return this.extensionsMap.getOrDefault(landType, Collections.emptyList()).stream().filter(ext -> ext instanceof StructureSetExtension).map(ext -> (StructureSetExtension)ext).toList();
    }

    public static LandTypeExtensions get() {
        return Objects.requireNonNull(instance, "Tried to get an instance of LandTypeExtensions too early.");
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Loader(event.getRegistryAccess()));
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        instance = null;
    }

    private static final class Loader
    extends SimplePreparableReloadListener<Map<ILandType, List<Extension>>> {
        private final DynamicOps<JsonElement> ops;
        private final Registry<LevelStem> levelStems;

        private Loader(RegistryAccess registryAccess) {
            this.ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
            this.levelStems = registryAccess.registryOrThrow(Registries.LEVEL_STEM);
        }

        protected Map<ILandType, List<Extension>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            this.loadAllExtensionsAt(TERRAIN_EXTENSIONS_LOCATION, LandTypes.TERRAIN_REGISTRY, (ImmutableMap.Builder<ILandType, List<Extension>>)mapBuilder, resourceManager);
            this.loadAllExtensionsAt(TITLE_EXTENSIONS_LOCATION, LandTypes.TITLE_REGISTRY, (ImmutableMap.Builder<ILandType, List<Extension>>)mapBuilder, resourceManager);
            return mapBuilder.build();
        }

        private void loadAllExtensionsAt(FileToIdConverter location, Registry<? extends ILandType> registry, ImmutableMap.Builder<ILandType, List<Extension>> mapBuilder, ResourceManager resourceManager) {
            for (Map.Entry entry : location.listMatchingResourceStacks(resourceManager).entrySet()) {
                ResourceLocation id = location.fileToId((ResourceLocation)entry.getKey());
                ILandType landType = (ILandType)registry.get(id);
                if (landType == null) {
                    LOGGER.error("Found extension for unknown land type '{}'", (Object)id);
                    continue;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Resource resource : (List)entry.getValue()) {
                    this.loadExtensionsFromResource(resource, id).ifPresent(extensions -> extensions.addAllTo((ImmutableList.Builder<Extension>)builder));
                }
                mapBuilder.put((Object)landType, (Object)builder.build());
            }
        }

        private Optional<ParsedExtension> loadExtensionsFromResource(Resource resource, ResourceLocation location) {
            Optional optional;
            block8: {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    optional = ParsedExtension.CODEC.parse(this.ops, (Object)json).resultOrPartial(message -> LOGGER.error("Problem parsing land type extension for {} from {}, reason: {}", (Object)location, (Object)resource.sourcePackId(), message));
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }

        protected void apply(Map<ILandType, List<Extension>> extensionsMap, ResourceManager resourceManager, ProfilerFiller profiler) {
            LandTypeExtensions extensions = new LandTypeExtensions(extensionsMap);
            boolean allSuccess = true;
            for (LevelStem levelStem : this.levelStems) {
                ChunkGenerator chunkGenerator = levelStem.generator();
                if (!(chunkGenerator instanceof LandChunkGenerator)) continue;
                LandChunkGenerator generator = (LandChunkGenerator)chunkGenerator;
                allSuccess &= generator.tryInit(extensions);
            }
            if (!allSuccess) {
                LOGGER.warn("Land type extensions were reloaded mid-game. Any changes to land type extensions will only apply to new land dimensions. The game need to be restarted for said changes to apply to existing land dimensions.");
            }
            instance = extensions;
        }
    }

    public record StructureSetExtension(StructureSet structureSet) implements Extension
    {
        static Codec<StructureSetExtension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructureSet.DIRECT_CODEC.fieldOf("structure_set").forGetter(StructureSetExtension::structureSet)).apply((Applicative)instance, StructureSetExtension::new));
    }

    private static interface Extension {
        default public void addTo(LandBiomeGenBuilder builder) {
        }

        default public void addTo(MobSpawnSettings.Builder builder, LandBiomeType type) {
        }
    }

    public record ParsedExtension(List<FeatureExtension> features, List<CarverExtension> carvers, List<MobSpawnExtension> mobSpawns, List<StructureSetExtension> structureSets) {
        public static Codec<ParsedExtension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FeatureExtension.CODEC.listOf().optionalFieldOf("features", Collections.emptyList()).forGetter(ParsedExtension::features), (App)CarverExtension.CODEC.listOf().optionalFieldOf("carvers", Collections.emptyList()).forGetter(ParsedExtension::carvers), (App)MobSpawnExtension.CODEC.listOf().optionalFieldOf("mob_spawns", Collections.emptyList()).forGetter(ParsedExtension::mobSpawns), (App)StructureSetExtension.CODEC.listOf().optionalFieldOf("structure_sets", Collections.emptyList()).forGetter(ParsedExtension::structureSets)).apply((Applicative)instance, ParsedExtension::new));

        void addAllTo(ImmutableList.Builder<Extension> builder) {
            builder.addAll(this.features());
            builder.addAll(this.carvers());
            builder.addAll(this.mobSpawns());
            builder.addAll(this.structureSets());
        }
    }

    public record MobSpawnExtension(MobCategory category, MobSpawnSettings.SpawnerData spawnerData, List<LandBiomeType> biomeTypes) implements Extension
    {
        static Codec<MobSpawnExtension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobCategory.CODEC.fieldOf("category").forGetter(MobSpawnExtension::category), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("spawner_data").forGetter(MobSpawnExtension::spawnerData), (App)LandBiomeType.CODEC.listOf().fieldOf("biome_types").forGetter(MobSpawnExtension::biomeTypes)).apply((Applicative)instance, MobSpawnExtension::new));

        @Override
        public void addTo(MobSpawnSettings.Builder builder, LandBiomeType type) {
            if (this.biomeTypes.contains((Object)type)) {
                builder.addSpawn(this.category, this.spawnerData);
            }
        }
    }

    public record CarverExtension(GenerationStep.Carving step, Holder<ConfiguredWorldCarver<?>> carver, List<LandBiomeType> biomeTypes) implements Extension
    {
        static Codec<CarverExtension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GenerationStep.Carving.CODEC.fieldOf("step").forGetter(CarverExtension::step), (App)ConfiguredWorldCarver.CODEC.fieldOf("carver").forGetter(CarverExtension::carver), (App)LandBiomeType.CODEC.listOf().fieldOf("biome_types").forGetter(CarverExtension::biomeTypes)).apply((Applicative)instance, CarverExtension::new));

        @Override
        public void addTo(LandBiomeGenBuilder builder) {
            builder.addCarver(this.step, this.carver, this.biomeTypes.toArray(new LandBiomeType[0]));
        }
    }

    public record FeatureExtension(GenerationStep.Decoration step, Holder<PlacedFeature> feature, List<LandBiomeType> biomeTypes) implements Extension
    {
        static Codec<FeatureExtension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(FeatureExtension::step), (App)PlacedFeature.CODEC.fieldOf("feature").forGetter(FeatureExtension::feature), (App)LandBiomeType.CODEC.listOf().fieldOf("biome_types").forGetter(FeatureExtension::biomeTypes)).apply((Applicative)instance, FeatureExtension::new));

        @Override
        public void addTo(LandBiomeGenBuilder builder) {
            builder.addFeature(this.step, this.feature, this.biomeTypes.toArray(new LandBiomeType[0]));
        }
    }
}

