/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.world.gen.LandChunkGenerator;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;

public record LandTypePair(TerrainLandType terrain, TitleLandType title) {
    public static final Codec<LandTypePair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TerrainLandType.CODEC.fieldOf("terrain").forGetter(LandTypePair::getTerrain), (App)TitleLandType.CODEC.fieldOf("title").forGetter(LandTypePair::getTitle)).apply((Applicative)instance, LandTypePair::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LandTypePair> STREAM_CODEC = StreamCodec.composite(TerrainLandType.STREAM_CODEC, LandTypePair::terrain, TitleLandType.STREAM_CODEC, LandTypePair::title, LandTypePair::new);
    public static final Style LAND_OF_COPYLEFT_AND_FREEDOM_FONT_STYLE = Style.EMPTY.withFont(ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"land_of_copyleft_and_freedom"));
    public static final String FORMAT = "land.format";

    @Nonnull
    public TerrainLandType getTerrain() {
        return this.terrain;
    }

    @Nonnull
    public TitleLandType getTitle() {
        return this.title;
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.putString("terrain_aspect", LandTypes.TERRAIN_REGISTRY.getKey((Object)this.terrain).toString());
        nbt.putString("title_aspect", LandTypes.TITLE_REGISTRY.getKey((Object)this.title).toString());
        return nbt;
    }

    public static LandTypePair read(CompoundTag nbt) {
        String terrainName = nbt.getString("terrain_aspect");
        String titleName = nbt.getString("title_aspect");
        TerrainLandType terrain = (TerrainLandType)LandTypes.TERRAIN_REGISTRY.get(Minestuck.id(terrainName));
        TitleLandType title = (TitleLandType)LandTypes.TITLE_REGISTRY.get(Minestuck.id(titleName));
        Objects.requireNonNull(terrain, "Could not find terrain land aspect by name " + terrainName);
        Objects.requireNonNull(title, "Could not find title land aspect by name " + titleName);
        return new LandTypePair(terrain, title);
    }

    public static Optional<LandTypePair> getTypes(MinecraftServer server, ResourceKey<Level> levelKey) {
        return LandTypePair.getNamed(server, levelKey).map(Named::landTypes);
    }

    public static Optional<LandTypePair> getTypes(ServerLevel level) {
        return LandTypePair.getNamed(level).map(Named::landTypes);
    }

    public static LandTypePair getTypesOrDefaulted(ChunkGenerator generator) {
        return LandTypePair.getNamed(generator).map(Named::landTypes).orElseGet(() -> new LandTypePair(LandTypes.TERRAIN_NULL.get(), LandTypes.TITLE_NULL.get()));
    }

    public static Optional<Named> getNamed(MinecraftServer server, ResourceKey<Level> levelKey) {
        return Optional.ofNullable(server.getLevel(levelKey)).flatMap(LandTypePair::getNamed);
    }

    public static Optional<Named> getNamed(ServerLevel level) {
        return LandTypePair.getNamed(level.getChunkSource().getGenerator());
    }

    public static Optional<Named> getNamed(ChunkGenerator generator) {
        if (generator instanceof LandChunkGenerator) {
            LandChunkGenerator chunkGenerator = (LandChunkGenerator)generator;
            return Optional.of(chunkGenerator.namedTypes);
        }
        return Optional.empty();
    }

    public Named createNamedRandomly(RandomSource random) {
        return new Named(this, random.nextBoolean(), random.nextInt(this.terrain.getNames().length), random.nextInt(this.title.getNames().length));
    }

    public record Named(LandTypePair landTypes, boolean useReverseOrder, int terrainNameIndex, int titleNameIndex) {
        public static final Codec<Named> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC.fieldOf("types").forGetter(Named::landTypes), (App)Codec.BOOL.fieldOf("reverse").forGetter(Named::useReverseOrder), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("terrain_name").forGetter(Named::terrainNameIndex), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("title_name").forGetter(Named::titleNameIndex)).apply((Applicative)instance, Named::new));

        private Component landName(boolean first) {
            if (first != this.useReverseOrder) {
                return Component.translatable((String)("land." + Named.loopingGet(this.landTypes.getTerrain().getNames(), this.terrainNameIndex)));
            }
            return Component.translatable((String)("land." + Named.loopingGet(this.landTypes.getTitle().getNames(), this.titleNameIndex)));
        }

        public MutableComponent asComponent() {
            return Component.translatable((String)LandTypePair.FORMAT, (Object[])new Object[]{this.landName(true), this.landName(false)});
        }

        public Component asComponentWithLandFont() {
            return this.asComponent().withStyle(LAND_OF_COPYLEFT_AND_FREEDOM_FONT_STYLE);
        }

        private static String loopingGet(String[] names, int index) {
            return names[Math.floorMod(index, names.length)];
        }
    }
}

