/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands;

import com.mraof.minestuck.world.lands.LandProperties;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.timers.TimerQueue;

public class LandWorldInfo
implements ServerLevelData {
    private final ServerLevelData wrapped;
    private final LandProperties.ForceType forceRain;
    private final LandProperties.ForceType forceThunder;
    private final long dayTime;
    private static final int SUNSET_START = 11868;
    private static final int SUNSET_END = 13670;

    public LandWorldInfo(ServerLevelData wrapped, LandProperties.ForceType forceRain, LandProperties.ForceType forceThunder, double skylight) {
        this.wrapped = wrapped;
        this.forceRain = forceRain;
        this.forceThunder = forceThunder;
        this.dayTime = LandWorldInfo.dayTimeFromSkylight(skylight);
    }

    private static long dayTimeFromSkylight(double desiredLight) {
        int STEPS = 20;
        for (int i = 0; i <= 20; ++i) {
            int timeTicks = Math.round(Mth.lerp((float)((float)i / 20.0f), (float)11868.0f, (float)13670.0f));
            double timeFraction = Mth.frac((double)((double)timeTicks / 24000.0 - 0.25));
            double light = 0.5 + 2.0 * Math.cos((timeFraction = (2.0 * timeFraction + (0.5 - Math.cos(timeFraction * Math.PI) / 2.0)) / 3.0) * 2.0 * Math.PI);
            if (!(desiredLight >= light)) continue;
            return timeTicks;
        }
        return 13670L;
    }

    public boolean isRaining() {
        if (this.forceRain == LandProperties.ForceType.ON) {
            return true;
        }
        if (this.forceRain == LandProperties.ForceType.OFF) {
            return false;
        }
        return this.wrapped.isRaining();
    }

    public boolean isThundering() {
        if (this.forceThunder == LandProperties.ForceType.ON) {
            return true;
        }
        if (this.forceThunder == LandProperties.ForceType.OFF) {
            return false;
        }
        return this.wrapped.isThundering();
    }

    public void setSpawn(BlockPos spawnPoint, float spawnAngle) {
    }

    public BlockPos getSpawnPos() {
        return new BlockPos(0, 0, 0);
    }

    public long getDayTime() {
        return this.dayTime;
    }

    public float getDayTimeFraction() {
        return 0.0f;
    }

    public float getDayTimePerTick() {
        return 0.0f;
    }

    public void setDayTimeFraction(float dayTimeFraction) {
    }

    public void setDayTimePerTick(float dayTimePerTick) {
    }

    public float getSpawnAngle() {
        return this.wrapped.getSpawnAngle();
    }

    public long getGameTime() {
        return this.wrapped.getGameTime();
    }

    public void setRaining(boolean isRaining) {
        this.wrapped.setRaining(isRaining);
    }

    public boolean isHardcore() {
        return this.wrapped.isHardcore();
    }

    public GameRules getGameRules() {
        return this.wrapped.getGameRules();
    }

    public Difficulty getDifficulty() {
        return this.wrapped.getDifficulty();
    }

    public boolean isDifficultyLocked() {
        return this.wrapped.isDifficultyLocked();
    }

    public String getLevelName() {
        return this.wrapped.getLevelName();
    }

    public void setThundering(boolean isThundering) {
        this.wrapped.setThundering(isThundering);
    }

    public int getRainTime() {
        return this.wrapped.getRainTime();
    }

    public void setRainTime(int rainTime) {
        this.wrapped.setRainTime(rainTime);
    }

    public void setThunderTime(int thunderTime) {
        this.wrapped.setThunderTime(thunderTime);
    }

    public int getThunderTime() {
        return this.wrapped.getThunderTime();
    }

    public int getClearWeatherTime() {
        return this.wrapped.getClearWeatherTime();
    }

    public void setClearWeatherTime(int weatherTime) {
        this.wrapped.setClearWeatherTime(weatherTime);
    }

    public int getWanderingTraderSpawnDelay() {
        return this.wrapped.getWanderingTraderSpawnDelay();
    }

    public void setWanderingTraderSpawnDelay(int spawnDelay) {
        this.wrapped.setWanderingTraderSpawnDelay(spawnDelay);
    }

    public int getWanderingTraderSpawnChance() {
        return this.wrapped.getWanderingTraderSpawnChance();
    }

    public void setWanderingTraderSpawnChance(int spawnChance) {
        this.wrapped.setWanderingTraderSpawnChance(spawnChance);
    }

    @Nullable
    public UUID getWanderingTraderId() {
        return this.wrapped.getWanderingTraderId();
    }

    public void setWanderingTraderId(UUID id) {
        this.wrapped.setWanderingTraderId(id);
    }

    public GameType getGameType() {
        return this.wrapped.getGameType();
    }

    public void setWorldBorder(WorldBorder.Settings border) {
        this.wrapped.setWorldBorder(border);
    }

    public WorldBorder.Settings getWorldBorder() {
        return this.wrapped.getWorldBorder();
    }

    public boolean isInitialized() {
        return this.wrapped.isInitialized();
    }

    public void setInitialized(boolean isInitialized) {
        this.wrapped.setInitialized(isInitialized);
    }

    public boolean isAllowCommands() {
        return this.wrapped.isAllowCommands();
    }

    public void setGameType(GameType gameType) {
        this.wrapped.setGameType(gameType);
    }

    public TimerQueue<MinecraftServer> getScheduledEvents() {
        return this.wrapped.getScheduledEvents();
    }

    public void setGameTime(long gameTime) {
        this.wrapped.setGameTime(gameTime);
    }

    public void setDayTime(long dayTime) {
        this.wrapped.setDayTime(dayTime);
    }
}

