/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands;

import com.mraof.minestuck.world.lands.LandProperties;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.LandWorldInfo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck")
public class WeatherManager {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            LandTypePair.getTypes(level).ifPresent(landTypes -> {
                LandProperties properties = LandProperties.create(landTypes);
                WritableLevelData patt0$temp = level.levelData;
                if (patt0$temp instanceof ServerLevelData) {
                    ServerLevelData levelData = (ServerLevelData)patt0$temp;
                    level.levelData = new LandWorldInfo(levelData, properties.forceRain, properties.forceThunder, properties.skylightBase);
                } else {
                    LOGGER.error("Expected level data on server side to be an instance of IServerWorldInfo. Was {}", (Object)level.levelData.getClass());
                }
            });
        }
    }
}

