/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.gen;

import com.google.common.collect.Lists;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.gen.LandTypeSelection;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LandTypeGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Random random;

    public LandTypeGenerator(long seed) {
        this.random = new Random(seed);
    }

    public TerrainLandType getTerrainAspect(TitleLandType aspect2, List<TerrainLandType> usedAspects) {
        TerrainLandType aspect = this.selectRandomAspect(usedAspects, LandTypeSelection.terrainAlternatives(), aspect2::isAspectCompatible);
        if (aspect != null) {
            return aspect;
        }
        LOGGER.error("No land aspect is compatible with the title aspect {}! Defaulting to null land aspect.", (Object)LandTypes.TITLE_REGISTRY.getKey((Object)aspect2));
        return LandTypes.TERRAIN_NULL.get();
    }

    public TitleLandType getTitleAspect(TerrainLandType aspectTerrain, EnumAspect titleAspect, List<TitleLandType> usedAspects) {
        Collection<List<TitleLandType>> alternatives = LandTypeSelection.titleAlternatives(titleAspect);
        TitleLandType landAspect = aspectTerrain != null ? this.selectRandomAspect(usedAspects, alternatives, aspect -> aspect.isAspectCompatible(aspectTerrain)) : this.selectRandomAspect(usedAspects, alternatives, aspect -> true);
        if (landAspect != null) {
            return landAspect;
        }
        return LandTypes.TITLE_NULL.get();
    }

    private <A extends ILandType> A selectRandomAspect(List<A> usedAspects, Iterable<? extends Collection<A>> groups, Predicate<A> condition) {
        ArrayList list = Lists.newArrayList();
        for (Collection<A> group : groups) {
            ArrayList variantList = Lists.newArrayList(group);
            variantList.removeIf(condition.negate());
            if (variantList.isEmpty()) continue;
            list.add(new ChoiceEntry<A>(variantList, group));
        }
        ChoiceEntry entry = this.pickOneFromUsage(list, usedAspects, (variants, used) -> variants.all().contains(used));
        if (entry == null) {
            return null;
        }
        return (A)this.pickOneFromUsage(entry.allowed, usedAspects, Object::equals);
    }

    private <A extends ILandType, B> B pickOneFromUsage(List<B> list, List<A> usedAspects, BiPredicate<B, A> matchPredicate) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int[] useCount = new int[list.size()];
        for (ILandType usedAspect : usedAspects) {
            for (int i = 0; i < list.size(); ++i) {
                if (!matchPredicate.test(list.get(i), usedAspect)) continue;
                int n = i;
                useCount[n] = useCount[n] + 1;
            }
        }
        ArrayList<B> unusedEntries = new ArrayList<B>();
        for (int i = 0; i < list.size(); ++i) {
            if (useCount[i] != 0) continue;
            unusedEntries.add(list.get(i));
        }
        if (unusedEntries.size() > 0) {
            return (B)unusedEntries.get(this.random.nextInt(unusedEntries.size()));
        }
        double randCap = 0.0;
        for (int value : useCount) {
            randCap += 1.0 / (double)value;
        }
        double rand = this.random.nextDouble() * randCap;
        for (int i = 0; i < useCount.length; ++i) {
            if (rand < 1.0 / (double)useCount[i]) {
                return list.get(i);
            }
            rand -= 1.0 / (double)useCount[i];
        }
        throw new IllegalStateException("This should not happen!");
    }

    private record ChoiceEntry<A>(List<A> allowed, Collection<A> all) {
    }
}

