/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.gen.LandTypeSelection;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class LandTypeSelectionLoader
extends SimplePreparableReloadListener<RawData> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String TERRAIN_PATH = "minestuck/terrain_land_types.json";
    public static final String TITLE_PATH = "minestuck/title_land_types.json";
    private static final Codec<GroupData> GROUP_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)ResourceLocation.CODEC.listOf(), (Codec)ExtraCodecs.TAG_OR_ELEMENT_ID).fieldOf("value").forGetter(GroupData::value)).apply((Applicative)instance, GroupData::new));
    private static final Codec<List<GroupData>> TERRAIN_DATA_CODEC = GROUP_DATA_CODEC.listOf();
    private static final Codec<Map<EnumAspect, List<GroupData>>> TITLE_DATA_CODEC = Codec.unboundedMap(EnumAspect.CODEC, (Codec)GROUP_DATA_CODEC.listOf());

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new LandTypeSelectionLoader());
    }

    protected RawData prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<GroupData> terrainData = new ArrayList<GroupData>();
        for (String namespace : resourceManager.getNamespaces()) {
            LandTypeSelectionLoader.parseTerrainGroupsFromNamespace(resourceManager, namespace).ifPresent(terrainData::addAll);
        }
        HashMap<EnumAspect, List<GroupData>> titleData = new HashMap<EnumAspect, List<GroupData>>();
        for (EnumAspect aspect : EnumAspect.values()) {
            titleData.put(aspect, new ArrayList());
        }
        for (String namespace : resourceManager.getNamespaces()) {
            LandTypeSelectionLoader.parseTitleGroupsFromNamespace(resourceManager, namespace).ifPresent(parsedData -> {
                for (EnumAspect aspect : parsedData.keySet()) {
                    ((List)titleData.get((Object)aspect)).addAll((Collection)parsedData.get((Object)aspect));
                }
            });
        }
        return new RawData(terrainData, titleData);
    }

    private static Optional<List<GroupData>> parseTerrainGroupsFromNamespace(ResourceManager resourceManager, String namespace) {
        return LandTypeSelectionLoader.parseCodecDataFromLocation(resourceManager, ResourceLocation.fromNamespaceAndPath((String)namespace, (String)TERRAIN_PATH), TERRAIN_DATA_CODEC);
    }

    private static Optional<Map<EnumAspect, List<GroupData>>> parseTitleGroupsFromNamespace(ResourceManager resourceManager, String namespace) {
        return LandTypeSelectionLoader.parseCodecDataFromLocation(resourceManager, ResourceLocation.fromNamespaceAndPath((String)namespace, (String)TITLE_PATH), TITLE_DATA_CODEC);
    }

    private static <T> Optional<T> parseCodecDataFromLocation(ResourceManager resourceManager, ResourceLocation location, Codec<T> codec) {
        return resourceManager.getResource(location).flatMap(resource -> {
            Optional optional;
            block8: {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    optional = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(message -> LOGGER.error("Problem parsing json: {}, reason: {}", (Object)location, message));
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        });
    }

    protected void apply(RawData data, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableList.Builder terrainGroupsBuilder = ImmutableList.builder();
        for (GroupData terrainGroup : data.terrainTypeData()) {
            terrainGroup.lookup(LandTypes.TERRAIN_REGISTRY).ifPresent(arg_0 -> ((ImmutableList.Builder)terrainGroupsBuilder).add(arg_0));
        }
        ImmutableMap.Builder titleMapBuilder = ImmutableMap.builder();
        for (EnumAspect aspect : EnumAspect.values()) {
            ImmutableList.Builder titleGroupsBuilder = ImmutableList.builder();
            for (GroupData titleGroup : data.titleTypeData().get((Object)aspect)) {
                titleGroup.lookup(LandTypes.TITLE_REGISTRY).ifPresent(arg_0 -> ((ImmutableList.Builder)titleGroupsBuilder).add(arg_0));
            }
            titleMapBuilder.put((Object)aspect, (Object)titleGroupsBuilder.build());
        }
        LandTypeSelection.setData((List<LandTypeSelection.Group<TerrainLandType>>)terrainGroupsBuilder.build(), (Map<EnumAspect, List<LandTypeSelection.Group<TitleLandType>>>)titleMapBuilder.build());
    }

    public record RawData(List<GroupData> terrainTypeData, Map<EnumAspect, List<GroupData>> titleTypeData) {
    }

    private record GroupData(Either<List<ResourceLocation>, ExtraCodecs.TagOrElementLocation> value) {
        private <A> Optional<LandTypeSelection.Group<A>> lookup(Registry<A> registry) {
            return (Optional)this.value.map(list -> {
                ArrayList elements = new ArrayList();
                for (ResourceLocation id : list) {
                    GroupData.getOrLog(registry, id).ifPresent(elements::add);
                }
                if (elements.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(LandTypeSelection.Group.of(elements));
            }, location -> {
                if (location.tag()) {
                    TagKey tag = TagKey.create((ResourceKey)registry.key(), (ResourceLocation)location.id());
                    return Optional.of(LandTypeSelection.Group.of(tag));
                }
                return GroupData.getOrLog(registry, location.id()).map(landType -> LandTypeSelection.Group.of(Collections.singletonList(landType)));
            });
        }

        private static <A> Optional<A> getOrLog(Registry<A> registry, ResourceLocation id) {
            Object element = registry.get(id);
            if (element == null) {
                LOGGER.error("Could not find land type for id in registry {}: {}", (Object)registry.key(), (Object)id);
            }
            return Optional.ofNullable(element);
        }
    }
}

