/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.biome.MSBiomes;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.NakagatorVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.placement.EndPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class EndLandType
extends TerrainLandType {
    public static final String END = "minestuck.end";
    public static final String DIMENSION = "minestuck.dimension";

    public EndLandType() {
        super(new TerrainLandType.Builder(MSEntityTypes.NAKAGATOR).names(END, DIMENSION).fogColor(0.0, 0.4, 0.2).skyColor(0.3, 0.1, 0.5).biomeSet(MSBiomes.NO_RAIN_LAND).music(MSSoundEvents.MUSIC_END));
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        registry.setBlock("cruxite_ore", (Supplier<? extends Block>)MSBlocks.END_STONE_CRUXITE_ORE);
        registry.setBlock("uranium_ore", (Supplier<? extends Block>)MSBlocks.END_STONE_URANIUM_ORE);
        registry.setBlock("ground", (Supplier<? extends Block>)MSBlocks.COARSE_END_STONE);
        registry.setBlock("upper", Blocks.END_STONE);
        registry.setBlock("surface", Blocks.END_STONE);
        registry.setBlock("surface_rough", (Supplier<? extends Block>)MSBlocks.END_GRASS);
        registry.setBlock("ocean", (Supplier<? extends Block>)MSBlocks.ENDER);
        registry.setBlock("structure_primary", Blocks.END_STONE_BRICKS);
        registry.setBlockState("structure_primary_decorative", (BlockState)Blocks.PURPUR_PILLAR.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y));
        registry.setBlock("structure_primary_stairs", Blocks.END_STONE_BRICK_STAIRS);
        registry.setBlock("structure_primary_slab", Blocks.END_STONE_BRICK_SLAB);
        registry.setBlock("structure_primary_wall", Blocks.END_STONE_BRICK_WALL);
        registry.setBlock("structure_secondary", Blocks.PURPUR_BLOCK);
        registry.setBlock("structure_secondary_stairs", Blocks.PURPUR_STAIRS);
        registry.setBlock("structure_secondary_slab", Blocks.PURPUR_SLAB);
        registry.setBlock("structure_wood", (Supplier<? extends Block>)MSBlocks.END_WOOD);
        registry.setBlock("structure_log", (Supplier<? extends Block>)MSBlocks.END_LOG);
        registry.setBlock("structure_stripped_wood", (Supplier<? extends Block>)MSBlocks.STRIPPED_END_WOOD);
        registry.setBlock("structure_stripped_log", (Supplier<? extends Block>)MSBlocks.STRIPPED_END_LOG);
        registry.setBlock("structure_planks", (Supplier<? extends Block>)MSBlocks.END_PLANKS);
        registry.setBlock("structure_bookshelf", (Supplier<? extends Block>)MSBlocks.END_BOOKSHELF);
        registry.setBlock("structure_planks_stairs", (Supplier<? extends Block>)MSBlocks.END_STAIRS);
        registry.setBlock("structure_planks_slab", (Supplier<? extends Block>)MSBlocks.END_SLAB);
        registry.setBlock("structure_planks_fence", (Supplier<? extends Block>)MSBlocks.END_FENCE);
        registry.setBlock("structure_planks_fence_gate", (Supplier<? extends Block>)MSBlocks.END_FENCE_GATE);
        registry.setBlock("structure_planks_door", (Supplier<? extends Block>)MSBlocks.END_DOOR);
        registry.setBlock("structure_planks_trapdoor", (Supplier<? extends Block>)MSBlocks.END_TRAPDOOR);
        registry.setBlock("village_path", (Supplier<? extends Block>)MSBlocks.COARSE_END_STONE);
        registry.setBlock("structure_wool_1", Blocks.GREEN_WOOL);
        registry.setBlock("structure_wool_3", Blocks.PURPLE_WOOL);
        registry.setBlock("structure_ground_cover", (Supplier<? extends Block>)MSBlocks.TALL_END_GRASS);
        registry.setBlock("structure_roof_cover", (Supplier<? extends Block>)MSBlocks.END_LEAVES);
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.END_TREE, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.END_GRASS_SURFACE_DISK, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.TALL_END_GRASS_PATCH, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.END_STONE_SURFACE_DISK, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)EndPlacements.CHORUS_PLANT, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.TALL_END_GRASS_PATCH, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.END_STONE_IRON_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)40), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.END_STONE_REDSTONE_ORE.get()).defaultBlockState(), 8), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.END_STONE.defaultBlockState(), 36), new PlacementModifier[]{CountPlacement.of((int)80), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        NakagatorVillagePieces.addCenters(register);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        NakagatorVillagePieces.addPieces(register, random);
    }
}

