/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.biome.MSBiomes;
import com.mraof.minestuck.world.gen.LandGenSettings;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.IguanaVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.LandProperties;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Supplier;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class FrostLandType
extends TerrainLandType {
    public static final String FROST = "minestuck.frost";
    public static final String ICE = "minestuck.ice";
    public static final String SNOW = "minestuck.snow";

    public FrostLandType() {
        super(new TerrainLandType.Builder(MSEntityTypes.IGUANA).names(FROST, ICE, SNOW).skylight(0.875f).fogColor(0.5, 0.6, 0.98).skyColor(0.6, 0.7, 0.9).biomeSet(MSBiomes.SNOW_LAND).music(MSSoundEvents.MUSIC_FROST));
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        registry.setBlock("upper", Blocks.DIRT);
        registry.setBlock("surface", Blocks.GRASS_BLOCK);
        registry.setBlock("river", Blocks.ICE);
        registry.setBlock("structure_primary", (Supplier<? extends Block>)MSBlocks.FROST_BRICKS);
        registry.setBlock("structure_primary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_FROST_BRICKS);
        registry.setBlock("structure_primary_cracked", (Supplier<? extends Block>)MSBlocks.CRACKED_FROST_BRICKS);
        registry.setBlock("structure_primary_column", (Supplier<? extends Block>)MSBlocks.FROST_COLUMN);
        registry.setBlock("structure_primary_stairs", (Supplier<? extends Block>)MSBlocks.FROST_BRICK_STAIRS);
        registry.setBlock("structure_primary_slab", (Supplier<? extends Block>)MSBlocks.FROST_BRICK_SLAB);
        registry.setBlock("structure_primary_wall", (Supplier<? extends Block>)MSBlocks.FROST_BRICK_WALL);
        registry.setBlock("structure_primary_mossy", (Supplier<? extends Block>)MSBlocks.FLOWERY_FROST_BRICKS);
        registry.setBlock("structure_primary_mossy_stairs", (Supplier<? extends Block>)MSBlocks.FLOWERY_FROST_BRICK_STAIRS);
        registry.setBlock("structure_primary_mossy_slab", (Supplier<? extends Block>)MSBlocks.FLOWERY_FROST_BRICK_SLAB);
        registry.setBlock("structure_primary_mossy_wall", (Supplier<? extends Block>)MSBlocks.FLOWERY_FROST_BRICK_WALL);
        registry.setBlock("structure_secondary", (Supplier<? extends Block>)MSBlocks.FROST_TILE);
        registry.setBlock("structure_secondary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_FROST_TILE);
        registry.setBlock("structure_secondary_stairs", (Supplier<? extends Block>)MSBlocks.FROST_TILE_STAIRS);
        registry.setBlock("structure_secondary_slab", (Supplier<? extends Block>)MSBlocks.FROST_TILE_SLAB);
        registry.setBlock("structure_secondary_wall", (Supplier<? extends Block>)MSBlocks.FROST_TILE_WALL);
        registry.setBlock("structure_planks", Blocks.SPRUCE_PLANKS);
        registry.setBlock("structure_planks_slab", Blocks.SPRUCE_SLAB);
        registry.setBlock("structure_wool_1", Blocks.WHITE_WOOL);
        registry.setBlock("structure_wool_3", Blocks.CYAN_WOOL);
        registry.setBlock("light_block", Blocks.SEA_LANTERN);
        registry.setBlock("bucket_1", Blocks.SNOW_BLOCK);
        registry.setBlock("bush", Blocks.FERN);
    }

    @Override
    public void setProperties(LandProperties properties) {
        properties.forceRain = LandProperties.ForceType.ON;
    }

    @Override
    public void setGenSettings(LandGenSettings settings) {
        settings.oceanThreshold = -0.3f;
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, (ResourceKey<PlacedFeature>)MiscOverworldPlacements.ICEBERG_PACKED, LandBiomeType.OCEAN);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, (ResourceKey<PlacedFeature>)MiscOverworldPlacements.ICEBERG_BLUE, LandBiomeType.OCEAN);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.ICE_SPIKE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.FLUID_SPRINGS, (ResourceKey<PlacedFeature>)MiscOverworldPlacements.SPRING_LAVA_FROZEN, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.FROST_TREE, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.COARSE_DIRT_DISK, LandBiomeType.anyExcept(LandBiomeType.NORMAL));
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.SNOW_BLOCK_DISK, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.SMALL_SNOW_BLOCK_DISK, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.ICE_DISK, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.PACKED_ICE.defaultBlockState(), 40), new PlacementModifier[]{CountPlacement.of((int)8), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.SNOW_BLOCK.defaultBlockState(), 80), new PlacementModifier[]{CountPlacement.of((int)10), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.DIRT.defaultBlockState(), 28), new PlacementModifier[]{CountPlacement.of((int)6), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.COAL_ORE.defaultBlockState(), 17), new PlacementModifier[]{CountPlacement.of((int)26), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.DIAMOND_ORE.defaultBlockState(), 6), new PlacementModifier[]{CountPlacement.of((int)11), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)24)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, (ResourceKey<PlacedFeature>)MiscOverworldPlacements.FREEZE_TOP_LAYER, LandBiomeType.any());
        builder.addCarver(GenerationStep.Carving.AIR, Carvers.CAVE, LandBiomeType.any());
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        IguanaVillagePieces.addCenters(register);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        IguanaVillagePieces.addPieces(register, random);
    }
}

