/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.biome.MSBiomes;
import com.mraof.minestuck.world.gen.feature.FeatureModifier;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.NakagatorVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Supplier;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class HeatLandType
extends TerrainLandType {
    public static final String HEAT = "minestuck.heat";
    public static final String FLAME = "minestuck.flame";
    public static final String FIRE = "minestuck.fire";

    public HeatLandType() {
        super(new TerrainLandType.Builder(MSEntityTypes.NAKAGATOR).names(HEAT, FLAME, FIRE).skylight(0.5f).fogColor(0.4, 0.0, 0.0).biomeSet(MSBiomes.NO_RAIN_LAND).music(MSSoundEvents.MUSIC_HEAT));
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        registry.setBlock("cruxite_ore", (Supplier<? extends Block>)MSBlocks.BLACK_STONE_CRUXITE_ORE);
        registry.setBlock("uranium_ore", (Supplier<? extends Block>)MSBlocks.BLACK_STONE_URANIUM_ORE);
        registry.setBlock("ground", (Supplier<? extends Block>)MSBlocks.BLACK_STONE);
        registry.setBlock("ground_slab", (Supplier<? extends Block>)MSBlocks.BLACK_STONE_SLAB);
        registry.setBlock("surface", (Supplier<? extends Block>)MSBlocks.IGNEOUS_STONE);
        registry.setBlock("upper", (Supplier<? extends Block>)MSBlocks.PUMICE_STONE);
        registry.setBlock("ocean", (Supplier<? extends Block>)MSBlocks.MOLTEN_AMBER);
        registry.setBlock("structure_primary", (Supplier<? extends Block>)MSBlocks.BLACK_STONE_BRICKS);
        registry.setBlock("structure_primary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_BLACK_STONE_BRICKS);
        registry.setBlock("structure_primary_cracked", (Supplier<? extends Block>)MSBlocks.CRACKED_BLACK_STONE_BRICKS);
        registry.setBlock("structure_primary_column", (Supplier<? extends Block>)MSBlocks.BLACK_STONE_COLUMN);
        registry.setBlock("structure_primary_stairs", (Supplier<? extends Block>)MSBlocks.BLACK_STONE_BRICK_STAIRS);
        registry.setBlock("structure_primary_slab", (Supplier<? extends Block>)MSBlocks.BLACK_STONE_BRICK_SLAB);
        registry.setBlock("structure_primary_wall", (Supplier<? extends Block>)MSBlocks.BLACK_STONE_BRICK_WALL);
        registry.setBlock("structure_primary_mossy", (Supplier<? extends Block>)MSBlocks.MAGMATIC_BLACK_STONE_BRICKS);
        registry.setBlock("structure_primary_mossy_stairs", (Supplier<? extends Block>)MSBlocks.MAGMATIC_BLACK_STONE_BRICK_STAIRS);
        registry.setBlock("structure_primary_mossy_slab", (Supplier<? extends Block>)MSBlocks.MAGMATIC_BLACK_STONE_BRICK_SLAB);
        registry.setBlock("structure_primary_mossy_wall", (Supplier<? extends Block>)MSBlocks.MAGMATIC_BLACK_STONE_BRICK_WALL);
        registry.setBlock("structure_secondary", (Supplier<? extends Block>)MSBlocks.POLISHED_IGNEOUS_BRICKS);
        registry.setBlock("structure_secondary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_IGNEOUS_STONE);
        registry.setBlock("structure_secondary_stairs", (Supplier<? extends Block>)MSBlocks.POLISHED_IGNEOUS_BRICK_STAIRS);
        registry.setBlock("structure_secondary_slab", (Supplier<? extends Block>)MSBlocks.POLISHED_IGNEOUS_BRICK_SLAB);
        registry.setBlock("structure_secondary_wall", (Supplier<? extends Block>)MSBlocks.POLISHED_IGNEOUS_BRICK_WALL);
        registry.setBlock("structure_wood", (Supplier<? extends Block>)MSBlocks.CINDERED_WOOD);
        registry.setBlock("structure_log", (Supplier<? extends Block>)MSBlocks.CINDERED_LOG);
        registry.setBlock("structure_stripped_wood", (Supplier<? extends Block>)MSBlocks.STRIPPED_CINDERED_WOOD);
        registry.setBlock("structure_stripped_log", (Supplier<? extends Block>)MSBlocks.STRIPPED_CINDERED_LOG);
        registry.setBlock("structure_planks", (Supplier<? extends Block>)MSBlocks.CINDERED_PLANKS);
        registry.setBlock("structure_planks_stairs", (Supplier<? extends Block>)MSBlocks.CINDERED_STAIRS);
        registry.setBlock("structure_planks_slab", (Supplier<? extends Block>)MSBlocks.CINDERED_SLAB);
        registry.setBlock("structure_planks_fence", (Supplier<? extends Block>)MSBlocks.CINDERED_FENCE);
        registry.setBlock("structure_planks_fence_gate", (Supplier<? extends Block>)MSBlocks.CINDERED_FENCE_GATE);
        registry.setBlock("structure_planks_door", (Supplier<? extends Block>)MSBlocks.CINDERED_DOOR);
        registry.setBlock("structure_planks_trapdoor", (Supplier<? extends Block>)MSBlocks.CINDERED_TRAPDOOR);
        registry.setBlock("structure_wool_1", Blocks.YELLOW_WOOL);
        registry.setBlock("structure_wool_3", Blocks.PURPLE_WOOL);
        registry.setBlock("village_path", (Supplier<? extends Block>)MSBlocks.BLACK_SAND);
        registry.setBlock("village_fence", (Supplier<? extends Block>)MSBlocks.POLISHED_IGNEOUS_BRICK_WALL);
        registry.setBlock("fall_fluid", Blocks.WATER);
        registry.setBlock("light_block", (Supplier<? extends Block>)MSBlocks.HEAT_LAMP);
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.CINDERED_TREE, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SINGED_GRASS_PATCH, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SINGED_FOLIAGE_PATCH, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.IGNEOUS_SPIKE_PATCH, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SULFUR_BUBBLE_PATCH, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.SULFUR_POOL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.CAST_IRON_BUILDING, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.CAST_IRON_PLATFORM, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.FLUID_SPRINGS, MSPlacedFeatures.OCEAN_RUNDOWN, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.MAGMATIC_IGNEOUS_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.BLACK_SAND_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.PUMICE_STONE_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.FIRE_FIELD, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.EXTRA_FIRE_FIELD, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.BLACK_STONE.get()).defaultBlockState(), 80), new PlacementModifier[]{CountPlacement.of((int)6), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)256)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.BLACK_STONE_GOLD_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)18), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.BLACK_STONE_REDSTONE_ORE.get()).defaultBlockState(), 7), new PlacementModifier[]{CountPlacement.of((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.BLACK_STONE_QUARTZ_ORE.get()).defaultBlockState(), 8), new PlacementModifier[]{CountPlacement.of((int)26), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addCarver(GenerationStep.Carving.AIR, Carvers.NETHER_CAVE, LandBiomeType.any());
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        NakagatorVillagePieces.addCenters(register);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        NakagatorVillagePieces.addPieces(register, random);
    }
}

