/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.biome.MSBiomes;
import com.mraof.minestuck.world.gen.LandGenSettings;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.TurtleVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class RainLandType
extends TerrainLandType {
    public static final String RAIN = "minestuck.rain";
    public static final String ISLANDS = "minestuck.islands";
    public static final String SKY = "minestuck.sky";

    public RainLandType() {
        super(new TerrainLandType.Builder(MSEntityTypes.TURTLE).names(RAIN, ISLANDS, SKY).fogColor(0.9, 0.8, 0.6).skyColor(0.3, 0.5, 0.98).biomeSet(MSBiomes.HIGH_HUMID_LAND).music(MSSoundEvents.MUSIC_RAIN));
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        registry.setBlock("ground", (Supplier<? extends Block>)MSBlocks.PINK_STONE);
        registry.setBlock("ground_slab", (Supplier<? extends Block>)MSBlocks.PINK_STONE_SLAB);
        registry.setBlock("surface", (Supplier<? extends Block>)MSBlocks.CHALK);
        registry.setBlock("upper", (Supplier<? extends Block>)MSBlocks.CHALK);
        registry.setBlock("ocean", Blocks.WATER);
        registry.setBlock("structure_primary", (Supplier<? extends Block>)MSBlocks.PINK_STONE_BRICKS);
        registry.setBlock("structure_primary_cracked", (Supplier<? extends Block>)MSBlocks.CRACKED_PINK_STONE_BRICKS);
        registry.setBlock("structure_primary_mossy", (Supplier<? extends Block>)MSBlocks.MOSSY_PINK_STONE_BRICKS);
        registry.setBlock("structure_primary_column", (Supplier<? extends Block>)MSBlocks.PINK_STONE_COLUMN);
        registry.setBlock("structure_primary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_PINK_STONE_BRICKS);
        registry.setBlock("structure_primary_stairs", (Supplier<? extends Block>)MSBlocks.PINK_STONE_BRICK_STAIRS);
        registry.setBlock("structure_secondary", (Supplier<? extends Block>)MSBlocks.POLISHED_PINK_STONE);
        registry.setBlock("structure_secondary_stairs", (Supplier<? extends Block>)MSBlocks.CHALK_BRICK_STAIRS);
        registry.setBlock("structure_secondary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_PINK_STONE_BRICKS);
        registry.setBlock("structure_planks", (Supplier<? extends Block>)MSBlocks.DEAD_PLANKS);
        registry.setBlock("structure_planks_slab", (Supplier<? extends Block>)MSBlocks.DEAD_SLAB);
        registry.setBlock("bush", Blocks.DEAD_BUSH);
        registry.setBlock("structure_wool_1", Blocks.YELLOW_WOOL);
        registry.setBlock("structure_wool_3", Blocks.MAGENTA_WOOL);
        registry.setBlock("cruxite_ore", (Supplier<? extends Block>)MSBlocks.PINK_STONE_CRUXITE_ORE);
        registry.setBlock("uranium_ore", (Supplier<? extends Block>)MSBlocks.PINK_STONE_URANIUM_ORE);
    }

    @Override
    public void setGenSettings(LandGenSettings settings) {
        settings.oceanThreshold = 0.2f;
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.DEAD_TREE, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.EXTRA_DEAD_TREE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.PINK_STONE_COAL_ORE.get()).defaultBlockState(), 17), new PlacementModifier[]{CountPlacement.of((int)26), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.PINK_STONE_LAPIS_ORE.get()).defaultBlockState(), 7), new PlacementModifier[]{CountPlacement.of((int)15), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)24)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.PINK_STONE_GOLD_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)12), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.PINK_STONE_DIAMOND_ORE.get()).defaultBlockState(), 6), new PlacementModifier[]{CountPlacement.of((int)11), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)24)), BiomeFilter.biome()}), LandBiomeType.any());
    }

    @Override
    public void addStructureSets(Consumer<StructureSet> consumer, HolderGetter<Structure> structureLookup) {
        super.addStructureSets(consumer, structureLookup);
        consumer.accept(new StructureSet((Holder)structureLookup.getOrThrow(MSStructures.PINK_TOWER), (StructurePlacement)new RandomSpreadStructurePlacement(35, 10, RandomSpreadType.LINEAR, 90543602)));
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        TurtleVillagePieces.addCenters(register);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        TurtleVillagePieces.addPieces(register, random);
    }
}

