/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.gen.MSSurfaceRules;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.TurtleVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class RainbowLandType
extends TerrainLandType {
    public static final String RAINBOW = "minestuck.rainbow";
    public static final String COLORS = "minestuck.colors";

    public RainbowLandType() {
        super(new TerrainLandType.Builder(MSEntityTypes.TURTLE).names(RAINBOW, COLORS).fogColor(0.0, 0.6, 0.8).skyColor(0.9, 0.6, 0.8).music(MSSoundEvents.MUSIC_RAINBOW));
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        registry.setBlock("upper", Blocks.WHITE_TERRACOTTA);
        registry.setBlock("surface", Blocks.WHITE_WOOL);
        registry.setBlock("ocean", (Supplier<? extends Block>)MSBlocks.WATER_COLORS);
        registry.setBlock("structure_primary", (Supplier<? extends Block>)MSBlocks.RAINBOW_PLANKS);
        registry.setBlock("structure_primary_decorative", (Supplier<? extends Block>)MSBlocks.RAINBOW_WOOD);
        registry.setBlock("structure_primary_stairs", (Supplier<? extends Block>)MSBlocks.RAINBOW_STAIRS);
        registry.setBlock("structure_primary_slab", (Supplier<? extends Block>)MSBlocks.RAINBOW_SLAB);
        registry.setBlock("structure_primary_wall", (Supplier<? extends Block>)MSBlocks.RAINBOW_FENCE);
        registry.setBlock("structure_secondary", (Supplier<? extends Block>)MSBlocks.GLOWING_PLANKS);
        registry.setBlock("structure_secondary_decorative", (Supplier<? extends Block>)MSBlocks.GLOWING_WOOD);
        registry.setBlock("structure_secondary_stairs", (Supplier<? extends Block>)MSBlocks.GLOWING_STAIRS);
        registry.setBlock("structure_secondary_slab", (Supplier<? extends Block>)MSBlocks.GLOWING_SLAB);
        registry.setBlock("structure_secondary_wall", (Supplier<? extends Block>)MSBlocks.GLOWING_FENCE);
        registry.setBlock("structure_wood", (Supplier<? extends Block>)MSBlocks.RAINBOW_WOOD);
        registry.setBlock("structure_log", (Supplier<? extends Block>)MSBlocks.RAINBOW_LOG);
        registry.setBlock("structure_stripped_wood", (Supplier<? extends Block>)MSBlocks.STRIPPED_RAINBOW_WOOD);
        registry.setBlock("structure_stripped_log", (Supplier<? extends Block>)MSBlocks.STRIPPED_RAINBOW_LOG);
        registry.setBlock("structure_planks", (Supplier<? extends Block>)MSBlocks.RAINBOW_PLANKS);
        registry.setBlock("structure_bookshelf", (Supplier<? extends Block>)MSBlocks.RAINBOW_BOOKSHELF);
        registry.setBlock("structure_planks_stairs", (Supplier<? extends Block>)MSBlocks.RAINBOW_STAIRS);
        registry.setBlock("structure_planks_slab", (Supplier<? extends Block>)MSBlocks.RAINBOW_SLAB);
        registry.setBlock("structure_planks_fence", (Supplier<? extends Block>)MSBlocks.RAINBOW_FENCE);
        registry.setBlock("structure_planks_fence_gate", (Supplier<? extends Block>)MSBlocks.RAINBOW_FENCE_GATE);
        registry.setBlock("structure_planks_door", (Supplier<? extends Block>)MSBlocks.RAINBOW_DOOR);
        registry.setBlock("structure_planks_trapdoor", (Supplier<? extends Block>)MSBlocks.RAINBOW_TRAPDOOR);
        registry.setBlock("structure_wool_1", Blocks.YELLOW_WOOL);
        registry.setBlock("structure_wool_3", Blocks.GREEN_WOOL);
        registry.setBlock("salamander_floor", Blocks.STONE_BRICKS);
        registry.setBlock("light_block", (Supplier<? extends Block>)MSBlocks.GLOWING_WOOD);
        BlockState rainbow_leaves = (BlockState)((Block)MSBlocks.RAINBOW_LEAVES.get()).defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
        registry.setBlockState("bush", rainbow_leaves);
        registry.setBlockState("mushroom_1", rainbow_leaves);
        registry.setBlockState("mushroom_2", rainbow_leaves);
    }

    @Override
    public void setSpawnInfo(MobSpawnSettings.Builder builder, LandBiomeType type) {
        builder.addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 2, 3, 5));
    }

    @Override
    public SurfaceRules.RuleSource getSurfaceRule(StructureBlockRegistry blocks) {
        MSSurfaceRules.CheckeredRuleSource wool = new MSSurfaceRules.CheckeredRuleSource(1, Stream.of(Blocks.RED_WOOL, Blocks.ORANGE_WOOL, Blocks.YELLOW_WOOL, Blocks.LIME_WOOL, Blocks.LIGHT_BLUE_WOOL, Blocks.BLUE_WOOL, Blocks.PURPLE_WOOL, Blocks.MAGENTA_WOOL).map(Block::defaultBlockState).map(SurfaceRules::state).toList());
        MSSurfaceRules.CheckeredRuleSource terracotta = new MSSurfaceRules.CheckeredRuleSource(1, Stream.of(Blocks.RED_TERRACOTTA, Blocks.ORANGE_TERRACOTTA, Blocks.YELLOW_TERRACOTTA, Blocks.LIME_TERRACOTTA, Blocks.LIGHT_BLUE_TERRACOTTA, Blocks.BLUE_TERRACOTTA, Blocks.PURPLE_TERRACOTTA, Blocks.MAGENTA_TERRACOTTA).map(Block::defaultBlockState).map(SurfaceRules::state).toList());
        SurfaceRules.RuleSource surface = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)0, (int)0), (SurfaceRules.RuleSource)wool));
        SurfaceRules.RuleSource upper = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)terracotta);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surface, upper});
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.EXTRA_RAINBOW_TREE, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.RAINBOW_TREE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.MESA, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.COAL_ORE.defaultBlockState(), 17), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)128)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.REDSTONE_ORE.defaultBlockState(), 8), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.LAPIS_ORE.defaultBlockState(), 7), new PlacementModifier[]{CountPlacement.of((int)15), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)24)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.GOLD_ORE.defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)12), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.EMERALD_ORE.defaultBlockState(), 8), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.DIRT.defaultBlockState(), 24), new PlacementModifier[]{CountPlacement.of((int)6), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.DIORITE.defaultBlockState(), 8), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        TurtleVillagePieces.addCenters(register);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        TurtleVillagePieces.addPieces(register, random);
    }
}

