/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.gen.LandGenSettings;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.ConsortVillageCenter;
import com.mraof.minestuck.world.gen.structure.village.NakagatorVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Supplier;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class RockLandType
extends TerrainLandType {
    public static final String ROCK = "minestuck.rock";
    public static final String STONE = "minestuck.stone";
    public static final String ORE = "minestuck.ore";
    public static final String PETRIFICATION = "minestuck.petrification";
    private final Variant type;

    public static TerrainLandType createRock() {
        return new RockLandType(Variant.ROCK, new TerrainLandType.Builder(MSEntityTypes.NAKAGATOR).names(ROCK, STONE, ORE).skylight(0.875f).fogColor(0.5, 0.5, 0.55).skyColor(0.6, 0.6, 0.7).music(MSSoundEvents.MUSIC_ROCK));
    }

    public static TerrainLandType createPetrification() {
        return new RockLandType(Variant.PETRIFICATION, new TerrainLandType.Builder(MSEntityTypes.NAKAGATOR).names(PETRIFICATION).skylight(0.875f).fogColor(0.5, 0.5, 0.55).skyColor(0.6, 0.6, 0.7).music(MSSoundEvents.MUSIC_PETRIFICATION));
    }

    private RockLandType(Variant variation, TerrainLandType.Builder builder) {
        super(builder);
        this.type = variation;
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        registry.setBlock("surface", this.type == Variant.PETRIFICATION ? Blocks.STONE : Blocks.GRAVEL);
        registry.setBlock("upper", Blocks.COBBLESTONE);
        registry.setBlock("structure_primary", (Supplier<? extends Block>)MSBlocks.COARSE_STONE_BRICKS);
        registry.setBlock("structure_primary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_COARSE_STONE_BRICKS);
        registry.setBlock("structure_primary_cracked", (Supplier<? extends Block>)MSBlocks.CRACKED_COARSE_STONE_BRICKS);
        registry.setBlock("structure_primary_column", (Supplier<? extends Block>)MSBlocks.COARSE_STONE_COLUMN);
        registry.setBlock("structure_primary_stairs", (Supplier<? extends Block>)MSBlocks.COARSE_STONE_BRICK_STAIRS);
        registry.setBlock("structure_primary_slab", (Supplier<? extends Block>)MSBlocks.COARSE_STONE_BRICK_SLAB);
        registry.setBlock("structure_primary_wall", (Supplier<? extends Block>)MSBlocks.COARSE_STONE_BRICK_WALL);
        registry.setBlock("structure_primary_mossy", (Supplier<? extends Block>)MSBlocks.MOSSY_COARSE_STONE_BRICKS);
        registry.setBlock("structure_secondary", (Supplier<? extends Block>)MSBlocks.COARSE_STONE);
        registry.setBlock("structure_secondary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_COARSE_STONE);
        registry.setBlock("structure_secondary_stairs", (Supplier<? extends Block>)MSBlocks.COARSE_STONE_STAIRS);
        registry.setBlock("structure_secondary_slab", (Supplier<? extends Block>)MSBlocks.COARSE_STONE_SLAB);
        registry.setBlock("structure_secondary_wall", (Supplier<? extends Block>)MSBlocks.COARSE_STONE_WALL);
        registry.setBlock("structure_wood", (Supplier<? extends Block>)MSBlocks.PETRIFIED_WOOD);
        registry.setBlock("structure_log", (Supplier<? extends Block>)MSBlocks.PETRIFIED_LOG);
        registry.setBlock("structure_planks_slab", Blocks.BRICK_SLAB);
        registry.setBlock("village_path", Blocks.MOSSY_COBBLESTONE);
        registry.setBlock("village_fence", Blocks.COBBLESTONE_WALL);
        registry.setBlock("structure_wool_1", Blocks.BROWN_WOOL);
        registry.setBlock("structure_wool_3", Blocks.GRAY_WOOL);
    }

    @Override
    public void setGenSettings(LandGenSettings settings) {
        settings.oceanThreshold = -0.3f;
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.DISK, new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)Blocks.CLAY), BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("ocean_surface").getBlock(), Blocks.CLAY}), (IntProvider)UniformInt.of((int)2, (int)5), 2), new PlacementModifier[]{CountPlacement.of((int)25), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID}), LandBiomeType.OCEAN);
        if (this.type == Variant.ROCK) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SPARSE_PETRIFIED_TREE, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.RANDOM_ROCK_BLOCK_BLOB, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.LARGE_RANDOM_ROCK_BLOCK_BLOB, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SPARSE_PETRIFIED_GRASS_PATCH, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.PETRIFIED_GRASS_PATCH, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.COBBLESTONE_SURFACE_DISK, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.STONE_SURFACE_DISK, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.STONE_MOUND, LandBiomeType.ROUGH);
        } else if (this.type == Variant.PETRIFICATION) {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SPARSE_PETRIFIED_TREE, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.PETRIFIED_TREE, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.COBBLESTONE_BLOCK_BLOB, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.PETRIFIED_GRASS_PATCH, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.PETRIFIED_POPPY_PATCH, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SPARSE_PETRIFIED_GRASS_PATCH, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SPARSE_PETRIFIED_POPPY_PATCH, LandBiomeType.ROUGH);
        }
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)CavePlacements.GLOW_LICHEN, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, MSPlacedFeatures.DRIPSTONE_CLUSTER, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, MSPlacedFeatures.OCEANIC_DRIPSTONE_CLUSTER, LandBiomeType.OCEAN);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, MSPlacedFeatures.LARGE_DRIPSTONE, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, MSPlacedFeatures.POINTED_DRIPSTONE, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, MSPlacedFeatures.OCEANIC_POINTED_DRIPSTONE, LandBiomeType.OCEAN);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)CavePlacements.AMETHYST_GEODE, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.GRAVEL.defaultBlockState(), 33), new PlacementModifier[]{CountPlacement.of((int)12), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)256)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.INFESTED_STONE.defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)14), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)OrePlacements.ORE_GRANITE_UPPER, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)OrePlacements.ORE_GRANITE_LOWER, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)OrePlacements.ORE_DIORITE_UPPER, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)OrePlacements.ORE_DIORITE_LOWER, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)OrePlacements.ORE_ANDESITE_UPPER, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)OrePlacements.ORE_ANDESITE_LOWER, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, (ResourceKey<PlacedFeature>)OrePlacements.ORE_TUFF, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.COAL_ORE.defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.IRON_ORE.defaultBlockState(), 5), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.REDSTONE_ORE.defaultBlockState(), 5), new PlacementModifier[]{CountPlacement.of((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.LAPIS_ORE.defaultBlockState(), 4), new PlacementModifier[]{CountPlacement.of((int)11), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)24)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.STONE_QUARTZ_ORE.get()).defaultBlockState(), 4), new PlacementModifier[]{CountPlacement.of((int)11), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)24)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.GOLD_ORE.defaultBlockState(), 5), new PlacementModifier[]{CountPlacement.of((int)9), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), Blocks.DIAMOND_ORE.defaultBlockState(), 4), new PlacementModifier[]{CountPlacement.of((int)7), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)24)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addCarver(GenerationStep.Carving.AIR, WorldCarver.CAVE.configured((CarverConfiguration)new CaveCarverConfiguration(0.08f, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)8), (VerticalAnchor)VerticalAnchor.absolute((int)180)), (FloatProvider)UniformFloat.of((float)0.1f, (float)0.9f), VerticalAnchor.aboveBottom((int)8), (HolderSet)BuiltInRegistries.BLOCK.getOrCreateTag(BlockTags.OVERWORLD_CARVER_REPLACEABLES), (FloatProvider)UniformFloat.of((float)0.7f, (float)4.4f), (FloatProvider)UniformFloat.of((float)0.8f, (float)4.3f), (FloatProvider)UniformFloat.of((float)-1.0f, (float)-0.4f))), LandBiomeType.any());
        builder.addCarver(GenerationStep.Carving.AIR, Carvers.CAVE, LandBiomeType.any());
        builder.addCarver(GenerationStep.Carving.AIR, Carvers.CAVE_EXTRA_UNDERGROUND, LandBiomeType.any());
        builder.addCarver(GenerationStep.Carving.AIR, Carvers.CANYON, LandBiomeType.any());
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        NakagatorVillagePieces.addCenters(register);
        register.add(ConsortVillageCenter.RockCenter::new, 5);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        NakagatorVillagePieces.addPieces(register, random);
    }

    private static enum Variant {
        ROCK,
        PETRIFICATION;

    }
}

