/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.biome.MSBiomes;
import com.mraof.minestuck.world.gen.LandGenSettings;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.ConsortVillageCenter;
import com.mraof.minestuck.world.gen.structure.village.TurtleVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Supplier;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class SandLandType
extends TerrainLandType {
    public static final String SAND = "minestuck.sand";
    public static final String DUNES = "minestuck.dunes";
    public static final String DESERTS = "minestuck.deserts";
    public static final String LUSH_DESERTS = "minestuck.lush_deserts";
    private final Variant type;

    public static TerrainLandType createSand() {
        return new SandLandType(Variant.SAND, new TerrainLandType.Builder(MSEntityTypes.TURTLE).names(SAND, DUNES, DESERTS).fogColor(0.99, 0.8, 0.05).skyColor(0.8, 0.8, 0.1).biomeSet(MSBiomes.NO_RAIN_LAND).music(MSSoundEvents.MUSIC_SAND));
    }

    public static TerrainLandType createLushDeserts() {
        return new SandLandType(Variant.LUSH_DESERTS, new TerrainLandType.Builder(MSEntityTypes.TURTLE).names(LUSH_DESERTS).fogColor(0.99, 0.8, 0.05).skyColor(0.8, 0.8, 0.1).biomeSet(MSBiomes.NO_RAIN_LAND).music(MSSoundEvents.MUSIC_LUSH_DESERTS));
    }

    public static TerrainLandType createRedSand() {
        return new SandLandType(Variant.RED_SAND, new TerrainLandType.Builder(MSEntityTypes.TURTLE).names(SAND, DUNES, DESERTS).fogColor(0.99, 0.6, 0.05).skyColor(0.8, 0.6, 0.1).biomeSet(MSBiomes.NO_RAIN_LAND).music(MSSoundEvents.MUSIC_SAND));
    }

    private SandLandType(Variant variation, TerrainLandType.Builder builder) {
        super(builder);
        this.type = variation;
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        if (this.type == Variant.SAND || this.type == Variant.LUSH_DESERTS) {
            registry.setBlock("ground", Blocks.SANDSTONE);
            registry.setBlock("ground_slab", Blocks.SANDSTONE_SLAB);
            registry.setBlock("upper", Blocks.SAND);
            registry.setBlock("structure_primary", Blocks.SMOOTH_SANDSTONE);
            registry.setBlock("structure_primary_decorative", Blocks.CHISELED_SANDSTONE);
            registry.setBlock("structure_primary_stairs", Blocks.SANDSTONE_STAIRS);
            registry.setBlock("village_path", Blocks.RED_SAND);
            registry.setBlock("cruxite_ore", (Supplier<? extends Block>)MSBlocks.SANDSTONE_CRUXITE_ORE);
            registry.setBlock("uranium_ore", (Supplier<? extends Block>)MSBlocks.SANDSTONE_URANIUM_ORE);
        } else {
            registry.setBlock("ground", Blocks.RED_SANDSTONE);
            registry.setBlock("ground_slab", Blocks.RED_SANDSTONE_SLAB);
            registry.setBlock("upper", Blocks.RED_SAND);
            registry.setBlock("structure_primary", Blocks.SMOOTH_RED_SANDSTONE);
            registry.setBlock("structure_primary_decorative", Blocks.CHISELED_RED_SANDSTONE);
            registry.setBlock("structure_primary_stairs", Blocks.RED_SANDSTONE_STAIRS);
            registry.setBlock("village_path", Blocks.SAND);
            registry.setBlock("cruxite_ore", (Supplier<? extends Block>)MSBlocks.RED_SANDSTONE_CRUXITE_ORE);
            registry.setBlock("uranium_ore", (Supplier<? extends Block>)MSBlocks.RED_SANDSTONE_URANIUM_ORE);
        }
        registry.setBlockState("river", registry.getBlockState("upper"));
        registry.setBlock("structure_secondary", Blocks.STONE_BRICKS);
        registry.setBlock("structure_secondary_decorative", Blocks.CHISELED_STONE_BRICKS);
        registry.setBlock("structure_secondary_stairs", Blocks.STONE_BRICK_STAIRS);
        registry.setBlock("structure_wood", Blocks.ACACIA_WOOD);
        registry.setBlock("structure_log", Blocks.ACACIA_LOG);
        registry.setBlock("structure_stripped_wood", Blocks.STRIPPED_ACACIA_WOOD);
        registry.setBlock("structure_stripped_log", Blocks.STRIPPED_ACACIA_LOG);
        registry.setBlock("structure_planks", Blocks.ACACIA_PLANKS);
        registry.setBlock("structure_planks_stairs", Blocks.ACACIA_STAIRS);
        registry.setBlock("structure_planks_slab", Blocks.ACACIA_SLAB);
        registry.setBlock("structure_planks_fence", Blocks.ACACIA_FENCE);
        registry.setBlock("structure_planks_fence_gate", Blocks.ACACIA_FENCE_GATE);
        registry.setBlock("structure_planks_door", Blocks.ACACIA_DOOR);
        registry.setBlock("structure_planks_trapdoor", Blocks.ACACIA_TRAPDOOR);
        registry.setBlock("structure_wool_1", Blocks.YELLOW_WOOL);
        registry.setBlock("structure_wool_3", Blocks.MAGENTA_WOOL);
    }

    @Override
    public void setGenSettings(LandGenSettings settings) {
        settings.oceanThreshold = -1.0f;
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        if (this.type == Variant.LUSH_DESERTS) {
            builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.OASIS, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.DESERT_BUSH_PATCH, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SANDY_GRASS_PATCH, LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.TALL_SANDY_GRASS_PATCH, LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.TALL_DEAD_BUSH_PATCH, LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_CACTUS_DECORATED, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SPARSE_DESERT_BUSH_PATCH, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.BLOOMING_CACTUS_PATCH, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_CACTUS_DECORATED, LandBiomeType.ROUGH);
        } else {
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_DEAD_BUSH_2, LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SANDY_GRASS_PATCH, LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.TALL_SANDY_GRASS_PATCH, LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.TALL_DEAD_BUSH_PATCH, LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.OASIS, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_CACTUS_DECORATED, LandBiomeType.NORMAL);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.BLOOMING_CACTUS_PATCH, LandBiomeType.ROUGH);
            builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_CACTUS_DECORATED, LandBiomeType.ROUGH);
        }
        if (this.type != Variant.RED_SAND) {
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.SANDSTONE_IRON_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)48), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.SANDSTONE_GOLD_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)18), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        } else {
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.RED_SANDSTONE_IRON_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)48), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
            builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.RED_SANDSTONE_GOLD_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)18), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        }
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        TurtleVillagePieces.addCenters(register);
        register.add(ConsortVillageCenter.CactusPyramidCenter::new, 5);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        TurtleVillagePieces.addPieces(register, random);
    }

    private static enum Variant {
        SAND,
        LUSH_DESERTS,
        RED_SAND;

    }
}

