/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.SalamanderVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.LandProperties;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ShadeLandType
extends TerrainLandType {
    public static final String SHADE = "minestuck.shade";

    public ShadeLandType() {
        super(new TerrainLandType.Builder(MSEntityTypes.SALAMANDER).names(SHADE).skylight(0.0f).fogColor(0.16, 0.38, 0.54).music(MSSoundEvents.MUSIC_SHADE));
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        registry.setBlock("cruxite_ore", (Supplier<? extends Block>)MSBlocks.SHADE_STONE_CRUXITE_ORE);
        registry.setBlock("uranium_ore", (Supplier<? extends Block>)MSBlocks.SHADE_STONE_URANIUM_ORE);
        registry.setBlock("ground", (Supplier<? extends Block>)MSBlocks.SHADE_STONE);
        registry.setBlock("upper", (Supplier<? extends Block>)MSBlocks.BLUE_DIRT);
        registry.setBlock("ocean", (Supplier<? extends Block>)MSBlocks.OIL);
        registry.setBlock("structure_primary", (Supplier<? extends Block>)MSBlocks.SHADE_BRICKS);
        registry.setBlock("structure_primary_decorative", (Supplier<? extends Block>)MSBlocks.CHISELED_SHADE_BRICKS);
        registry.setBlock("structure_primary_cracked", (Supplier<? extends Block>)MSBlocks.CRACKED_SHADE_BRICKS);
        registry.setBlock("structure_primary_column", (Supplier<? extends Block>)MSBlocks.SHADE_COLUMN);
        registry.setBlock("structure_primary_stairs", (Supplier<? extends Block>)MSBlocks.SHADE_BRICK_STAIRS);
        registry.setBlock("structure_primary_slab", (Supplier<? extends Block>)MSBlocks.SHADE_BRICK_SLAB);
        registry.setBlock("structure_primary_wall", (Supplier<? extends Block>)MSBlocks.SHADE_BRICK_WALL);
        registry.setBlock("structure_primary_mossy", (Supplier<? extends Block>)MSBlocks.TAR_SHADE_BRICKS);
        registry.setBlock("structure_primary_mossy_stairs", (Supplier<? extends Block>)MSBlocks.TAR_SHADE_BRICK_STAIRS);
        registry.setBlock("structure_primary_mossy_slab", (Supplier<? extends Block>)MSBlocks.TAR_SHADE_BRICK_SLAB);
        registry.setBlock("structure_primary_mossy_wall", (Supplier<? extends Block>)MSBlocks.TAR_SHADE_BRICK_WALL);
        registry.setBlock("structure_secondary", (Supplier<? extends Block>)MSBlocks.SMOOTH_SHADE_STONE);
        registry.setBlock("structure_secondary_decorative", (Supplier<? extends Block>)MSBlocks.MOSSY_SHADE_BRICKS);
        registry.setBlock("structure_secondary_stairs", (Supplier<? extends Block>)MSBlocks.SMOOTH_SHADE_STONE_STAIRS);
        registry.setBlock("structure_secondary_slab", (Supplier<? extends Block>)MSBlocks.SMOOTH_SHADE_STONE_SLAB);
        registry.setBlock("structure_secondary_wall", (Supplier<? extends Block>)MSBlocks.SMOOTH_SHADE_STONE_WALL);
        registry.setBlock("structure_wood", (Supplier<? extends Block>)MSBlocks.SHADEWOOD);
        registry.setBlock("structure_log", (Supplier<? extends Block>)MSBlocks.SHADEWOOD_LOG);
        registry.setBlock("structure_stripped_wood", (Supplier<? extends Block>)MSBlocks.STRIPPED_SHADEWOOD);
        registry.setBlock("structure_stripped_log", (Supplier<? extends Block>)MSBlocks.STRIPPED_SHADEWOOD_LOG);
        registry.setBlock("structure_planks", (Supplier<? extends Block>)MSBlocks.SHADEWOOD_PLANKS);
        registry.setBlock("structure_planks_stairs", (Supplier<? extends Block>)MSBlocks.SHADEWOOD_STAIRS);
        registry.setBlock("structure_planks_slab", (Supplier<? extends Block>)MSBlocks.SHADEWOOD_SLAB);
        registry.setBlock("structure_planks_fence", (Supplier<? extends Block>)MSBlocks.SHADEWOOD_FENCE);
        registry.setBlock("structure_planks_fence_gate", (Supplier<? extends Block>)MSBlocks.SHADEWOOD_FENCE_GATE);
        registry.setBlock("structure_planks_door", (Supplier<? extends Block>)MSBlocks.SHADEWOOD_DOOR);
        registry.setBlock("structure_planks_trapdoor", (Supplier<? extends Block>)MSBlocks.SHADEWOOD_TRAPDOOR);
        registry.setBlock("structure_wool_1", Blocks.CYAN_WOOL);
        registry.setBlock("structure_wool_3", Blocks.GRAY_WOOL);
        registry.setBlock("structure_ground_cover", (Supplier<? extends Block>)MSBlocks.GLOWING_MUSHROOM);
        registry.setBlock("structure_roof_cover", (Supplier<? extends Block>)MSBlocks.GLOWING_MUSHROOM_VINES);
        registry.setBlock("village_path", Blocks.GRAVEL);
        registry.setBlock("light_block", (Supplier<? extends Block>)MSBlocks.GLOWING_WOOD);
        registry.setBlock("torch", Blocks.REDSTONE_TORCH);
        registry.setBlock("wall_torch", Blocks.REDSTONE_WALL_TORCH);
        registry.setBlock("mushroom_1", (Supplier<? extends Block>)MSBlocks.GLOWING_MUSHROOM);
        registry.setBlock("mushroom_2", (Supplier<? extends Block>)MSBlocks.GLOWING_MUSHROOM);
        registry.setBlock("bush", (Supplier<? extends Block>)MSBlocks.GLOWING_MUSHROOM);
    }

    @Override
    public void setProperties(LandProperties properties) {
        properties.forceRain = LandProperties.ForceType.DEFAULT;
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.SHADE_STONE_BLOCK_BLOB, LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SPARSE_GLOWING_MUSHROOM_PATCH, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.GLOWING_TREE, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.GLOWING_MUSHROOM_PATCH, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.GLOWING_TREE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SHADEWOOD_TREE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.SCARRED_SHADEWOOD_TREE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.ORNATE_SHADEWOOD_TREE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.OIL_POOL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.BLUE_DIRT.get()).defaultBlockState(), 25), new PlacementModifier[]{CountPlacement.of((int)10), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)256)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.SHADE_STONE_COAL_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)48), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.SHADE_STONE_GOLD_ORE.get()).defaultBlockState(), 7), new PlacementModifier[]{CountPlacement.of((int)18), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.SHADE_STONE_CRUXITE_ORE.get()).defaultBlockState(), 4), new PlacementModifier[]{CountPlacement.of((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.SHADE_STONE_URANIUM_ORE.get()).defaultBlockState(), 2), new PlacementModifier[]{CountPlacement.of((int)12), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        SalamanderVillagePieces.addCenters(register);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        SalamanderVillagePieces.addPieces(register, random);
    }
}

