/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.terrain;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.gen.feature.FeatureModifier;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.village.SalamanderVillagePieces;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class WoodLandType
extends TerrainLandType {
    public static final String WOOD = "minestuck.wood";
    public static final String PLANKS = "minestuck.planks";
    public static final String CARVINGS = "minestuck.carvings";

    public WoodLandType() {
        super(new TerrainLandType.Builder(MSEntityTypes.SALAMANDER).names(WOOD, PLANKS, CARVINGS).skylight(0.5f).fogColor(0.0, 0.16, 0.38).skyColor(0.0, 0.3, 0.4).music(MSSoundEvents.MUSIC_WOOD));
    }

    @Override
    public void registerBlocks(StructureBlockRegistry registry) {
        registry.setBlock("cruxite_ore", (Supplier<? extends Block>)MSBlocks.UNCARVED_WOOD_CRUXITE_ORE);
        registry.setBlock("uranium_ore", (Supplier<? extends Block>)MSBlocks.UNCARVED_WOOD_URANIUM_ORE);
        registry.setBlock("ground", (Supplier<? extends Block>)MSBlocks.UNCARVED_WOOD);
        registry.setBlock("upper", (Supplier<? extends Block>)MSBlocks.UNCARVED_WOOD);
        registry.setBlock("surface", (Supplier<? extends Block>)MSBlocks.UNCARVED_WOOD);
        registry.setBlock("ocean", (Supplier<? extends Block>)MSBlocks.CAULK);
        registry.setBlock("structure_primary", (Supplier<? extends Block>)MSBlocks.TREATED_HEAVY_PLANKS);
        registry.setBlock("structure_primary_decorative", (Supplier<? extends Block>)MSBlocks.POLISHED_TREATED_UNCARVED_WOOD);
        registry.setBlock("structure_primary_cracked", (Supplier<? extends Block>)MSBlocks.TREATED_CHIPBOARD);
        registry.setBlock("structure_primary_column", (Supplier<? extends Block>)MSBlocks.CARVED_LOG);
        registry.setBlock("structure_primary_stairs", (Supplier<? extends Block>)MSBlocks.TREATED_HEAVY_PLANK_STAIRS);
        registry.setBlock("structure_primary_slab", (Supplier<? extends Block>)MSBlocks.TREATED_HEAVY_PLANK_SLAB);
        registry.setBlock("structure_primary_wall", (Supplier<? extends Block>)MSBlocks.TREATED_UNCARVED_WOOD_FENCE);
        registry.setBlock("structure_primary_mossy", (Supplier<? extends Block>)MSBlocks.TREATED_WOOD_SHAVINGS);
        registry.setBlock("structure_primary_mossy_stairs", (Supplier<? extends Block>)MSBlocks.TREATED_CHIPBOARD_STAIRS);
        registry.setBlock("structure_primary_mossy_slab", (Supplier<? extends Block>)MSBlocks.TREATED_CHIPBOARD_SLAB);
        registry.setBlock("structure_primary_mossy_wall", (Supplier<? extends Block>)MSBlocks.TREATED_CHIPBOARD_FENCE);
        registry.setBlock("structure_secondary", (Supplier<? extends Block>)MSBlocks.POLISHED_LACQUERED_UNCARVED_WOOD);
        registry.setBlock("structure_secondary_decorative", (Supplier<? extends Block>)MSBlocks.TREATED_PLANKS);
        registry.setBlock("structure_secondary_stairs", (Supplier<? extends Block>)MSBlocks.POLISHED_LACQUERED_UNCARVED_STAIRS);
        registry.setBlock("structure_secondary_slab", (Supplier<? extends Block>)MSBlocks.POLISHED_LACQUERED_UNCARVED_SLAB);
        registry.setBlock("structure_secondary_wall", (Supplier<? extends Block>)MSBlocks.LACQUERED_CHIPBOARD_FENCE);
        registry.setBlock("structure_wood", (Supplier<? extends Block>)MSBlocks.UNCARVED_WOOD);
        registry.setBlock("structure_log", (Supplier<? extends Block>)MSBlocks.UNCARVED_WOOD);
        registry.setBlock("structure_stripped_wood", (Supplier<? extends Block>)MSBlocks.POLISHED_UNCARVED_WOOD);
        registry.setBlock("structure_stripped_log", (Supplier<? extends Block>)MSBlocks.POLISHED_UNCARVED_WOOD);
        registry.setBlock("structure_planks", (Supplier<? extends Block>)MSBlocks.CARVED_PLANKS);
        registry.setBlock("structure_bookshelf", (Supplier<? extends Block>)MSBlocks.TREATED_BOOKSHELF);
        registry.setBlock("structure_planks_stairs", (Supplier<? extends Block>)MSBlocks.CARVED_STAIRS);
        registry.setBlock("structure_planks_slab", (Supplier<? extends Block>)MSBlocks.CARVED_SLAB);
        registry.setBlock("structure_planks_fence", (Supplier<? extends Block>)MSBlocks.CARVED_FENCE);
        registry.setBlock("structure_planks_fence_gate", (Supplier<? extends Block>)MSBlocks.CARVED_FENCE_GATE);
        registry.setBlock("structure_planks_door", (Supplier<? extends Block>)MSBlocks.CARVED_DOOR);
        registry.setBlock("structure_planks_trapdoor", (Supplier<? extends Block>)MSBlocks.CARVED_TRAPDOOR);
        registry.setBlock("structure_wool_1", Blocks.PURPLE_WOOL);
        registry.setBlock("structure_wool_3", Blocks.GREEN_WOOL);
        registry.setBlock("village_door", (Supplier<? extends Block>)MSBlocks.CARVED_DOOR);
        registry.setBlock("village_path", (Supplier<? extends Block>)MSBlocks.WOOD_SHAVINGS);
        registry.setBlock("light_block", (Supplier<? extends Block>)MSBlocks.WOODEN_LAMP);
        registry.setBlock("bush", (Supplier<? extends Block>)MSBlocks.CARVED_BUSH);
    }

    @Override
    public void addStructureSets(Consumer<StructureSet> consumer, HolderGetter<Structure> structureLookup) {
        super.addStructureSets(consumer, structureLookup);
        consumer.accept(new StructureSet((Holder)structureLookup.getOrThrow(MSStructures.LARGE_WOOD_OBJECT), (StructurePlacement)new RandomSpreadStructurePlacement(5, 3, RandomSpreadType.LINEAR, 17524013)));
    }

    @Override
    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks) {
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.WOODEN_GRASS_PATCH, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.TREATED_WOODEN_GRASS_PATCH, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.CARVED_BUSH_PATCH, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.CARVED_CHERRY_TREE, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.CARVED_HOUSE, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.CARVED_LOG, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.LARGE_CARVED_LOG, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.SPARSE_TREATED_CHAIR, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.SPARSE_TREATED_TABLE, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.UNFINISHED_CARVED_BOOKSHELF, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.SPARSE_UNFINISHED_CARVED_CHAIR, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.UNFINISHED_CARVED_CREEPER, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.SPARSE_UNFINISHED_CARVED_DRAWER, LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.UNFINISHED_CARVED_SALAMANDER, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.SPARSE_UNFINISHED_CARVED_TABLE, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.UNFINISHED_CARVED_TREE, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.UNFINISHED_CARVED_TUNNEL, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.WOOD_SHAVINGS_PILE, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.WOODEN_CACTUS_PAIR, LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.TREATED_PLANKS_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.CARVED_PLANKS_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.NORMAL);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.CHIPBOARD_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.NORMAL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, MSPlacedFeatures.LACQUERED_WOODEN_MUSHROOM_PATCH, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.TREATED_CHAIR, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.TREATED_TABLE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.UNFINISHED_CARVED_CHAIR, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.UNFINISHED_CARVED_DRAWER, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.UNFINISHED_CARVED_TABLE, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.MASSIVE_CHAIR, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MSPlacedFeatures.MASSIVE_STOOL, LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.LACQUERED_PLANKS_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.TREATED_UNCARVED_WOOD_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.TREATED_CHIPBOARD_DISK, FeatureModifier.withTargets(BlockPredicate.matchesBlocks((Block[])new Block[]{blocks.getBlockState("surface").getBlock(), blocks.getBlockState("upper").getBlock()})), LandBiomeType.ROUGH);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.WOOD_SHAVINGS.get()).defaultBlockState(), 33), new PlacementModifier[]{CountPlacement.of((int)10), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)256)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.CHIPBOARD.get()).defaultBlockState(), 17), new PlacementModifier[]{CountPlacement.of((int)27), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)128)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.UNCARVED_WOOD_REDSTONE_ORE.get()).defaultBlockState(), 7), new PlacementModifier[]{CountPlacement.of((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.UNCARVED_WOOD_IRON_ORE.get()).defaultBlockState(), 9), new PlacementModifier[]{CountPlacement.of((int)48), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), ((Block)MSBlocks.UNCARVED_WOOD_EMERALD_ORE.get()).defaultBlockState(), 3), new PlacementModifier[]{CountPlacement.of((int)29), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)24)), BiomeFilter.biome()}), LandBiomeType.any());
    }

    @Override
    public void addVillageCenters(ILandType.CenterRegister register) {
        SalamanderVillagePieces.addCenters(register);
    }

    @Override
    public void addVillagePieces(ILandType.PieceRegister register, RandomSource random) {
        SalamanderVillagePieces.addPieces(register, random);
    }
}

