/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.lands.title;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.world.biome.LandBiomeSetType;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.lands.ILandType;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.LandTypeExtensions;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public abstract class TitleLandType
implements ILandType {
    public static final Codec<TitleLandType> CODEC = LandTypes.TITLE_REGISTRY.byNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, TitleLandType> STREAM_CODEC = ByteBufCodecs.registry(LandTypes.TITLE_KEY);

    public boolean isAspectCompatible(TerrainLandType otherType) {
        return true;
    }

    public void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks, LandBiomeSetType biomeSet) {
    }

    @Override
    public void addStructureSets(Consumer<StructureSet> consumer, HolderGetter<Structure> structureLookup) {
        LandTypeExtensions landTypeExtensions = LandTypeExtensions.get();
        List<LandTypeExtensions.StructureSetExtension> structureSets = landTypeExtensions.getStructureSetsFor(this);
        for (LandTypeExtensions.StructureSetExtension structureSetExtension : structureSets) {
            consumer.accept(structureSetExtension.structureSet());
        }
    }

    public final boolean is(TagKey<TitleLandType> tag) {
        return this.is((HolderSet<TitleLandType>)LandTypes.TITLE_REGISTRY.getOrCreateTag(tag));
    }

    public final boolean is(HolderSet<TitleLandType> set) {
        return set.stream().anyMatch(holder -> holder.value() == this);
    }
}

